// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DeleteDocumentRequest private constructor(builder: Builder) {
    /**
     * The version of the document that you want to delete. If not provided, all versions of the document are deleted.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * Some SSM document types require that you specify a `Force` flag before you can delete the document. For example, you must specify a `Force` flag to delete a document of type `ApplicationConfigurationSchema`. You can restrict access to the `Force` flag in an Identity and Access Management (IAM) policy.
     */
    public val force: kotlin.Boolean? = builder.force
    /**
     * The name of the document.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The version name of the document that you want to delete. If not provided, all versions of the document are deleted.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.DeleteDocumentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDocumentRequest(")
        append("documentVersion=$documentVersion,")
        append("force=$force,")
        append("name=$name,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentVersion?.hashCode() ?: 0
        result = 31 * result + (this.force?.hashCode() ?: 0)
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteDocumentRequest

        if (documentVersion != other.documentVersion) return false
        if (force != other.force) return false
        if (name != other.name) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.DeleteDocumentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The version of the document that you want to delete. If not provided, all versions of the document are deleted.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * Some SSM document types require that you specify a `Force` flag before you can delete the document. For example, you must specify a `Force` flag to delete a document of type `ApplicationConfigurationSchema`. You can restrict access to the `Force` flag in an Identity and Access Management (IAM) policy.
         */
        public var force: kotlin.Boolean? = null
        /**
         * The name of the document.
         */
        public var name: kotlin.String? = null
        /**
         * The version name of the document that you want to delete. If not provided, all versions of the document are deleted.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.DeleteDocumentRequest) : this() {
            this.documentVersion = x.documentVersion
            this.force = x.force
            this.name = x.name
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.DeleteDocumentRequest = DeleteDocumentRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
