// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAssociationRequest private constructor(builder: Builder) {
    /**
     * The details for the CloudWatch alarm you want to apply to an automation or command.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified and when target changes are detected. Specify `true` for `ApplyOnlyAtCronInterval`if you want the association to run only according to the schedule you specified.
     *
     * For more information, see [Understanding when associations are applied to resources](https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#state-manager-about-scheduling) and [>About target updates with Automation runbooks](https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#runbook-target-updates) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * This parameter isn't supported for rate expressions.
     */
    public val applyOnlyAtCronInterval: kotlin.Boolean? = builder.applyOnlyAtCronInterval
    /**
     * Specify a descriptive name for the association.
     */
    public val associationName: kotlin.String? = builder.associationName
    /**
     * Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a tool in Amazon Web Services Systems Manager.
     */
    public val automationTargetParameterName: kotlin.String? = builder.automationTargetParameterName
    /**
     * The names of Amazon Resource Names (ARNs) of the Change Calendar type documents you want to gate your associations under. The associations only run when that change calendar is open. For more information, see [Amazon Web Services Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val calendarNames: List<String>? = builder.calendarNames
    /**
     * The severity level to assign to the association.
     */
    public val complianceSeverity: aws.sdk.kotlin.services.ssm.model.AssociationComplianceSeverity? = builder.complianceSeverity
    /**
     * The document version you want to associate with the targets. Can be a specific version or the default version.
     *
     * State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the `default` version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to `default`.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The number of hours the association can run before it is canceled. Duration applies to associations that are currently running, and any pending and in progress commands on all targets. If a target was taken offline for the association to run, it is made available again immediately, without a reboot.
     *
     * The `Duration` parameter applies only when both these conditions are true:
     * + The association for which you specify a duration is cancelable according to the parameters of the SSM command document or Automation runbook associated with this execution.
     * + The command specifies the ` <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-ApplyOnlyAtCronInterval">ApplyOnlyAtCronInterval</a> ` parameter, which means that the association doesn't run immediately after it is created, but only according to the specified schedule.
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * The managed node ID.
     *
     * `InstanceId` has been deprecated. To specify a managed node ID for an association, use the `Targets` parameter. Requests that include the parameter `InstanceID` with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter `InstanceId`, you can't use the parameters `AssociationName`, `DocumentVersion`, `MaxErrors`, `MaxConcurrency`, `OutputLocation`, or `ScheduleExpression`. To use these parameters, you must use the `Targets` parameter.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.
     *
     * If a new managed node starts and attempts to run an association while Systems Manager is running `MaxConcurrency` associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for `MaxConcurrency`.
     */
    public val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set `MaxError` to 10%, then the system stops sending the request when the sixth error is received.
     *
     * Executions that are already running an association when `MaxErrors` is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set `MaxConcurrency` to 1 so that executions proceed one at a time.
     */
    public val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The name of the SSM Command document or Automation runbook that contains the configuration information for the managed node.
     *
     * You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another Amazon Web Services account.
     *
     * For Systems Manager documents (SSM documents) that are shared with you from other Amazon Web Services accounts, you must specify the complete SSM document ARN, in the following format:
     *
     * `arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> `
     *
     * For example:
     *
     * `arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document`
     *
     * For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, `AWS-ApplyPatchBaseline` or `My-Document`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
     */
    public val outputLocation: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation? = builder.outputLocation
    /**
     * The parameters for the runtime configuration of the document.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * A cron expression when the association will be applied to the targets.
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * Number of days to wait after the scheduled day to run an association. For example, if you specified a cron schedule of `cron(0 0 ? * THU#2 *)`, you could specify an offset of 3 to run the association each Sunday after the second Thursday of the month. For more information about cron schedules for associations, see [Reference: Cron and rate expressions for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * To use offsets, you must specify the `ApplyOnlyAtCronInterval` parameter. This option tells the system not to run an association immediately after you create it.
     */
    public val scheduleOffset: kotlin.Int? = builder.scheduleOffset
    /**
     * The mode for generating association compliance. You can specify `AUTO` or `MANUAL`. In `AUTO` mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is `COMPLIANT`. If the association execution doesn't run successfully, the association is `NON-COMPLIANT`.
     *
     * In `MANUAL` mode, you must specify the `AssociationId` as a parameter for the PutComplianceItems API operation. In this case, compliance data isn't managed by State Manager. It is managed by your direct call to the PutComplianceItems API operation.
     *
     * By default, all associations use `AUTO` mode.
     */
    public val syncCompliance: aws.sdk.kotlin.services.ssm.model.AssociationSyncCompliance? = builder.syncCompliance
    /**
     * Adds or overwrites one or more tags for a State Manager association. *Tags* are metadata that you can assign to your Amazon Web Services resources. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the association. Use this action to create an association in multiple Regions and multiple accounts.
     *
     * The `IncludeChildOrganizationUnits` parameter is not supported by State Manager.
     */
    public val targetLocations: List<TargetLocation>? = builder.targetLocations
    /**
     * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified together.
     */
    public val targetMaps: List<Map<String, List<String>>>? = builder.targetMaps
    /**
     * The targets for the association. You can target managed nodes by using tags, Amazon Web Services resource groups, all managed nodes in an Amazon Web Services account, or individual managed node IDs. You can target all managed nodes in an Amazon Web Services account by specifying the `InstanceIds` key with a value of `*`. For more information about choosing targets for an association, see [Understanding targets and rate controls in State Manager associations](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val targets: List<Target>? = builder.targets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CreateAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAssociationRequest(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("applyOnlyAtCronInterval=$applyOnlyAtCronInterval,")
        append("associationName=$associationName,")
        append("automationTargetParameterName=$automationTargetParameterName,")
        append("calendarNames=$calendarNames,")
        append("complianceSeverity=$complianceSeverity,")
        append("documentVersion=$documentVersion,")
        append("duration=$duration,")
        append("instanceId=$instanceId,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("name=$name,")
        append("outputLocation=$outputLocation,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleOffset=$scheduleOffset,")
        append("syncCompliance=$syncCompliance,")
        append("tags=$tags,")
        append("targetLocations=$targetLocations,")
        append("targetMaps=$targetMaps,")
        append("targets=$targets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (this.applyOnlyAtCronInterval?.hashCode() ?: 0)
        result = 31 * result + (this.associationName?.hashCode() ?: 0)
        result = 31 * result + (this.automationTargetParameterName?.hashCode() ?: 0)
        result = 31 * result + (this.calendarNames?.hashCode() ?: 0)
        result = 31 * result + (this.complianceSeverity?.hashCode() ?: 0)
        result = 31 * result + (this.documentVersion?.hashCode() ?: 0)
        result = 31 * result + (this.duration ?: 0)
        result = 31 * result + (this.instanceId?.hashCode() ?: 0)
        result = 31 * result + (this.maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (this.maxErrors?.hashCode() ?: 0)
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.outputLocation?.hashCode() ?: 0)
        result = 31 * result + (this.parameters?.hashCode() ?: 0)
        result = 31 * result + (this.scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (this.scheduleOffset ?: 0)
        result = 31 * result + (this.syncCompliance?.hashCode() ?: 0)
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        result = 31 * result + (this.targetLocations?.hashCode() ?: 0)
        result = 31 * result + (this.targetMaps?.hashCode() ?: 0)
        result = 31 * result + (this.targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAssociationRequest

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (applyOnlyAtCronInterval != other.applyOnlyAtCronInterval) return false
        if (associationName != other.associationName) return false
        if (automationTargetParameterName != other.automationTargetParameterName) return false
        if (calendarNames != other.calendarNames) return false
        if (complianceSeverity != other.complianceSeverity) return false
        if (documentVersion != other.documentVersion) return false
        if (duration != other.duration) return false
        if (instanceId != other.instanceId) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (name != other.name) return false
        if (outputLocation != other.outputLocation) return false
        if (parameters != other.parameters) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleOffset != other.scheduleOffset) return false
        if (syncCompliance != other.syncCompliance) return false
        if (tags != other.tags) return false
        if (targetLocations != other.targetLocations) return false
        if (targetMaps != other.targetMaps) return false
        if (targets != other.targets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CreateAssociationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The details for the CloudWatch alarm you want to apply to an automation or command.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified and when target changes are detected. Specify `true` for `ApplyOnlyAtCronInterval`if you want the association to run only according to the schedule you specified.
         *
         * For more information, see [Understanding when associations are applied to resources](https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#state-manager-about-scheduling) and [>About target updates with Automation runbooks](https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#runbook-target-updates) in the *Amazon Web Services Systems Manager User Guide*.
         *
         * This parameter isn't supported for rate expressions.
         */
        public var applyOnlyAtCronInterval: kotlin.Boolean? = null
        /**
         * Specify a descriptive name for the association.
         */
        public var associationName: kotlin.String? = null
        /**
         * Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a tool in Amazon Web Services Systems Manager.
         */
        public var automationTargetParameterName: kotlin.String? = null
        /**
         * The names of Amazon Resource Names (ARNs) of the Change Calendar type documents you want to gate your associations under. The associations only run when that change calendar is open. For more information, see [Amazon Web Services Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var calendarNames: List<String>? = null
        /**
         * The severity level to assign to the association.
         */
        public var complianceSeverity: aws.sdk.kotlin.services.ssm.model.AssociationComplianceSeverity? = null
        /**
         * The document version you want to associate with the targets. Can be a specific version or the default version.
         *
         * State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the `default` version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to `default`.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * The number of hours the association can run before it is canceled. Duration applies to associations that are currently running, and any pending and in progress commands on all targets. If a target was taken offline for the association to run, it is made available again immediately, without a reboot.
         *
         * The `Duration` parameter applies only when both these conditions are true:
         * + The association for which you specify a duration is cancelable according to the parameters of the SSM command document or Automation runbook associated with this execution.
         * + The command specifies the ` <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-ApplyOnlyAtCronInterval">ApplyOnlyAtCronInterval</a> ` parameter, which means that the association doesn't run immediately after it is created, but only according to the specified schedule.
         */
        public var duration: kotlin.Int? = null
        /**
         * The managed node ID.
         *
         * `InstanceId` has been deprecated. To specify a managed node ID for an association, use the `Targets` parameter. Requests that include the parameter `InstanceID` with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter `InstanceId`, you can't use the parameters `AssociationName`, `DocumentVersion`, `MaxErrors`, `MaxConcurrency`, `OutputLocation`, or `ScheduleExpression`. To use these parameters, you must use the `Targets` parameter.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.
         *
         * If a new managed node starts and attempts to run an association while Systems Manager is running `MaxConcurrency` associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for `MaxConcurrency`.
         */
        public var maxConcurrency: kotlin.String? = null
        /**
         * The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set `MaxError` to 10%, then the system stops sending the request when the sixth error is received.
         *
         * Executions that are already running an association when `MaxErrors` is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set `MaxConcurrency` to 1 so that executions proceed one at a time.
         */
        public var maxErrors: kotlin.String? = null
        /**
         * The name of the SSM Command document or Automation runbook that contains the configuration information for the managed node.
         *
         * You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another Amazon Web Services account.
         *
         * For Systems Manager documents (SSM documents) that are shared with you from other Amazon Web Services accounts, you must specify the complete SSM document ARN, in the following format:
         *
         * `arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> `
         *
         * For example:
         *
         * `arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document`
         *
         * For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, `AWS-ApplyPatchBaseline` or `My-Document`.
         */
        public var name: kotlin.String? = null
        /**
         * An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
         */
        public var outputLocation: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation? = null
        /**
         * The parameters for the runtime configuration of the document.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * A cron expression when the association will be applied to the targets.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * Number of days to wait after the scheduled day to run an association. For example, if you specified a cron schedule of `cron(0 0 ? * THU#2 *)`, you could specify an offset of 3 to run the association each Sunday after the second Thursday of the month. For more information about cron schedules for associations, see [Reference: Cron and rate expressions for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) in the *Amazon Web Services Systems Manager User Guide*.
         *
         * To use offsets, you must specify the `ApplyOnlyAtCronInterval` parameter. This option tells the system not to run an association immediately after you create it.
         */
        public var scheduleOffset: kotlin.Int? = null
        /**
         * The mode for generating association compliance. You can specify `AUTO` or `MANUAL`. In `AUTO` mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is `COMPLIANT`. If the association execution doesn't run successfully, the association is `NON-COMPLIANT`.
         *
         * In `MANUAL` mode, you must specify the `AssociationId` as a parameter for the PutComplianceItems API operation. In this case, compliance data isn't managed by State Manager. It is managed by your direct call to the PutComplianceItems API operation.
         *
         * By default, all associations use `AUTO` mode.
         */
        public var syncCompliance: aws.sdk.kotlin.services.ssm.model.AssociationSyncCompliance? = null
        /**
         * Adds or overwrites one or more tags for a State Manager association. *Tags* are metadata that you can assign to your Amazon Web Services resources. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define.
         */
        public var tags: List<Tag>? = null
        /**
         * A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the association. Use this action to create an association in multiple Regions and multiple accounts.
         *
         * The `IncludeChildOrganizationUnits` parameter is not supported by State Manager.
         */
        public var targetLocations: List<TargetLocation>? = null
        /**
         * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified together.
         */
        public var targetMaps: List<Map<String, List<String>>>? = null
        /**
         * The targets for the association. You can target managed nodes by using tags, Amazon Web Services resource groups, all managed nodes in an Amazon Web Services account, or individual managed node IDs. You can target all managed nodes in an Amazon Web Services account by specifying the `InstanceIds` key with a value of `*`. For more information about choosing targets for an association, see [Understanding targets and rate controls in State Manager associations](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var targets: List<Target>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CreateAssociationRequest) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.applyOnlyAtCronInterval = x.applyOnlyAtCronInterval
            this.associationName = x.associationName
            this.automationTargetParameterName = x.automationTargetParameterName
            this.calendarNames = x.calendarNames
            this.complianceSeverity = x.complianceSeverity
            this.documentVersion = x.documentVersion
            this.duration = x.duration
            this.instanceId = x.instanceId
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.name = x.name
            this.outputLocation = x.outputLocation
            this.parameters = x.parameters
            this.scheduleExpression = x.scheduleExpression
            this.scheduleOffset = x.scheduleOffset
            this.syncCompliance = x.syncCompliance
            this.tags = x.tags
            this.targetLocations = x.targetLocations
            this.targetMaps = x.targetMaps
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CreateAssociationRequest = CreateAssociationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation] inside the given [block]
         */
        public fun outputLocation(block: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
