// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateActivationRequest private constructor(builder: Builder) {
    /**
     * The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or when you use the Amazon Web Services command line tools to list Systems Manager resources.
     *
     * Don't enter personally identifiable information in this field.
     */
    public val defaultInstanceName: kotlin.String? = builder.defaultInstanceName
    /**
     * A user-defined description of the resource that you want to register with Systems Manager.
     *
     * Don't enter personally identifiable information in this field.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The date by which this activation request should expire, in timestamp format, such as "2024-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires in 24 hours.
     */
    public val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal `ssm.amazonaws.com`. For more information, see [Create the IAM service role required for Systems Manager in a hybrid and multicloud environments](https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-service-role.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     */
    public val iamRole: kotlin.String? = builder.iamRole
    /**
     * Specify the maximum number of managed nodes you want to register. The default value is `1`.
     */
    public val registrationLimit: kotlin.Int? = builder.registrationLimit
    /**
     * Reserved for internal use.
     */
    public val registrationMetadata: List<RegistrationMetadataItem>? = builder.registrationMetadata
    /**
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify the following key-value pairs:
     * + `Key=OS,Value=Windows`
     * + `Key=Environment,Value=Production`
     *
     * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises servers or VMs.
     *
     * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with "mi-". For information about how to add tags to your managed nodes, see AddTagsToResource. For information about how to remove tags from your managed nodes, see RemoveTagsFromResource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CreateActivationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateActivationRequest(")
        append("defaultInstanceName=$defaultInstanceName,")
        append("description=$description,")
        append("expirationDate=$expirationDate,")
        append("iamRole=$iamRole,")
        append("registrationLimit=$registrationLimit,")
        append("registrationMetadata=$registrationMetadata,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultInstanceName?.hashCode() ?: 0
        result = 31 * result + (this.description?.hashCode() ?: 0)
        result = 31 * result + (this.expirationDate?.hashCode() ?: 0)
        result = 31 * result + (this.iamRole?.hashCode() ?: 0)
        result = 31 * result + (this.registrationLimit ?: 0)
        result = 31 * result + (this.registrationMetadata?.hashCode() ?: 0)
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateActivationRequest

        if (defaultInstanceName != other.defaultInstanceName) return false
        if (description != other.description) return false
        if (expirationDate != other.expirationDate) return false
        if (iamRole != other.iamRole) return false
        if (registrationLimit != other.registrationLimit) return false
        if (registrationMetadata != other.registrationMetadata) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CreateActivationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or when you use the Amazon Web Services command line tools to list Systems Manager resources.
         *
         * Don't enter personally identifiable information in this field.
         */
        public var defaultInstanceName: kotlin.String? = null
        /**
         * A user-defined description of the resource that you want to register with Systems Manager.
         *
         * Don't enter personally identifiable information in this field.
         */
        public var description: kotlin.String? = null
        /**
         * The date by which this activation request should expire, in timestamp format, such as "2024-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires in 24 hours.
         */
        public var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal `ssm.amazonaws.com`. For more information, see [Create the IAM service role required for Systems Manager in a hybrid and multicloud environments](https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-service-role.html) in the *Amazon Web Services Systems Manager User Guide*.
         *
         * You can't specify an IAM service-linked role for this parameter. You must create a unique role.
         */
        public var iamRole: kotlin.String? = null
        /**
         * Specify the maximum number of managed nodes you want to register. The default value is `1`.
         */
        public var registrationLimit: kotlin.Int? = null
        /**
         * Reserved for internal use.
         */
        public var registrationMetadata: List<RegistrationMetadataItem>? = null
        /**
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify the following key-value pairs:
         * + `Key=OS,Value=Windows`
         * + `Key=Environment,Value=Production`
         *
         * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises servers or VMs.
         *
         * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with "mi-". For information about how to add tags to your managed nodes, see AddTagsToResource. For information about how to remove tags from your managed nodes, see RemoveTagsFromResource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CreateActivationRequest) : this() {
            this.defaultInstanceName = x.defaultInstanceName
            this.description = x.description
            this.expirationDate = x.expirationDate
            this.iamRole = x.iamRole
            this.registrationLimit = x.registrationLimit
            this.registrationMetadata = x.registrationMetadata
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CreateActivationRequest = CreateActivationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
