// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a compliance item.
 */
public class ComplianceItemEntry private constructor(builder: Builder) {
    /**
     * A "Key": "Value" tag combination for the compliance item.
     */
    public val details: Map<String, String>? = builder.details
    /**
     * The compliance item ID. For example, if the compliance item is a Windows patch, the ID could be the number of the KB article.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low, Informational, Unspecified.
     */
    public val severity: aws.sdk.kotlin.services.ssm.model.ComplianceSeverity = requireNotNull(builder.severity) { "A non-null value must be provided for severity" }
    /**
     * The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
     */
    public val status: aws.sdk.kotlin.services.ssm.model.ComplianceStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The title of the compliance item. For example, if the compliance item is a Windows patch, the title could be the title of the KB article for the patch; for example: Security Update for Active Directory Federation Services.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ComplianceItemEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComplianceItemEntry(")
        append("details=$details,")
        append("id=$id,")
        append("severity=$severity,")
        append("status=$status,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = details?.hashCode() ?: 0
        result = 31 * result + (this.id?.hashCode() ?: 0)
        result = 31 * result + (this.severity.hashCode())
        result = 31 * result + (this.status.hashCode())
        result = 31 * result + (this.title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComplianceItemEntry

        if (details != other.details) return false
        if (id != other.id) return false
        if (severity != other.severity) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ComplianceItemEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A "Key": "Value" tag combination for the compliance item.
         */
        public var details: Map<String, String>? = null
        /**
         * The compliance item ID. For example, if the compliance item is a Windows patch, the ID could be the number of the KB article.
         */
        public var id: kotlin.String? = null
        /**
         * The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low, Informational, Unspecified.
         */
        public var severity: aws.sdk.kotlin.services.ssm.model.ComplianceSeverity? = null
        /**
         * The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
         */
        public var status: aws.sdk.kotlin.services.ssm.model.ComplianceStatus? = null
        /**
         * The title of the compliance item. For example, if the compliance item is a Windows patch, the title could be the title of the KB article for the patch; for example: Security Update for Active Directory Federation Services.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ComplianceItemEntry) : this() {
            this.details = x.details
            this.id = x.id
            this.severity = x.severity
            this.status = x.status
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ComplianceItemEntry = ComplianceItemEntry(this)

        internal fun correctErrors(): Builder {
            if (severity == null) severity = ComplianceSeverity.SdkUnknown("no value provided")
            if (status == null) status = ComplianceStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
