// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a command filter.
 *
 * A managed node ID can't be specified when a command status is `Pending` because the command hasn't run on the node yet.
 */
public class CommandFilter private constructor(builder: Builder) {
    /**
     * The name of the filter.
     *
     * The `ExecutionStage` filter can't be used with the `ListCommandInvocations` operation, only with `ListCommands`.
     */
    public val key: aws.sdk.kotlin.services.ssm.model.CommandFilterKey = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The filter value. Valid values for each filter key are as follows:
     * + **InvokedAfter**: Specify a timestamp to limit your results. For example, specify `2024-07-07T00:00:00Z` to see a list of command executions occurring July 7, 2021, and later.
     * + **InvokedBefore**: Specify a timestamp to limit your results. For example, specify `2024-07-07T00:00:00Z` to see a list of command executions from before July 7, 2021.
     * + **Status**: Specify a valid command status to see a list of all command executions with that status. The status choices depend on the API you call.The status values you can specify for `ListCommands` are:
     *    + `Pending`
     *    + `InProgress`
     *    + `Success`
     *    + `Cancelled`
     *    + `Failed`
     *    + `TimedOut` (this includes both Delivery and Execution time outs)
     *    + `AccessDenied`
     *    + `DeliveryTimedOut`
     *    + `ExecutionTimedOut`
     *    + `Incomplete`
     *    + `NoInstancesInTag`
     *    + `LimitExceeded`
     * The status values you can specify for `ListCommandInvocations` are:
     *    + `Pending`
     *    + `InProgress`
     *    + `Delayed`
     *    + `Success`
     *    + `Cancelled`
     *    + `Failed`
     *    + `TimedOut` (this includes both Delivery and Execution time outs)
     *    + `AccessDenied`
     *    + `DeliveryTimedOut`
     *    + `ExecutionTimedOut`
     *    + `Undeliverable`
     *    + `InvalidPlatform`
     *    + `Terminated`
     * + **DocumentName**: Specify name of the Amazon Web Services Systems Manager document (SSM document) for which you want to see command execution results. For example, specify `AWS-RunPatchBaseline` to see command executions that used this SSM document to perform security patching operations on managed nodes.
     * + **ExecutionStage**: Specify one of the following values (`ListCommands` operations only):
     *    + `Executing`: Returns a list of command executions that are currently still running.
     *    + `Complete`: Returns a list of command executions that have already completed.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CommandFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CommandFilter(")
        append("key=$key,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (this.value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CommandFilter

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CommandFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the filter.
         *
         * The `ExecutionStage` filter can't be used with the `ListCommandInvocations` operation, only with `ListCommands`.
         */
        public var key: aws.sdk.kotlin.services.ssm.model.CommandFilterKey? = null
        /**
         * The filter value. Valid values for each filter key are as follows:
         * + **InvokedAfter**: Specify a timestamp to limit your results. For example, specify `2024-07-07T00:00:00Z` to see a list of command executions occurring July 7, 2021, and later.
         * + **InvokedBefore**: Specify a timestamp to limit your results. For example, specify `2024-07-07T00:00:00Z` to see a list of command executions from before July 7, 2021.
         * + **Status**: Specify a valid command status to see a list of all command executions with that status. The status choices depend on the API you call.The status values you can specify for `ListCommands` are:
         *    + `Pending`
         *    + `InProgress`
         *    + `Success`
         *    + `Cancelled`
         *    + `Failed`
         *    + `TimedOut` (this includes both Delivery and Execution time outs)
         *    + `AccessDenied`
         *    + `DeliveryTimedOut`
         *    + `ExecutionTimedOut`
         *    + `Incomplete`
         *    + `NoInstancesInTag`
         *    + `LimitExceeded`
         * The status values you can specify for `ListCommandInvocations` are:
         *    + `Pending`
         *    + `InProgress`
         *    + `Delayed`
         *    + `Success`
         *    + `Cancelled`
         *    + `Failed`
         *    + `TimedOut` (this includes both Delivery and Execution time outs)
         *    + `AccessDenied`
         *    + `DeliveryTimedOut`
         *    + `ExecutionTimedOut`
         *    + `Undeliverable`
         *    + `InvalidPlatform`
         *    + `Terminated`
         * + **DocumentName**: Specify name of the Amazon Web Services Systems Manager document (SSM document) for which you want to see command execution results. For example, specify `AWS-RunPatchBaseline` to see command executions that used this SSM document to perform security patching operations on managed nodes.
         * + **ExecutionStage**: Specify one of the following values (`ListCommands` operations only):
         *    + `Executing`: Returns a list of command executions that are currently still running.
         *    + `Complete`: Returns a list of command executions that have already completed.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CommandFilter) : this() {
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CommandFilter = CommandFilter(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = CommandFilterKey.SdkUnknown("no value provided")
            if (value == null) value = ""
            return this
        }
    }
}
