// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a command request.
 */
public class Command private constructor(builder: Builder) {
    /**
     * The details for the CloudWatch alarm applied to your command.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command output.
     */
    public val cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = builder.cloudWatchOutputConfig
    /**
     * A unique identifier for this command.
     */
    public val commandId: kotlin.String? = builder.commandId
    /**
     * User-specified information about the command, such as a brief description of what the command should do.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The number of targets for which the command invocation reached a terminal state. Terminal states include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Cancelled, Terminated, or Undeliverable.
     */
    public val completedCount: kotlin.Int = builder.completedCount
    /**
     * The number of targets for which the status is Delivery Timed Out.
     */
    public val deliveryTimedOutCount: kotlin.Int = builder.deliveryTimedOutCount
    /**
     * The name of the document requested for execution.
     */
    public val documentName: kotlin.String? = builder.documentName
    /**
     * The Systems Manager document (SSM document) version.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The number of targets for which the status is Failed or Execution Timed Out.
     */
    public val errorCount: kotlin.Int = builder.errorCount
    /**
     * If a command expires, it changes status to `DeliveryTimedOut` for all invocations that have the status `InProgress`, `Pending`, or `Delayed`. `ExpiresAfter` is calculated based on the total timeout for the overall command. For more information, see [Understanding command timeout values](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html?icmpid=docs_ec2_console#monitor-about-status-timeouts) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val expiresAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.expiresAfter
    /**
     * The managed node IDs against which this command was requested.
     */
    public val instanceIds: List<String>? = builder.instanceIds
    /**
     * The maximum number of managed nodes that are allowed to run the command at the same time. You can specify a number of managed nodes, such as 10, or a percentage of nodes, such as 10%. The default value is 50. For more information about how to use `MaxConcurrency`, see [Amazon Web Services Systems Manager Run Command](https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The maximum number of errors allowed before the system stops sending the command to additional targets. You can specify a number of errors, such as 10, or a percentage or errors, such as 10%. The default value is `0`. For more information about how to use `MaxErrors`, see [Amazon Web Services Systems Manager Run Command](https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * Configurations for sending notifications about command status changes.
     */
    public val notificationConfig: aws.sdk.kotlin.services.ssm.model.NotificationConfig? = builder.notificationConfig
    /**
     * The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the command.
     */
    public val outputS3BucketName: kotlin.String? = builder.outputS3BucketName
    /**
     * The S3 directory path inside the bucket where the responses to the command executions should be stored. This was requested when issuing the command.
     */
    public val outputS3KeyPrefix: kotlin.String? = builder.outputS3KeyPrefix
    /**
     * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon Web Services Region of the S3 bucket.
     */
    public val outputS3Region: kotlin.String? = builder.outputS3Region
    /**
     * The parameter values to be inserted in the document when running the command.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * The date and time the command was requested.
     */
    public val requestedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedDateTime
    /**
     * The Identity and Access Management (IAM) service role that Run Command, a tool in Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The status of the command.
     */
    public val status: aws.sdk.kotlin.services.ssm.model.CommandStatus? = builder.status
    /**
     * A detailed status of the command execution. `StatusDetails` includes more information than `Status` because it includes states resulting from error and concurrency control parameters. `StatusDetails` can show different results than Status. For more information about these statuses, see [Understanding command statuses](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html) in the *Amazon Web Services Systems Manager User Guide*. StatusDetails can be one of the following values:
     * + Pending: The command hasn't been sent to any managed nodes.
     * + In Progress: The command has been sent to at least one managed node but hasn't reached a final state on all managed nodes.
     * + Success: The command successfully ran on all invocations. This is a terminal state.
     * + Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of Delivery Timed Out. This is a terminal state.
     * + Execution Timed Out: The value of MaxErrors or more command invocations shows a status of Execution Timed Out. This is a terminal state.
     * + Failed: The value of MaxErrors or more command invocations shows a status of Failed. This is a terminal state.
     * + Incomplete: The command was attempted on all managed nodes and one or more invocations doesn't have a value of Success but not enough invocations failed for the status to be Failed. This is a terminal state.
     * + Cancelled: The command was terminated before it was completed. This is a terminal state.
     * + Rate Exceeded: The number of managed nodes targeted by the command exceeded the account limit for pending invocations. The system has canceled the command before running it on any managed node. This is a terminal state.
     * + Delayed: The system attempted to send the command to the managed node but wasn't successful. The system retries again.
     */
    public val statusDetails: kotlin.String? = builder.statusDetails
    /**
     * The number of targets for the command.
     */
    public val targetCount: kotlin.Int = builder.targetCount
    /**
     * An array of search criteria that targets managed nodes using a Key,Value combination that you specify. Targets is required if you don't provide one or more managed node IDs in the call.
     */
    public val targets: List<Target>? = builder.targets
    /**
     * The `TimeoutSeconds` value specified for a command.
     */
    public val timeoutSeconds: kotlin.Int? = builder.timeoutSeconds
    /**
     * The CloudWatch alarm that was invoked by the command.
     */
    public val triggeredAlarms: List<AlarmStateInformation>? = builder.triggeredAlarms

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Command = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Command(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("cloudWatchOutputConfig=$cloudWatchOutputConfig,")
        append("commandId=$commandId,")
        append("comment=$comment,")
        append("completedCount=$completedCount,")
        append("deliveryTimedOutCount=$deliveryTimedOutCount,")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("errorCount=$errorCount,")
        append("expiresAfter=$expiresAfter,")
        append("instanceIds=$instanceIds,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("notificationConfig=$notificationConfig,")
        append("outputS3BucketName=$outputS3BucketName,")
        append("outputS3KeyPrefix=$outputS3KeyPrefix,")
        append("outputS3Region=$outputS3Region,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("requestedDateTime=$requestedDateTime,")
        append("serviceRole=$serviceRole,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("targetCount=$targetCount,")
        append("targets=$targets,")
        append("timeoutSeconds=$timeoutSeconds,")
        append("triggeredAlarms=$triggeredAlarms")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (this.cloudWatchOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (this.commandId?.hashCode() ?: 0)
        result = 31 * result + (this.comment?.hashCode() ?: 0)
        result = 31 * result + (this.completedCount)
        result = 31 * result + (this.deliveryTimedOutCount)
        result = 31 * result + (this.documentName?.hashCode() ?: 0)
        result = 31 * result + (this.documentVersion?.hashCode() ?: 0)
        result = 31 * result + (this.errorCount)
        result = 31 * result + (this.expiresAfter?.hashCode() ?: 0)
        result = 31 * result + (this.instanceIds?.hashCode() ?: 0)
        result = 31 * result + (this.maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (this.maxErrors?.hashCode() ?: 0)
        result = 31 * result + (this.notificationConfig?.hashCode() ?: 0)
        result = 31 * result + (this.outputS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (this.outputS3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (this.outputS3Region?.hashCode() ?: 0)
        result = 31 * result + (this.parameters?.hashCode() ?: 0)
        result = 31 * result + (this.requestedDateTime?.hashCode() ?: 0)
        result = 31 * result + (this.serviceRole?.hashCode() ?: 0)
        result = 31 * result + (this.status?.hashCode() ?: 0)
        result = 31 * result + (this.statusDetails?.hashCode() ?: 0)
        result = 31 * result + (this.targetCount)
        result = 31 * result + (this.targets?.hashCode() ?: 0)
        result = 31 * result + (this.timeoutSeconds ?: 0)
        result = 31 * result + (this.triggeredAlarms?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Command

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (cloudWatchOutputConfig != other.cloudWatchOutputConfig) return false
        if (commandId != other.commandId) return false
        if (comment != other.comment) return false
        if (completedCount != other.completedCount) return false
        if (deliveryTimedOutCount != other.deliveryTimedOutCount) return false
        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (errorCount != other.errorCount) return false
        if (expiresAfter != other.expiresAfter) return false
        if (instanceIds != other.instanceIds) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (notificationConfig != other.notificationConfig) return false
        if (outputS3BucketName != other.outputS3BucketName) return false
        if (outputS3KeyPrefix != other.outputS3KeyPrefix) return false
        if (outputS3Region != other.outputS3Region) return false
        if (parameters != other.parameters) return false
        if (requestedDateTime != other.requestedDateTime) return false
        if (serviceRole != other.serviceRole) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (targetCount != other.targetCount) return false
        if (targets != other.targets) return false
        if (timeoutSeconds != other.timeoutSeconds) return false
        if (triggeredAlarms != other.triggeredAlarms) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Command = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The details for the CloudWatch alarm applied to your command.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command output.
         */
        public var cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = null
        /**
         * A unique identifier for this command.
         */
        public var commandId: kotlin.String? = null
        /**
         * User-specified information about the command, such as a brief description of what the command should do.
         */
        public var comment: kotlin.String? = null
        /**
         * The number of targets for which the command invocation reached a terminal state. Terminal states include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Cancelled, Terminated, or Undeliverable.
         */
        public var completedCount: kotlin.Int = 0
        /**
         * The number of targets for which the status is Delivery Timed Out.
         */
        public var deliveryTimedOutCount: kotlin.Int = 0
        /**
         * The name of the document requested for execution.
         */
        public var documentName: kotlin.String? = null
        /**
         * The Systems Manager document (SSM document) version.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * The number of targets for which the status is Failed or Execution Timed Out.
         */
        public var errorCount: kotlin.Int = 0
        /**
         * If a command expires, it changes status to `DeliveryTimedOut` for all invocations that have the status `InProgress`, `Pending`, or `Delayed`. `ExpiresAfter` is calculated based on the total timeout for the overall command. For more information, see [Understanding command timeout values](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html?icmpid=docs_ec2_console#monitor-about-status-timeouts) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var expiresAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The managed node IDs against which this command was requested.
         */
        public var instanceIds: List<String>? = null
        /**
         * The maximum number of managed nodes that are allowed to run the command at the same time. You can specify a number of managed nodes, such as 10, or a percentage of nodes, such as 10%. The default value is 50. For more information about how to use `MaxConcurrency`, see [Amazon Web Services Systems Manager Run Command](https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var maxConcurrency: kotlin.String? = null
        /**
         * The maximum number of errors allowed before the system stops sending the command to additional targets. You can specify a number of errors, such as 10, or a percentage or errors, such as 10%. The default value is `0`. For more information about how to use `MaxErrors`, see [Amazon Web Services Systems Manager Run Command](https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var maxErrors: kotlin.String? = null
        /**
         * Configurations for sending notifications about command status changes.
         */
        public var notificationConfig: aws.sdk.kotlin.services.ssm.model.NotificationConfig? = null
        /**
         * The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the command.
         */
        public var outputS3BucketName: kotlin.String? = null
        /**
         * The S3 directory path inside the bucket where the responses to the command executions should be stored. This was requested when issuing the command.
         */
        public var outputS3KeyPrefix: kotlin.String? = null
        /**
         * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon Web Services Region of the S3 bucket.
         */
        public var outputS3Region: kotlin.String? = null
        /**
         * The parameter values to be inserted in the document when running the command.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * The date and time the command was requested.
         */
        public var requestedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Identity and Access Management (IAM) service role that Run Command, a tool in Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * The status of the command.
         */
        public var status: aws.sdk.kotlin.services.ssm.model.CommandStatus? = null
        /**
         * A detailed status of the command execution. `StatusDetails` includes more information than `Status` because it includes states resulting from error and concurrency control parameters. `StatusDetails` can show different results than Status. For more information about these statuses, see [Understanding command statuses](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html) in the *Amazon Web Services Systems Manager User Guide*. StatusDetails can be one of the following values:
         * + Pending: The command hasn't been sent to any managed nodes.
         * + In Progress: The command has been sent to at least one managed node but hasn't reached a final state on all managed nodes.
         * + Success: The command successfully ran on all invocations. This is a terminal state.
         * + Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of Delivery Timed Out. This is a terminal state.
         * + Execution Timed Out: The value of MaxErrors or more command invocations shows a status of Execution Timed Out. This is a terminal state.
         * + Failed: The value of MaxErrors or more command invocations shows a status of Failed. This is a terminal state.
         * + Incomplete: The command was attempted on all managed nodes and one or more invocations doesn't have a value of Success but not enough invocations failed for the status to be Failed. This is a terminal state.
         * + Cancelled: The command was terminated before it was completed. This is a terminal state.
         * + Rate Exceeded: The number of managed nodes targeted by the command exceeded the account limit for pending invocations. The system has canceled the command before running it on any managed node. This is a terminal state.
         * + Delayed: The system attempted to send the command to the managed node but wasn't successful. The system retries again.
         */
        public var statusDetails: kotlin.String? = null
        /**
         * The number of targets for the command.
         */
        public var targetCount: kotlin.Int = 0
        /**
         * An array of search criteria that targets managed nodes using a Key,Value combination that you specify. Targets is required if you don't provide one or more managed node IDs in the call.
         */
        public var targets: List<Target>? = null
        /**
         * The `TimeoutSeconds` value specified for a command.
         */
        public var timeoutSeconds: kotlin.Int? = null
        /**
         * The CloudWatch alarm that was invoked by the command.
         */
        public var triggeredAlarms: List<AlarmStateInformation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Command) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.cloudWatchOutputConfig = x.cloudWatchOutputConfig
            this.commandId = x.commandId
            this.comment = x.comment
            this.completedCount = x.completedCount
            this.deliveryTimedOutCount = x.deliveryTimedOutCount
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.errorCount = x.errorCount
            this.expiresAfter = x.expiresAfter
            this.instanceIds = x.instanceIds
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.notificationConfig = x.notificationConfig
            this.outputS3BucketName = x.outputS3BucketName
            this.outputS3KeyPrefix = x.outputS3KeyPrefix
            this.outputS3Region = x.outputS3Region
            this.parameters = x.parameters
            this.requestedDateTime = x.requestedDateTime
            this.serviceRole = x.serviceRole
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.targetCount = x.targetCount
            this.targets = x.targets
            this.timeoutSeconds = x.timeoutSeconds
            this.triggeredAlarms = x.triggeredAlarms
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Command = Command(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig] inside the given [block]
         */
        public fun cloudWatchOutputConfig(block: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.Builder.() -> kotlin.Unit) {
            this.cloudWatchOutputConfig = aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.NotificationConfig] inside the given [block]
         */
        public fun notificationConfig(block: aws.sdk.kotlin.services.ssm.model.NotificationConfig.Builder.() -> kotlin.Unit) {
            this.notificationConfig = aws.sdk.kotlin.services.ssm.model.NotificationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
