// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Identifying information about a document attachment, including the file name and a key-value pair that identifies the location of an attachment to a document.
 */
public class AttachmentsSource private constructor(builder: Builder) {
    /**
     * The key of a key-value pair that identifies the location of an attachment to a document.
     */
    public val key: aws.sdk.kotlin.services.ssm.model.AttachmentsSourceKey? = builder.key
    /**
     * The name of the document attachment file.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The value of a key-value pair that identifies the location of an attachment to a document. The format for **Value** depends on the type of key you specify.
     * + For the key *SourceUrl*, the value is an S3 bucket location. For example:`"Values": [ "s3://amzn-s3-demo-bucket/my-prefix" ]`
     * + For the key *S3FileUrl*, the value is a file in an S3 bucket. For example:`"Values": [ "s3://amzn-s3-demo-bucket/my-prefix/my-file.py" ]`
     * + For the key *AttachmentReference*, the value is constructed from the name of another SSM document in your account, a version number of that document, and a file attached to that document version that you want to reuse. For example:`"Values": [ "MyOtherDocument/3/my-other-file.py" ]`However, if the SSM document is shared with you from another account, the full SSM document ARN must be specified instead of the document name only. For example:`"Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py" ]`
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.AttachmentsSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttachmentsSource(")
        append("key=$key,")
        append("name=$name,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttachmentsSource

        if (key != other.key) return false
        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.AttachmentsSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The key of a key-value pair that identifies the location of an attachment to a document.
         */
        public var key: aws.sdk.kotlin.services.ssm.model.AttachmentsSourceKey? = null
        /**
         * The name of the document attachment file.
         */
        public var name: kotlin.String? = null
        /**
         * The value of a key-value pair that identifies the location of an attachment to a document. The format for **Value** depends on the type of key you specify.
         * + For the key *SourceUrl*, the value is an S3 bucket location. For example:`"Values": [ "s3://amzn-s3-demo-bucket/my-prefix" ]`
         * + For the key *S3FileUrl*, the value is a file in an S3 bucket. For example:`"Values": [ "s3://amzn-s3-demo-bucket/my-prefix/my-file.py" ]`
         * + For the key *AttachmentReference*, the value is constructed from the name of another SSM document in your account, a version number of that document, and a file attached to that document version that you want to reuse. For example:`"Values": [ "MyOtherDocument/3/my-other-file.py" ]`However, if the SSM document is shared with you from another account, the full SSM document ARN must be specified instead of the document name only. For example:`"Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py" ]`
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.AttachmentsSource) : this() {
            this.key = x.key
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.AttachmentsSource = AttachmentsSource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
