// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details for the CloudWatch alarm you want to apply to an automation or command.
 */
public class AlarmConfiguration private constructor(builder: Builder) {
    /**
     * The name of the CloudWatch alarm specified in the configuration.
     */
    public val alarms: List<Alarm> = requireNotNull(builder.alarms) { "A non-null value must be provided for alarms" }
    /**
     * When this value is *true*, your automation or command continues to run in cases where we can’t retrieve alarm status information from CloudWatch. In cases where we successfully retrieve an alarm status of OK or INSUFFICIENT_DATA, the automation or command continues to run, regardless of this value. Default is *false*.
     */
    public val ignorePollAlarmFailure: kotlin.Boolean = builder.ignorePollAlarmFailure

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.AlarmConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlarmConfiguration(")
        append("alarms=$alarms,")
        append("ignorePollAlarmFailure=$ignorePollAlarmFailure")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarms.hashCode()
        result = 31 * result + (this.ignorePollAlarmFailure.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlarmConfiguration

        if (alarms != other.alarms) return false
        if (ignorePollAlarmFailure != other.ignorePollAlarmFailure) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.AlarmConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the CloudWatch alarm specified in the configuration.
         */
        public var alarms: List<Alarm>? = null
        /**
         * When this value is *true*, your automation or command continues to run in cases where we can’t retrieve alarm status information from CloudWatch. In cases where we successfully retrieve an alarm status of OK or INSUFFICIENT_DATA, the automation or command continues to run, regardless of this value. Default is *false*.
         */
        public var ignorePollAlarmFailure: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration) : this() {
            this.alarms = x.alarms
            this.ignorePollAlarmFailure = x.ignorePollAlarmFailure
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.AlarmConfiguration = AlarmConfiguration(this)

        internal fun correctErrors(): Builder {
            if (alarms == null) alarms = emptyList()
            return this
        }
    }
}
