// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines the high-level patch compliance state for a managed node, providing information about the number of installed, missing, not applicable, and failed patches along with metadata about the operation when this information was gathered for the managed node.
 */
public class InstancePatchState private constructor(builder: Builder) {
    /**
     * The number of security-related patches that are available but not approved because they didn't meet the patch baseline requirements. For example, an updated version of a patch might have been released before the specified auto-approval period was over.
     *
     * Applies to Windows Server managed nodes only.
     */
    public val availableSecurityUpdateCount: kotlin.Int? = builder.availableSecurityUpdateCount
    /**
     * The ID of the patch baseline used to patch the managed node.
     */
    public val baselineId: kotlin.String = requireNotNull(builder.baselineId) { "A non-null value must be provided for baselineId" }
    /**
     * The number of patches per node that are specified as `Critical` for compliance reporting in the patch baseline aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is `NON_COMPLIANT`.
     */
    public val criticalNonCompliantCount: kotlin.Int? = builder.criticalNonCompliantCount
    /**
     * The number of patches from the patch baseline that were attempted to be installed during the last patching operation, but failed to install.
     */
    public val failedCount: kotlin.Int = builder.failedCount
    /**
     * An https URL or an Amazon Simple Storage Service (Amazon S3) path-style URL to a list of patches to be installed. This patch installation list, which you maintain in an S3 bucket in YAML format and specify in the SSM document `AWS-RunPatchBaseline`, overrides the patches specified by the default patch baseline.
     *
     * For more information about the `InstallOverrideList` parameter, see `AWS-RunPatchBaseline`[SSM Command document for patching: ](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-about-aws-runpatchbaseline.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val installOverrideList: kotlin.String? = builder.installOverrideList
    /**
     * The number of patches from the patch baseline that are installed on the managed node.
     */
    public val installedCount: kotlin.Int = builder.installedCount
    /**
     * The number of patches not specified in the patch baseline that are installed on the managed node.
     */
    public val installedOtherCount: kotlin.Int = builder.installedOtherCount
    /**
     * The number of patches installed by Patch Manager since the last time the managed node was rebooted.
     */
    public val installedPendingRebootCount: kotlin.Int? = builder.installedPendingRebootCount
    /**
     * The number of patches installed on a managed node that are specified in a `RejectedPatches` list. Patches with a status of `InstalledRejected` were typically installed before they were added to a `RejectedPatches` list.
     *
     * If `ALLOW_AS_DEPENDENCY` is the specified option for `RejectedPatchesAction`, the value of `InstalledRejectedCount` will always be `0` (zero).
     */
    public val installedRejectedCount: kotlin.Int? = builder.installedRejectedCount
    /**
     * The ID of the managed node the high-level patch compliance information was collected for.
     */
    public val instanceId: kotlin.String = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The time of the last attempt to patch the managed node with `NoReboot` specified as the reboot option.
     */
    public val lastNoRebootInstallOperationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastNoRebootInstallOperationTime
    /**
     * The number of patches from the patch baseline that are applicable for the managed node but aren't currently installed.
     */
    public val missingCount: kotlin.Int = builder.missingCount
    /**
     * The number of patches from the patch baseline that aren't applicable for the managed node and therefore aren't installed on the node. This number may be truncated if the list of patch names is very large. The number of patches beyond this limit are reported in `UnreportedNotApplicableCount`.
     */
    public val notApplicableCount: kotlin.Int = builder.notApplicableCount
    /**
     * The type of patching operation that was performed: or
     * + `SCAN` assesses the patch compliance state.
     * + `INSTALL` installs missing patches.
     */
    public val operation: aws.sdk.kotlin.services.ssm.model.PatchOperationType = requireNotNull(builder.operation) { "A non-null value must be provided for operation" }
    /**
     * The time the most recent patching operation completed on the managed node.
     */
    public val operationEndTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.operationEndTime) { "A non-null value must be provided for operationEndTime" }
    /**
     * The time the most recent patching operation was started on the managed node.
     */
    public val operationStartTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.operationStartTime) { "A non-null value must be provided for operationStartTime" }
    /**
     * The number of patches per node that are specified as other than `Critical` or `Security` but aren't compliant with the patch baseline. The status of these managed nodes is `NON_COMPLIANT`.
     */
    public val otherNonCompliantCount: kotlin.Int? = builder.otherNonCompliantCount
    /**
     * Placeholder information. This field will always be empty in the current release of the service.
     */
    public val ownerInformation: kotlin.String? = builder.ownerInformation
    /**
     * The name of the patch group the managed node belongs to.
     */
    public val patchGroup: kotlin.String = requireNotNull(builder.patchGroup) { "A non-null value must be provided for patchGroup" }
    /**
     * Indicates the reboot option specified in the patch baseline.
     *
     * Reboot options apply to `Install` operations only. Reboots aren't attempted for Patch Manager `Scan` operations.
     *
     * + `RebootIfNeeded`: Patch Manager tries to reboot the managed node if it installed any patches, or if any patches are detected with a status of `InstalledPendingReboot`.
     * + `NoReboot`: Patch Manager attempts to install missing packages without trying to reboot the system. Patches installed with this option are assigned a status of `InstalledPendingReboot`. These patches might not be in effect until a reboot is performed.
     */
    public val rebootOption: aws.sdk.kotlin.services.ssm.model.RebootOption? = builder.rebootOption
    /**
     * The number of patches per node that are specified as `Security` in a patch advisory aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is `NON_COMPLIANT`.
     */
    public val securityNonCompliantCount: kotlin.Int? = builder.securityNonCompliantCount
    /**
     * The ID of the patch baseline snapshot used during the patching operation when this compliance data was collected.
     */
    public val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The number of patches beyond the supported limit of `NotApplicableCount` that aren't reported by name to Inventory. Inventory is a tool in Amazon Web Services Systems Manager.
     */
    public val unreportedNotApplicableCount: kotlin.Int? = builder.unreportedNotApplicableCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InstancePatchState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstancePatchState(")
        append("availableSecurityUpdateCount=$availableSecurityUpdateCount,")
        append("baselineId=$baselineId,")
        append("criticalNonCompliantCount=$criticalNonCompliantCount,")
        append("failedCount=$failedCount,")
        append("installOverrideList=$installOverrideList,")
        append("installedCount=$installedCount,")
        append("installedOtherCount=$installedOtherCount,")
        append("installedPendingRebootCount=$installedPendingRebootCount,")
        append("installedRejectedCount=$installedRejectedCount,")
        append("instanceId=$instanceId,")
        append("lastNoRebootInstallOperationTime=$lastNoRebootInstallOperationTime,")
        append("missingCount=$missingCount,")
        append("notApplicableCount=$notApplicableCount,")
        append("operation=$operation,")
        append("operationEndTime=$operationEndTime,")
        append("operationStartTime=$operationStartTime,")
        append("otherNonCompliantCount=$otherNonCompliantCount,")
        append("ownerInformation=*** Sensitive Data Redacted ***,")
        append("patchGroup=$patchGroup,")
        append("rebootOption=$rebootOption,")
        append("securityNonCompliantCount=$securityNonCompliantCount,")
        append("snapshotId=$snapshotId,")
        append("unreportedNotApplicableCount=$unreportedNotApplicableCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availableSecurityUpdateCount ?: 0
        result = 31 * result + (baselineId.hashCode())
        result = 31 * result + (criticalNonCompliantCount ?: 0)
        result = 31 * result + (failedCount)
        result = 31 * result + (installOverrideList?.hashCode() ?: 0)
        result = 31 * result + (installedCount)
        result = 31 * result + (installedOtherCount)
        result = 31 * result + (installedPendingRebootCount ?: 0)
        result = 31 * result + (installedRejectedCount ?: 0)
        result = 31 * result + (instanceId.hashCode())
        result = 31 * result + (lastNoRebootInstallOperationTime?.hashCode() ?: 0)
        result = 31 * result + (missingCount)
        result = 31 * result + (notApplicableCount)
        result = 31 * result + (operation.hashCode())
        result = 31 * result + (operationEndTime.hashCode())
        result = 31 * result + (operationStartTime.hashCode())
        result = 31 * result + (otherNonCompliantCount ?: 0)
        result = 31 * result + (ownerInformation?.hashCode() ?: 0)
        result = 31 * result + (patchGroup.hashCode())
        result = 31 * result + (rebootOption?.hashCode() ?: 0)
        result = 31 * result + (securityNonCompliantCount ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (unreportedNotApplicableCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstancePatchState

        if (availableSecurityUpdateCount != other.availableSecurityUpdateCount) return false
        if (baselineId != other.baselineId) return false
        if (criticalNonCompliantCount != other.criticalNonCompliantCount) return false
        if (failedCount != other.failedCount) return false
        if (installOverrideList != other.installOverrideList) return false
        if (installedCount != other.installedCount) return false
        if (installedOtherCount != other.installedOtherCount) return false
        if (installedPendingRebootCount != other.installedPendingRebootCount) return false
        if (installedRejectedCount != other.installedRejectedCount) return false
        if (instanceId != other.instanceId) return false
        if (lastNoRebootInstallOperationTime != other.lastNoRebootInstallOperationTime) return false
        if (missingCount != other.missingCount) return false
        if (notApplicableCount != other.notApplicableCount) return false
        if (operation != other.operation) return false
        if (operationEndTime != other.operationEndTime) return false
        if (operationStartTime != other.operationStartTime) return false
        if (otherNonCompliantCount != other.otherNonCompliantCount) return false
        if (ownerInformation != other.ownerInformation) return false
        if (patchGroup != other.patchGroup) return false
        if (rebootOption != other.rebootOption) return false
        if (securityNonCompliantCount != other.securityNonCompliantCount) return false
        if (snapshotId != other.snapshotId) return false
        if (unreportedNotApplicableCount != other.unreportedNotApplicableCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InstancePatchState = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of security-related patches that are available but not approved because they didn't meet the patch baseline requirements. For example, an updated version of a patch might have been released before the specified auto-approval period was over.
         *
         * Applies to Windows Server managed nodes only.
         */
        public var availableSecurityUpdateCount: kotlin.Int? = null
        /**
         * The ID of the patch baseline used to patch the managed node.
         */
        public var baselineId: kotlin.String? = null
        /**
         * The number of patches per node that are specified as `Critical` for compliance reporting in the patch baseline aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is `NON_COMPLIANT`.
         */
        public var criticalNonCompliantCount: kotlin.Int? = null
        /**
         * The number of patches from the patch baseline that were attempted to be installed during the last patching operation, but failed to install.
         */
        public var failedCount: kotlin.Int = 0
        /**
         * An https URL or an Amazon Simple Storage Service (Amazon S3) path-style URL to a list of patches to be installed. This patch installation list, which you maintain in an S3 bucket in YAML format and specify in the SSM document `AWS-RunPatchBaseline`, overrides the patches specified by the default patch baseline.
         *
         * For more information about the `InstallOverrideList` parameter, see `AWS-RunPatchBaseline`[SSM Command document for patching: ](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-about-aws-runpatchbaseline.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var installOverrideList: kotlin.String? = null
        /**
         * The number of patches from the patch baseline that are installed on the managed node.
         */
        public var installedCount: kotlin.Int = 0
        /**
         * The number of patches not specified in the patch baseline that are installed on the managed node.
         */
        public var installedOtherCount: kotlin.Int = 0
        /**
         * The number of patches installed by Patch Manager since the last time the managed node was rebooted.
         */
        public var installedPendingRebootCount: kotlin.Int? = null
        /**
         * The number of patches installed on a managed node that are specified in a `RejectedPatches` list. Patches with a status of `InstalledRejected` were typically installed before they were added to a `RejectedPatches` list.
         *
         * If `ALLOW_AS_DEPENDENCY` is the specified option for `RejectedPatchesAction`, the value of `InstalledRejectedCount` will always be `0` (zero).
         */
        public var installedRejectedCount: kotlin.Int? = null
        /**
         * The ID of the managed node the high-level patch compliance information was collected for.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The time of the last attempt to patch the managed node with `NoReboot` specified as the reboot option.
         */
        public var lastNoRebootInstallOperationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of patches from the patch baseline that are applicable for the managed node but aren't currently installed.
         */
        public var missingCount: kotlin.Int = 0
        /**
         * The number of patches from the patch baseline that aren't applicable for the managed node and therefore aren't installed on the node. This number may be truncated if the list of patch names is very large. The number of patches beyond this limit are reported in `UnreportedNotApplicableCount`.
         */
        public var notApplicableCount: kotlin.Int = 0
        /**
         * The type of patching operation that was performed: or
         * + `SCAN` assesses the patch compliance state.
         * + `INSTALL` installs missing patches.
         */
        public var operation: aws.sdk.kotlin.services.ssm.model.PatchOperationType? = null
        /**
         * The time the most recent patching operation completed on the managed node.
         */
        public var operationEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the most recent patching operation was started on the managed node.
         */
        public var operationStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of patches per node that are specified as other than `Critical` or `Security` but aren't compliant with the patch baseline. The status of these managed nodes is `NON_COMPLIANT`.
         */
        public var otherNonCompliantCount: kotlin.Int? = null
        /**
         * Placeholder information. This field will always be empty in the current release of the service.
         */
        public var ownerInformation: kotlin.String? = null
        /**
         * The name of the patch group the managed node belongs to.
         */
        public var patchGroup: kotlin.String? = null
        /**
         * Indicates the reboot option specified in the patch baseline.
         *
         * Reboot options apply to `Install` operations only. Reboots aren't attempted for Patch Manager `Scan` operations.
         *
         * + `RebootIfNeeded`: Patch Manager tries to reboot the managed node if it installed any patches, or if any patches are detected with a status of `InstalledPendingReboot`.
         * + `NoReboot`: Patch Manager attempts to install missing packages without trying to reboot the system. Patches installed with this option are assigned a status of `InstalledPendingReboot`. These patches might not be in effect until a reboot is performed.
         */
        public var rebootOption: aws.sdk.kotlin.services.ssm.model.RebootOption? = null
        /**
         * The number of patches per node that are specified as `Security` in a patch advisory aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is `NON_COMPLIANT`.
         */
        public var securityNonCompliantCount: kotlin.Int? = null
        /**
         * The ID of the patch baseline snapshot used during the patching operation when this compliance data was collected.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * The number of patches beyond the supported limit of `NotApplicableCount` that aren't reported by name to Inventory. Inventory is a tool in Amazon Web Services Systems Manager.
         */
        public var unreportedNotApplicableCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InstancePatchState) : this() {
            this.availableSecurityUpdateCount = x.availableSecurityUpdateCount
            this.baselineId = x.baselineId
            this.criticalNonCompliantCount = x.criticalNonCompliantCount
            this.failedCount = x.failedCount
            this.installOverrideList = x.installOverrideList
            this.installedCount = x.installedCount
            this.installedOtherCount = x.installedOtherCount
            this.installedPendingRebootCount = x.installedPendingRebootCount
            this.installedRejectedCount = x.installedRejectedCount
            this.instanceId = x.instanceId
            this.lastNoRebootInstallOperationTime = x.lastNoRebootInstallOperationTime
            this.missingCount = x.missingCount
            this.notApplicableCount = x.notApplicableCount
            this.operation = x.operation
            this.operationEndTime = x.operationEndTime
            this.operationStartTime = x.operationStartTime
            this.otherNonCompliantCount = x.otherNonCompliantCount
            this.ownerInformation = x.ownerInformation
            this.patchGroup = x.patchGroup
            this.rebootOption = x.rebootOption
            this.securityNonCompliantCount = x.securityNonCompliantCount
            this.snapshotId = x.snapshotId
            this.unreportedNotApplicableCount = x.unreportedNotApplicableCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InstancePatchState = InstancePatchState(this)

        internal fun correctErrors(): Builder {
            if (baselineId == null) baselineId = ""
            if (instanceId == null) instanceId = ""
            if (operation == null) operation = PatchOperationType.SdkUnknown("no value provided")
            if (operationEndTime == null) operationEndTime = Instant.fromEpochSeconds(0)
            if (operationStartTime == null) operationStartTime = Instant.fromEpochSeconds(0)
            if (patchGroup == null) patchGroup = ""
            return this
        }
    }
}
