// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.ListInventoryEntriesResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class ListInventoryEntriesOperationDeserializer: HttpDeserializer.NonStreaming<ListInventoryEntriesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListInventoryEntriesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListInventoryEntriesError(context, call, payload)
        }
        val builder = ListInventoryEntriesResponse.Builder()

        if (payload != null) {
            deserializeListInventoryEntriesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListInventoryEntriesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidFilter" -> InvalidFilterDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidNextToken" -> InvalidNextTokenDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTypeNameException" -> InvalidTypeNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListInventoryEntriesOperationBody(builder: ListInventoryEntriesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPTURETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CaptureTime"))
    val ENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Entries"))
    val ENTRIES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceId"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SCHEMAVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SchemaVersion"))
    val TYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TypeName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPTURETIME_DESCRIPTOR)
        field(ENTRIES_DESCRIPTOR)
        field(INSTANCEID_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SCHEMAVERSION_DESCRIPTOR)
        field(TYPENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPTURETIME_DESCRIPTOR.index -> builder.captureTime = deserializeString()
                ENTRIES_DESCRIPTOR.index -> builder.entries =
                    deserializer.deserializeList(ENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Map<String, String>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeMap(ENTRIES_C0_DESCRIPTOR) {
                                val map1 = mutableMapOf<String, String>()
                                while (hasNextEntry()) {
                                    val k1 = key()
                                    val v1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                    map1[k1] = v1
                                }
                                map1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                INSTANCEID_DESCRIPTOR.index -> builder.instanceId = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SCHEMAVERSION_DESCRIPTOR.index -> builder.schemaVersion = deserializeString()
                TYPENAME_DESCRIPTOR.index -> builder.typeName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
