// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.AssociationDescription
import aws.sdk.kotlin.services.ssm.model.CreateAssociationBatchResponse
import aws.sdk.kotlin.services.ssm.model.FailedCreateAssociation
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateAssociationBatchOperationDeserializer: HttpDeserializer.NonStreaming<CreateAssociationBatchResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateAssociationBatchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAssociationBatchError(context, call, payload)
        }
        val builder = CreateAssociationBatchResponse.Builder()

        if (payload != null) {
            deserializeCreateAssociationBatchOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateAssociationBatchError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AssociationLimitExceeded" -> AssociationLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "DuplicateInstanceId" -> DuplicateInstanceIdDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocument" -> InvalidDocumentDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocumentVersion" -> InvalidDocumentVersionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOutputLocation" -> InvalidOutputLocationDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameters" -> InvalidParametersDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSchedule" -> InvalidScheduleDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTarget" -> InvalidTargetDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTargetMaps" -> InvalidTargetMapsDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedPlatformType" -> UnsupportedPlatformTypeDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAssociationBatchOperationBody(builder: CreateAssociationBatchResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Failed"))
    val SUCCESSFUL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Successful"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILED_DESCRIPTOR)
        field(SUCCESSFUL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILED_DESCRIPTOR.index -> builder.failed =
                    deserializer.deserializeList(FAILED_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedCreateAssociation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedCreateAssociationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSFUL_DESCRIPTOR.index -> builder.successful =
                    deserializer.deserializeList(SUCCESSFUL_DESCRIPTOR) {
                        val col0 = mutableListOf<AssociationDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssociationDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
