// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An array of search criteria that targets managed nodes using a key-value pair that you specify.
 *
 *  One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don't specify targets, see [Registering maintenance window tasks without targets](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) in the *Amazon Web Services Systems Manager User Guide*.
 *
 * Supported formats include the following.
 *
 * **For all Systems Manager tools:**
 * + `Key=tag-key,Values=tag-value-1,tag-value-2`
 *
 * **For Automation and Change Manager:**
 * + `Key=tag:tag-key,Values=tag-value`
 * + `Key=ResourceGroup,Values=resource-group-name`
 * + `Key=ParameterValues,Values=value-1,value-2,value-3`
 * + To target all instances in the Amazon Web Services Region:
 *    + `Key=AWS::EC2::Instance,Values=*`
 *    + `Key=InstanceIds,Values=*`
 *
 * **For Run Command and Maintenance Windows:**
 * + `Key=InstanceIds,Values=instance-id-1,instance-id-2,instance-id-3`
 * + `Key=tag:tag-key,Values=tag-value-1,tag-value-2`
 * + `Key=resource-groups:Name,Values=resource-group-name`
 * + Additionally, Maintenance Windows support targeting resource types:
 *    + `Key=resource-groups:ResourceTypeFilters,Values=resource-type-1,resource-type-2`
 *
 * **For State Manager:**
 * + `Key=InstanceIds,Values=instance-id-1,instance-id-2,instance-id-3`
 * + `Key=tag:tag-key,Values=tag-value-1,tag-value-2`
 * + To target all instances in the Amazon Web Services Region:
 *    + `Key=InstanceIds,Values=*`
 *
 * For more information about how to send commands that target managed nodes using `Key,Value` parameters, see [Targeting multiple managed nodes](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-targeting) in the *Amazon Web Services Systems Manager User Guide*.
 */
public class Target private constructor(builder: Builder) {
    /**
     * User-defined criteria for sending commands that target managed nodes that meet the criteria.
     */
    public val key: kotlin.String? = builder.key
    /**
     * User-defined criteria that maps to `Key`. For example, if you specified `tag:ServerRole`, you could specify `value:WebServer` to run a command on instances that include EC2 tags of `ServerRole,WebServer`.
     *
     * Depending on the type of target, the maximum number of values for a key might be lower than the global maximum of 50.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Target = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Target(")
        append("key=$key,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Target

        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Target = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * User-defined criteria for sending commands that target managed nodes that meet the criteria.
         */
        public var key: kotlin.String? = null
        /**
         * User-defined criteria that maps to `Key`. For example, if you specified `tag:ServerRole`, you could specify `value:WebServer` to run a command on instances that include EC2 tags of `ServerRole,WebServer`.
         *
         * Depending on the type of target, the maximum number of values for a key might be lower than the global maximum of 50.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Target) : this() {
            this.key = x.key
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Target = Target(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
