// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An invocation is a copy of a command sent to a specific managed node. A command can apply to one or more managed nodes. A command invocation applies to one managed node. For example, if a user runs `SendCommand` against three managed nodes, then a command invocation is created for each requested managed node ID. A command invocation returns status and detail information about a command you ran.
 */
public class CommandInvocation private constructor(builder: Builder) {
    /**
     * Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command output.
     */
    public val cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = builder.cloudWatchOutputConfig
    /**
     * The command against which this invocation was requested.
     */
    public val commandId: kotlin.String? = builder.commandId
    /**
     * Plugins processed by the command.
     */
    public val commandPlugins: List<CommandPlugin>? = builder.commandPlugins
    /**
     * User-specified information about the command, such as a brief description of what the command should do.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The document name that was requested for execution.
     */
    public val documentName: kotlin.String? = builder.documentName
    /**
     * The Systems Manager document (SSM document) version.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The managed node ID in which this invocation was requested.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The fully qualified host name of the managed node.
     */
    public val instanceName: kotlin.String? = builder.instanceName
    /**
     * Configurations for sending notifications about command status changes on a per managed node basis.
     */
    public val notificationConfig: aws.sdk.kotlin.services.ssm.model.NotificationConfig? = builder.notificationConfig
    /**
     * The time and date the request was sent to this managed node.
     */
    public val requestedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedDateTime
    /**
     * The Identity and Access Management (IAM) service role that Run Command, a tool in Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes on a per managed node basis.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The URL to the plugin's StdErr file in Amazon Simple Storage Service (Amazon S3), if the S3 bucket was defined for the parent command. For an invocation, `StandardErrorUrl` is populated if there is just one plugin defined for the command, and the S3 bucket was defined for the command.
     */
    public val standardErrorUrl: kotlin.String? = builder.standardErrorUrl
    /**
     * The URL to the plugin's StdOut file in Amazon Simple Storage Service (Amazon S3), if the S3 bucket was defined for the parent command. For an invocation, `StandardOutputUrl` is populated if there is just one plugin defined for the command, and the S3 bucket was defined for the command.
     */
    public val standardOutputUrl: kotlin.String? = builder.standardOutputUrl
    /**
     * Whether or not the invocation succeeded, failed, or is pending.
     */
    public val status: aws.sdk.kotlin.services.ssm.model.CommandInvocationStatus? = builder.status
    /**
     * A detailed status of the command execution for each invocation (each managed node targeted by the command). StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see [Understanding command statuses](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html) in the *Amazon Web Services Systems Manager User Guide*. StatusDetails can be one of the following values:
     * + Pending: The command hasn't been sent to the managed node.
     * + In Progress: The command has been sent to the managed node but hasn't reached a terminal state.
     * + Success: The execution of the command or plugin was successfully completed. This is a terminal state.
     * + Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's `MaxErrors` limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     * + Execution Timed Out: Command execution started on the managed node, but the execution wasn't complete before the execution timeout expired. Execution timeouts count against the `MaxErrors` limit of the parent command. This is a terminal state.
     * + Failed: The command wasn't successful on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the `MaxErrors` limit of the parent command. This is a terminal state.
     * + Cancelled: The command was terminated before it was completed. This is a terminal state.
     * + Undeliverable: The command can't be delivered to the managed node. The managed node might not exist or might not be responding. Undeliverable invocations don't count against the parent command's MaxErrors limit and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     * + Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.
     * + Delayed: The system attempted to send the command to the managed node but wasn't successful. The system retries again.
     */
    public val statusDetails: kotlin.String? = builder.statusDetails
    /**
     * Gets the trace output sent by the agent.
     */
    public val traceOutput: kotlin.String? = builder.traceOutput

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CommandInvocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CommandInvocation(")
        append("cloudWatchOutputConfig=$cloudWatchOutputConfig,")
        append("commandId=$commandId,")
        append("commandPlugins=$commandPlugins,")
        append("comment=$comment,")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("instanceId=$instanceId,")
        append("instanceName=$instanceName,")
        append("notificationConfig=$notificationConfig,")
        append("requestedDateTime=$requestedDateTime,")
        append("serviceRole=$serviceRole,")
        append("standardErrorUrl=$standardErrorUrl,")
        append("standardOutputUrl=$standardOutputUrl,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("traceOutput=$traceOutput")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchOutputConfig?.hashCode() ?: 0
        result = 31 * result + (commandId?.hashCode() ?: 0)
        result = 31 * result + (commandPlugins?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (documentName?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceName?.hashCode() ?: 0)
        result = 31 * result + (notificationConfig?.hashCode() ?: 0)
        result = 31 * result + (requestedDateTime?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (standardErrorUrl?.hashCode() ?: 0)
        result = 31 * result + (standardOutputUrl?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (traceOutput?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CommandInvocation

        if (cloudWatchOutputConfig != other.cloudWatchOutputConfig) return false
        if (commandId != other.commandId) return false
        if (commandPlugins != other.commandPlugins) return false
        if (comment != other.comment) return false
        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (instanceId != other.instanceId) return false
        if (instanceName != other.instanceName) return false
        if (notificationConfig != other.notificationConfig) return false
        if (requestedDateTime != other.requestedDateTime) return false
        if (serviceRole != other.serviceRole) return false
        if (standardErrorUrl != other.standardErrorUrl) return false
        if (standardOutputUrl != other.standardOutputUrl) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (traceOutput != other.traceOutput) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CommandInvocation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command output.
         */
        public var cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = null
        /**
         * The command against which this invocation was requested.
         */
        public var commandId: kotlin.String? = null
        /**
         * Plugins processed by the command.
         */
        public var commandPlugins: List<CommandPlugin>? = null
        /**
         * User-specified information about the command, such as a brief description of what the command should do.
         */
        public var comment: kotlin.String? = null
        /**
         * The document name that was requested for execution.
         */
        public var documentName: kotlin.String? = null
        /**
         * The Systems Manager document (SSM document) version.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * The managed node ID in which this invocation was requested.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The fully qualified host name of the managed node.
         */
        public var instanceName: kotlin.String? = null
        /**
         * Configurations for sending notifications about command status changes on a per managed node basis.
         */
        public var notificationConfig: aws.sdk.kotlin.services.ssm.model.NotificationConfig? = null
        /**
         * The time and date the request was sent to this managed node.
         */
        public var requestedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Identity and Access Management (IAM) service role that Run Command, a tool in Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes on a per managed node basis.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * The URL to the plugin's StdErr file in Amazon Simple Storage Service (Amazon S3), if the S3 bucket was defined for the parent command. For an invocation, `StandardErrorUrl` is populated if there is just one plugin defined for the command, and the S3 bucket was defined for the command.
         */
        public var standardErrorUrl: kotlin.String? = null
        /**
         * The URL to the plugin's StdOut file in Amazon Simple Storage Service (Amazon S3), if the S3 bucket was defined for the parent command. For an invocation, `StandardOutputUrl` is populated if there is just one plugin defined for the command, and the S3 bucket was defined for the command.
         */
        public var standardOutputUrl: kotlin.String? = null
        /**
         * Whether or not the invocation succeeded, failed, or is pending.
         */
        public var status: aws.sdk.kotlin.services.ssm.model.CommandInvocationStatus? = null
        /**
         * A detailed status of the command execution for each invocation (each managed node targeted by the command). StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see [Understanding command statuses](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html) in the *Amazon Web Services Systems Manager User Guide*. StatusDetails can be one of the following values:
         * + Pending: The command hasn't been sent to the managed node.
         * + In Progress: The command has been sent to the managed node but hasn't reached a terminal state.
         * + Success: The execution of the command or plugin was successfully completed. This is a terminal state.
         * + Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's `MaxErrors` limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         * + Execution Timed Out: Command execution started on the managed node, but the execution wasn't complete before the execution timeout expired. Execution timeouts count against the `MaxErrors` limit of the parent command. This is a terminal state.
         * + Failed: The command wasn't successful on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the `MaxErrors` limit of the parent command. This is a terminal state.
         * + Cancelled: The command was terminated before it was completed. This is a terminal state.
         * + Undeliverable: The command can't be delivered to the managed node. The managed node might not exist or might not be responding. Undeliverable invocations don't count against the parent command's MaxErrors limit and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         * + Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.
         * + Delayed: The system attempted to send the command to the managed node but wasn't successful. The system retries again.
         */
        public var statusDetails: kotlin.String? = null
        /**
         * Gets the trace output sent by the agent.
         */
        public var traceOutput: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CommandInvocation) : this() {
            this.cloudWatchOutputConfig = x.cloudWatchOutputConfig
            this.commandId = x.commandId
            this.commandPlugins = x.commandPlugins
            this.comment = x.comment
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.instanceId = x.instanceId
            this.instanceName = x.instanceName
            this.notificationConfig = x.notificationConfig
            this.requestedDateTime = x.requestedDateTime
            this.serviceRole = x.serviceRole
            this.standardErrorUrl = x.standardErrorUrl
            this.standardOutputUrl = x.standardOutputUrl
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.traceOutput = x.traceOutput
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CommandInvocation = CommandInvocation(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig] inside the given [block]
         */
        public fun cloudWatchOutputConfig(block: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.Builder.() -> kotlin.Unit) {
            this.cloudWatchOutputConfig = aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.NotificationConfig] inside the given [block]
         */
        public fun notificationConfig(block: aws.sdk.kotlin.services.ssm.model.NotificationConfig.Builder.() -> kotlin.Unit) {
            this.notificationConfig = aws.sdk.kotlin.services.ssm.model.NotificationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
