// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.ParameterTier
import aws.sdk.kotlin.services.ssm.model.PutParameterResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutParameterOperationDeserializer: HttpDeserializer.NonStreaming<PutParameterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutParameterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutParameterError(context, call, payload)
        }
        val builder = PutParameterResponse.Builder()

        if (payload != null) {
            deserializePutParameterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutParameterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "HierarchyLevelLimitExceededException" -> HierarchyLevelLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "HierarchyTypeMismatchException" -> HierarchyTypeMismatchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IncompatiblePolicyException" -> IncompatiblePolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidAllowedPatternException" -> InvalidAllowedPatternExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidKeyId" -> InvalidKeyIdDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPolicyAttributeException" -> InvalidPolicyAttributeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPolicyTypeException" -> InvalidPolicyTypeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ParameterAlreadyExists" -> ParameterAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        "ParameterLimitExceeded" -> ParameterLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "ParameterMaxVersionLimitExceeded" -> ParameterMaxVersionLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "ParameterPatternMismatchException" -> ParameterPatternMismatchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PoliciesLimitExceededException" -> PoliciesLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyUpdates" -> TooManyUpdatesDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedParameterType" -> UnsupportedParameterTypeDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutParameterOperationBody(builder: PutParameterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Tier"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("Version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TIER_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TIER_DESCRIPTOR.index -> builder.tier = deserializeString().let { ParameterTier.fromValue(it) }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
