// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines which patches should be included in a patch baseline.
 *
 * A patch filter consists of a key and a set of values. The filter key is a patch property. For example, the available filter keys for `WINDOWS` are `PATCH_SET`, `PRODUCT`, `PRODUCT_FAMILY`, `CLASSIFICATION`, and `MSRC_SEVERITY`.
 *
 * The filter values define a matching criterion for the patch property indicated by the key. For example, if the filter key is `PRODUCT` and the filter values are `["Office 2013", "Office 2016"]`, then the filter accepts all patches where product name is either "Office 2013" or "Office 2016". The filter values can be exact values for the patch property given as a key, or a wildcard (*), which matches all values.
 *
 * You can view lists of valid values for the patch properties by running the `DescribePatchProperties` command. For information about which patch properties can be used with each major operating system, see DescribePatchProperties.
 */
public class PatchFilter private constructor(builder: Builder) {
    /**
     * The key for the filter.
     *
     * Run the DescribePatchProperties command to view lists of valid keys for each operating system type.
     */
    public val key: aws.sdk.kotlin.services.ssm.model.PatchFilterKey = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The value for the filter key.
     *
     * Run the DescribePatchProperties command to view lists of valid values for each key based on operating system type.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.PatchFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PatchFilter(")
        append("key=$key,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PatchFilter

        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.PatchFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The key for the filter.
         *
         * Run the DescribePatchProperties command to view lists of valid keys for each operating system type.
         */
        public var key: aws.sdk.kotlin.services.ssm.model.PatchFilterKey? = null
        /**
         * The value for the filter key.
         *
         * Run the DescribePatchProperties command to view lists of valid values for each key based on operating system type.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.PatchFilter) : this() {
            this.key = x.key
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.PatchFilter = PatchFilter(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = PatchFilterKey.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
