// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about an Amazon Simple Storage Service (Amazon S3) bucket to write managed node-level logs to.
 *
 * `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix` options in the `TaskInvocationParameters` structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
 */
public class LoggingInfo private constructor(builder: Builder) {
    /**
     * The name of an S3 bucket where execution logs are stored.
     */
    public val s3BucketName: kotlin.String = requireNotNull(builder.s3BucketName) { "A non-null value must be provided for s3BucketName" }
    /**
     * (Optional) The S3 bucket subfolder.
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix
    /**
     * The Amazon Web Services Region where the S3 bucket is located.
     */
    public val s3Region: kotlin.String = requireNotNull(builder.s3Region) { "A non-null value must be provided for s3Region" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.LoggingInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingInfo(")
        append("s3BucketName=$s3BucketName,")
        append("s3KeyPrefix=$s3KeyPrefix,")
        append("s3Region=$s3Region")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3BucketName.hashCode()
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (s3Region.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoggingInfo

        if (s3BucketName != other.s3BucketName) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false
        if (s3Region != other.s3Region) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.LoggingInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of an S3 bucket where execution logs are stored.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * (Optional) The S3 bucket subfolder.
         */
        public var s3KeyPrefix: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the S3 bucket is located.
         */
        public var s3Region: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.LoggingInfo) : this() {
            this.s3BucketName = x.s3BucketName
            this.s3KeyPrefix = x.s3KeyPrefix
            this.s3Region = x.s3Region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.LoggingInfo = LoggingInfo(this)

        internal fun correctErrors(): Builder {
            if (s3BucketName == null) s3BucketName = ""
            if (s3Region == null) s3Region = ""
            return this
        }
    }
}
