// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The inventory item schema definition. Users can use this to compose inventory query filters.
 */
public class InventoryItemSchema private constructor(builder: Builder) {
    /**
     * The schema attributes for inventory. This contains data type and attribute name.
     */
    public val attributes: List<InventoryItemAttribute> = requireNotNull(builder.attributes) { "A non-null value must be provided for attributes" }
    /**
     * The alias name of the inventory type. The alias name is used for display purposes.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The name of the inventory type. Default inventory item type names start with Amazon Web Services. Custom inventory type names will start with Custom. Default inventory item types include the following: `AWS:AWSComponent`, `AWS:Application`, `AWS:InstanceInformation`, `AWS:Network`, and `AWS:WindowsUpdate`.
     */
    public val typeName: kotlin.String = requireNotNull(builder.typeName) { "A non-null value must be provided for typeName" }
    /**
     * The schema version for the inventory item.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InventoryItemSchema = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InventoryItemSchema(")
        append("attributes=$attributes,")
        append("displayName=$displayName,")
        append("typeName=$typeName,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes.hashCode()
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (typeName.hashCode())
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InventoryItemSchema

        if (attributes != other.attributes) return false
        if (displayName != other.displayName) return false
        if (typeName != other.typeName) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InventoryItemSchema = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The schema attributes for inventory. This contains data type and attribute name.
         */
        public var attributes: List<InventoryItemAttribute>? = null
        /**
         * The alias name of the inventory type. The alias name is used for display purposes.
         */
        public var displayName: kotlin.String? = null
        /**
         * The name of the inventory type. Default inventory item type names start with Amazon Web Services. Custom inventory type names will start with Custom. Default inventory item types include the following: `AWS:AWSComponent`, `AWS:Application`, `AWS:InstanceInformation`, `AWS:Network`, and `AWS:WindowsUpdate`.
         */
        public var typeName: kotlin.String? = null
        /**
         * The schema version for the inventory item.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InventoryItemSchema) : this() {
            this.attributes = x.attributes
            this.displayName = x.displayName
            this.typeName = x.typeName
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InventoryItemSchema = InventoryItemSchema(this)

        internal fun correctErrors(): Builder {
            if (attributes == null) attributes = emptyList()
            if (typeName == null) typeName = ""
            return this
        }
    }
}
