// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ssm.auth.DefaultSsmAuthSchemeProvider
import aws.sdk.kotlin.services.ssm.auth.SsmAuthSchemeProvider
import aws.sdk.kotlin.services.ssm.endpoints.DefaultSsmEndpointProvider
import aws.sdk.kotlin.services.ssm.endpoints.SsmEndpointParameters
import aws.sdk.kotlin.services.ssm.endpoints.SsmEndpointProvider
import aws.sdk.kotlin.services.ssm.model.AddTagsToResourceRequest
import aws.sdk.kotlin.services.ssm.model.AddTagsToResourceResponse
import aws.sdk.kotlin.services.ssm.model.AssociateOpsItemRelatedItemRequest
import aws.sdk.kotlin.services.ssm.model.AssociateOpsItemRelatedItemResponse
import aws.sdk.kotlin.services.ssm.model.CancelCommandRequest
import aws.sdk.kotlin.services.ssm.model.CancelCommandResponse
import aws.sdk.kotlin.services.ssm.model.CancelMaintenanceWindowExecutionRequest
import aws.sdk.kotlin.services.ssm.model.CancelMaintenanceWindowExecutionResponse
import aws.sdk.kotlin.services.ssm.model.CreateActivationRequest
import aws.sdk.kotlin.services.ssm.model.CreateActivationResponse
import aws.sdk.kotlin.services.ssm.model.CreateAssociationBatchRequest
import aws.sdk.kotlin.services.ssm.model.CreateAssociationBatchResponse
import aws.sdk.kotlin.services.ssm.model.CreateAssociationRequest
import aws.sdk.kotlin.services.ssm.model.CreateAssociationResponse
import aws.sdk.kotlin.services.ssm.model.CreateDocumentRequest
import aws.sdk.kotlin.services.ssm.model.CreateDocumentResponse
import aws.sdk.kotlin.services.ssm.model.CreateMaintenanceWindowRequest
import aws.sdk.kotlin.services.ssm.model.CreateMaintenanceWindowResponse
import aws.sdk.kotlin.services.ssm.model.CreateOpsItemRequest
import aws.sdk.kotlin.services.ssm.model.CreateOpsItemResponse
import aws.sdk.kotlin.services.ssm.model.CreateOpsMetadataRequest
import aws.sdk.kotlin.services.ssm.model.CreateOpsMetadataResponse
import aws.sdk.kotlin.services.ssm.model.CreatePatchBaselineRequest
import aws.sdk.kotlin.services.ssm.model.CreatePatchBaselineResponse
import aws.sdk.kotlin.services.ssm.model.CreateResourceDataSyncRequest
import aws.sdk.kotlin.services.ssm.model.CreateResourceDataSyncResponse
import aws.sdk.kotlin.services.ssm.model.DeleteActivationRequest
import aws.sdk.kotlin.services.ssm.model.DeleteActivationResponse
import aws.sdk.kotlin.services.ssm.model.DeleteAssociationRequest
import aws.sdk.kotlin.services.ssm.model.DeleteAssociationResponse
import aws.sdk.kotlin.services.ssm.model.DeleteDocumentRequest
import aws.sdk.kotlin.services.ssm.model.DeleteDocumentResponse
import aws.sdk.kotlin.services.ssm.model.DeleteInventoryRequest
import aws.sdk.kotlin.services.ssm.model.DeleteInventoryResponse
import aws.sdk.kotlin.services.ssm.model.DeleteMaintenanceWindowRequest
import aws.sdk.kotlin.services.ssm.model.DeleteMaintenanceWindowResponse
import aws.sdk.kotlin.services.ssm.model.DeleteOpsItemRequest
import aws.sdk.kotlin.services.ssm.model.DeleteOpsItemResponse
import aws.sdk.kotlin.services.ssm.model.DeleteOpsMetadataRequest
import aws.sdk.kotlin.services.ssm.model.DeleteOpsMetadataResponse
import aws.sdk.kotlin.services.ssm.model.DeleteParameterRequest
import aws.sdk.kotlin.services.ssm.model.DeleteParameterResponse
import aws.sdk.kotlin.services.ssm.model.DeleteParametersRequest
import aws.sdk.kotlin.services.ssm.model.DeleteParametersResponse
import aws.sdk.kotlin.services.ssm.model.DeletePatchBaselineRequest
import aws.sdk.kotlin.services.ssm.model.DeletePatchBaselineResponse
import aws.sdk.kotlin.services.ssm.model.DeleteResourceDataSyncRequest
import aws.sdk.kotlin.services.ssm.model.DeleteResourceDataSyncResponse
import aws.sdk.kotlin.services.ssm.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.ssm.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.ssm.model.DeregisterManagedInstanceRequest
import aws.sdk.kotlin.services.ssm.model.DeregisterManagedInstanceResponse
import aws.sdk.kotlin.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest
import aws.sdk.kotlin.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse
import aws.sdk.kotlin.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest
import aws.sdk.kotlin.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse
import aws.sdk.kotlin.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest
import aws.sdk.kotlin.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse
import aws.sdk.kotlin.services.ssm.model.DescribeActivationsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeActivationsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeAssociationExecutionTargetsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeAssociationExecutionTargetsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeAssociationExecutionsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeAssociationExecutionsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeAssociationRequest
import aws.sdk.kotlin.services.ssm.model.DescribeAssociationResponse
import aws.sdk.kotlin.services.ssm.model.DescribeAutomationExecutionsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeAutomationExecutionsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeAutomationStepExecutionsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeAutomationStepExecutionsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeAvailablePatchesRequest
import aws.sdk.kotlin.services.ssm.model.DescribeAvailablePatchesResponse
import aws.sdk.kotlin.services.ssm.model.DescribeDocumentPermissionRequest
import aws.sdk.kotlin.services.ssm.model.DescribeDocumentPermissionResponse
import aws.sdk.kotlin.services.ssm.model.DescribeDocumentRequest
import aws.sdk.kotlin.services.ssm.model.DescribeDocumentResponse
import aws.sdk.kotlin.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
import aws.sdk.kotlin.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse
import aws.sdk.kotlin.services.ssm.model.DescribeInstanceAssociationsStatusRequest
import aws.sdk.kotlin.services.ssm.model.DescribeInstanceAssociationsStatusResponse
import aws.sdk.kotlin.services.ssm.model.DescribeInstanceInformationRequest
import aws.sdk.kotlin.services.ssm.model.DescribeInstanceInformationResponse
import aws.sdk.kotlin.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
import aws.sdk.kotlin.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse
import aws.sdk.kotlin.services.ssm.model.DescribeInstancePatchStatesRequest
import aws.sdk.kotlin.services.ssm.model.DescribeInstancePatchStatesResponse
import aws.sdk.kotlin.services.ssm.model.DescribeInstancePatchesRequest
import aws.sdk.kotlin.services.ssm.model.DescribeInstancePatchesResponse
import aws.sdk.kotlin.services.ssm.model.DescribeInstancePropertiesRequest
import aws.sdk.kotlin.services.ssm.model.DescribeInstancePropertiesResponse
import aws.sdk.kotlin.services.ssm.model.DescribeInventoryDeletionsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeInventoryDeletionsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowScheduleRequest
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowScheduleResponse
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowTargetsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowTargetsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowTasksRequest
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowTasksResponse
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeOpsItemsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeOpsItemsResponse
import aws.sdk.kotlin.services.ssm.model.DescribeParametersRequest
import aws.sdk.kotlin.services.ssm.model.DescribeParametersResponse
import aws.sdk.kotlin.services.ssm.model.DescribePatchBaselinesRequest
import aws.sdk.kotlin.services.ssm.model.DescribePatchBaselinesResponse
import aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateRequest
import aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateResponse
import aws.sdk.kotlin.services.ssm.model.DescribePatchGroupsRequest
import aws.sdk.kotlin.services.ssm.model.DescribePatchGroupsResponse
import aws.sdk.kotlin.services.ssm.model.DescribePatchPropertiesRequest
import aws.sdk.kotlin.services.ssm.model.DescribePatchPropertiesResponse
import aws.sdk.kotlin.services.ssm.model.DescribeSessionsRequest
import aws.sdk.kotlin.services.ssm.model.DescribeSessionsResponse
import aws.sdk.kotlin.services.ssm.model.DisassociateOpsItemRelatedItemRequest
import aws.sdk.kotlin.services.ssm.model.DisassociateOpsItemRelatedItemResponse
import aws.sdk.kotlin.services.ssm.model.GetAccessTokenRequest
import aws.sdk.kotlin.services.ssm.model.GetAccessTokenResponse
import aws.sdk.kotlin.services.ssm.model.GetAutomationExecutionRequest
import aws.sdk.kotlin.services.ssm.model.GetAutomationExecutionResponse
import aws.sdk.kotlin.services.ssm.model.GetCalendarStateRequest
import aws.sdk.kotlin.services.ssm.model.GetCalendarStateResponse
import aws.sdk.kotlin.services.ssm.model.GetCommandInvocationRequest
import aws.sdk.kotlin.services.ssm.model.GetCommandInvocationResponse
import aws.sdk.kotlin.services.ssm.model.GetConnectionStatusRequest
import aws.sdk.kotlin.services.ssm.model.GetConnectionStatusResponse
import aws.sdk.kotlin.services.ssm.model.GetDefaultPatchBaselineRequest
import aws.sdk.kotlin.services.ssm.model.GetDefaultPatchBaselineResponse
import aws.sdk.kotlin.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest
import aws.sdk.kotlin.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
import aws.sdk.kotlin.services.ssm.model.GetDocumentRequest
import aws.sdk.kotlin.services.ssm.model.GetDocumentResponse
import aws.sdk.kotlin.services.ssm.model.GetExecutionPreviewRequest
import aws.sdk.kotlin.services.ssm.model.GetExecutionPreviewResponse
import aws.sdk.kotlin.services.ssm.model.GetInventoryRequest
import aws.sdk.kotlin.services.ssm.model.GetInventoryResponse
import aws.sdk.kotlin.services.ssm.model.GetInventorySchemaRequest
import aws.sdk.kotlin.services.ssm.model.GetInventorySchemaResponse
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionRequest
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionResponse
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowRequest
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowResponse
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowTaskRequest
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowTaskResponse
import aws.sdk.kotlin.services.ssm.model.GetOpsItemRequest
import aws.sdk.kotlin.services.ssm.model.GetOpsItemResponse
import aws.sdk.kotlin.services.ssm.model.GetOpsMetadataRequest
import aws.sdk.kotlin.services.ssm.model.GetOpsMetadataResponse
import aws.sdk.kotlin.services.ssm.model.GetOpsSummaryRequest
import aws.sdk.kotlin.services.ssm.model.GetOpsSummaryResponse
import aws.sdk.kotlin.services.ssm.model.GetParameterHistoryRequest
import aws.sdk.kotlin.services.ssm.model.GetParameterHistoryResponse
import aws.sdk.kotlin.services.ssm.model.GetParameterRequest
import aws.sdk.kotlin.services.ssm.model.GetParameterResponse
import aws.sdk.kotlin.services.ssm.model.GetParametersByPathRequest
import aws.sdk.kotlin.services.ssm.model.GetParametersByPathResponse
import aws.sdk.kotlin.services.ssm.model.GetParametersRequest
import aws.sdk.kotlin.services.ssm.model.GetParametersResponse
import aws.sdk.kotlin.services.ssm.model.GetPatchBaselineForPatchGroupRequest
import aws.sdk.kotlin.services.ssm.model.GetPatchBaselineForPatchGroupResponse
import aws.sdk.kotlin.services.ssm.model.GetPatchBaselineRequest
import aws.sdk.kotlin.services.ssm.model.GetPatchBaselineResponse
import aws.sdk.kotlin.services.ssm.model.GetResourcePoliciesRequest
import aws.sdk.kotlin.services.ssm.model.GetResourcePoliciesResponse
import aws.sdk.kotlin.services.ssm.model.GetServiceSettingRequest
import aws.sdk.kotlin.services.ssm.model.GetServiceSettingResponse
import aws.sdk.kotlin.services.ssm.model.LabelParameterVersionRequest
import aws.sdk.kotlin.services.ssm.model.LabelParameterVersionResponse
import aws.sdk.kotlin.services.ssm.model.ListAssociationVersionsRequest
import aws.sdk.kotlin.services.ssm.model.ListAssociationVersionsResponse
import aws.sdk.kotlin.services.ssm.model.ListAssociationsRequest
import aws.sdk.kotlin.services.ssm.model.ListAssociationsResponse
import aws.sdk.kotlin.services.ssm.model.ListCommandInvocationsRequest
import aws.sdk.kotlin.services.ssm.model.ListCommandInvocationsResponse
import aws.sdk.kotlin.services.ssm.model.ListCommandsRequest
import aws.sdk.kotlin.services.ssm.model.ListCommandsResponse
import aws.sdk.kotlin.services.ssm.model.ListComplianceItemsRequest
import aws.sdk.kotlin.services.ssm.model.ListComplianceItemsResponse
import aws.sdk.kotlin.services.ssm.model.ListComplianceSummariesRequest
import aws.sdk.kotlin.services.ssm.model.ListComplianceSummariesResponse
import aws.sdk.kotlin.services.ssm.model.ListDocumentMetadataHistoryRequest
import aws.sdk.kotlin.services.ssm.model.ListDocumentMetadataHistoryResponse
import aws.sdk.kotlin.services.ssm.model.ListDocumentVersionsRequest
import aws.sdk.kotlin.services.ssm.model.ListDocumentVersionsResponse
import aws.sdk.kotlin.services.ssm.model.ListDocumentsRequest
import aws.sdk.kotlin.services.ssm.model.ListDocumentsResponse
import aws.sdk.kotlin.services.ssm.model.ListInventoryEntriesRequest
import aws.sdk.kotlin.services.ssm.model.ListInventoryEntriesResponse
import aws.sdk.kotlin.services.ssm.model.ListNodesRequest
import aws.sdk.kotlin.services.ssm.model.ListNodesResponse
import aws.sdk.kotlin.services.ssm.model.ListNodesSummaryRequest
import aws.sdk.kotlin.services.ssm.model.ListNodesSummaryResponse
import aws.sdk.kotlin.services.ssm.model.ListOpsItemEventsRequest
import aws.sdk.kotlin.services.ssm.model.ListOpsItemEventsResponse
import aws.sdk.kotlin.services.ssm.model.ListOpsItemRelatedItemsRequest
import aws.sdk.kotlin.services.ssm.model.ListOpsItemRelatedItemsResponse
import aws.sdk.kotlin.services.ssm.model.ListOpsMetadataRequest
import aws.sdk.kotlin.services.ssm.model.ListOpsMetadataResponse
import aws.sdk.kotlin.services.ssm.model.ListResourceComplianceSummariesRequest
import aws.sdk.kotlin.services.ssm.model.ListResourceComplianceSummariesResponse
import aws.sdk.kotlin.services.ssm.model.ListResourceDataSyncRequest
import aws.sdk.kotlin.services.ssm.model.ListResourceDataSyncResponse
import aws.sdk.kotlin.services.ssm.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ssm.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionRequest
import aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionResponse
import aws.sdk.kotlin.services.ssm.model.PutComplianceItemsRequest
import aws.sdk.kotlin.services.ssm.model.PutComplianceItemsResponse
import aws.sdk.kotlin.services.ssm.model.PutInventoryRequest
import aws.sdk.kotlin.services.ssm.model.PutInventoryResponse
import aws.sdk.kotlin.services.ssm.model.PutParameterRequest
import aws.sdk.kotlin.services.ssm.model.PutParameterResponse
import aws.sdk.kotlin.services.ssm.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.ssm.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.ssm.model.RegisterDefaultPatchBaselineRequest
import aws.sdk.kotlin.services.ssm.model.RegisterDefaultPatchBaselineResponse
import aws.sdk.kotlin.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest
import aws.sdk.kotlin.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse
import aws.sdk.kotlin.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest
import aws.sdk.kotlin.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse
import aws.sdk.kotlin.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest
import aws.sdk.kotlin.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse
import aws.sdk.kotlin.services.ssm.model.RemoveTagsFromResourceRequest
import aws.sdk.kotlin.services.ssm.model.RemoveTagsFromResourceResponse
import aws.sdk.kotlin.services.ssm.model.ResetServiceSettingRequest
import aws.sdk.kotlin.services.ssm.model.ResetServiceSettingResponse
import aws.sdk.kotlin.services.ssm.model.ResumeSessionRequest
import aws.sdk.kotlin.services.ssm.model.ResumeSessionResponse
import aws.sdk.kotlin.services.ssm.model.SendAutomationSignalRequest
import aws.sdk.kotlin.services.ssm.model.SendAutomationSignalResponse
import aws.sdk.kotlin.services.ssm.model.SendCommandRequest
import aws.sdk.kotlin.services.ssm.model.SendCommandResponse
import aws.sdk.kotlin.services.ssm.model.StartAccessRequestRequest
import aws.sdk.kotlin.services.ssm.model.StartAccessRequestResponse
import aws.sdk.kotlin.services.ssm.model.StartAssociationsOnceRequest
import aws.sdk.kotlin.services.ssm.model.StartAssociationsOnceResponse
import aws.sdk.kotlin.services.ssm.model.StartAutomationExecutionRequest
import aws.sdk.kotlin.services.ssm.model.StartAutomationExecutionResponse
import aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionRequest
import aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionResponse
import aws.sdk.kotlin.services.ssm.model.StartExecutionPreviewRequest
import aws.sdk.kotlin.services.ssm.model.StartExecutionPreviewResponse
import aws.sdk.kotlin.services.ssm.model.StartSessionRequest
import aws.sdk.kotlin.services.ssm.model.StartSessionResponse
import aws.sdk.kotlin.services.ssm.model.StopAutomationExecutionRequest
import aws.sdk.kotlin.services.ssm.model.StopAutomationExecutionResponse
import aws.sdk.kotlin.services.ssm.model.TerminateSessionRequest
import aws.sdk.kotlin.services.ssm.model.TerminateSessionResponse
import aws.sdk.kotlin.services.ssm.model.UnlabelParameterVersionRequest
import aws.sdk.kotlin.services.ssm.model.UnlabelParameterVersionResponse
import aws.sdk.kotlin.services.ssm.model.UpdateAssociationRequest
import aws.sdk.kotlin.services.ssm.model.UpdateAssociationResponse
import aws.sdk.kotlin.services.ssm.model.UpdateAssociationStatusRequest
import aws.sdk.kotlin.services.ssm.model.UpdateAssociationStatusResponse
import aws.sdk.kotlin.services.ssm.model.UpdateDocumentDefaultVersionRequest
import aws.sdk.kotlin.services.ssm.model.UpdateDocumentDefaultVersionResponse
import aws.sdk.kotlin.services.ssm.model.UpdateDocumentMetadataRequest
import aws.sdk.kotlin.services.ssm.model.UpdateDocumentMetadataResponse
import aws.sdk.kotlin.services.ssm.model.UpdateDocumentRequest
import aws.sdk.kotlin.services.ssm.model.UpdateDocumentResponse
import aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowRequest
import aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowResponse
import aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTargetRequest
import aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTargetResponse
import aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskRequest
import aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskResponse
import aws.sdk.kotlin.services.ssm.model.UpdateManagedInstanceRoleRequest
import aws.sdk.kotlin.services.ssm.model.UpdateManagedInstanceRoleResponse
import aws.sdk.kotlin.services.ssm.model.UpdateOpsItemRequest
import aws.sdk.kotlin.services.ssm.model.UpdateOpsItemResponse
import aws.sdk.kotlin.services.ssm.model.UpdateOpsMetadataRequest
import aws.sdk.kotlin.services.ssm.model.UpdateOpsMetadataResponse
import aws.sdk.kotlin.services.ssm.model.UpdatePatchBaselineRequest
import aws.sdk.kotlin.services.ssm.model.UpdatePatchBaselineResponse
import aws.sdk.kotlin.services.ssm.model.UpdateResourceDataSyncRequest
import aws.sdk.kotlin.services.ssm.model.UpdateResourceDataSyncResponse
import aws.sdk.kotlin.services.ssm.model.UpdateServiceSettingRequest
import aws.sdk.kotlin.services.ssm.model.UpdateServiceSettingResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "SSM"
public const val SdkVersion: String = "1.5.46"
public const val ServiceApiVersion: String = "2014-11-06"

/**
 * Amazon Web Services Systems Manager is the operations hub for your Amazon Web Services applications and resources and a secure end-to-end management solution for hybrid cloud environments that enables safe and secure operations at scale.
 *
 * This reference is intended to be used with the [Amazon Web Services Systems Manager User Guide](https://docs.aws.amazon.com/systems-manager/latest/userguide/). To get started, see [Setting up Amazon Web Services Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-setting-up-console.html).
 *
 * **Related resources**
 * + For information about each of the tools that comprise Systems Manager, see [Using Systems Manager tools](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-tools.html) in the *Amazon Web Services Systems Manager User Guide*.
 * + For details about predefined runbooks for Automation, a tool in Amazon Web Services Systems Manager, see the *[Systems Manager Automation Runbook Reference](https://docs.aws.amazon.com/systems-manager-automation-runbooks/latest/userguide/automation-runbook-reference.html)*.
 * + For information about AppConfig, a tool in Systems Manager, see the *[AppConfig User Guide](https://docs.aws.amazon.com/appconfig/latest/userguide/)* and the *[AppConfig API Reference](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/)*.
 * + For information about Incident Manager, a tool in Systems Manager, see the *[Systems Manager Incident Manager User Guide](https://docs.aws.amazon.com/incident-manager/latest/userguide/)* and the *[Systems Manager Incident Manager API Reference](https://docs.aws.amazon.com/incident-manager/latest/APIReference/)*.
 */
public interface SsmClient : SdkClient {
    /**
     * SsmClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SsmClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Ssm",
                "SSM",
                "ssm",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SsmClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SsmClient = DefaultSsmClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SsmEndpointProvider = builder.endpointProvider ?: DefaultSsmEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SsmAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSsmAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SSM"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SsmEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SsmAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds or overwrites one or more tags for the specified resource. *Tags* are metadata that you can assign to your automations, documents, managed nodes, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. For example, you could define a set of tags for your account's managed nodes that helps you track each node's owner and stack level. For example:
     * + `Key=Owner,Value=DbAdmin`
     * + `Key=Owner,Value=SysAdmin`
     * + `Key=Owner,Value=Dev`
     * + `Key=Stack,Value=Production`
     * + `Key=Stack,Value=Pre-Production`
     * + `Key=Stack,Value=Test`
     *
     * Most resources can have a maximum of 50 tags. Automations can have a maximum of 5 tags.
     *
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of characters.
     *
     * For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see [Tag your Amazon EC2 resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html) in the *Amazon EC2 User Guide*.
     */
    public suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an Incident Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are tools in Amazon Web Services Systems Manager.
     */
    public suspend fun associateOpsItemRelatedItem(input: AssociateOpsItemRelatedItemRequest): AssociateOpsItemRelatedItemResponse

    /**
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be terminated and the underlying process stopped.
     */
    public suspend fun cancelCommand(input: CancelCommandRequest): CancelCommandResponse

    /**
     * Stops a maintenance window execution that is already in progress and cancels any tasks in the window that haven't already starting running. Tasks already in progress will continue to completion.
     */
    public suspend fun cancelMaintenanceWindowExecution(input: CancelMaintenanceWindowExecutionRequest): CancelMaintenanceWindowExecutionResponse

    /**
     * Generates an activation code and activation ID you can use to register your on-premises servers, edge devices, or virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using Systems Manager tools. You use the activation code and ID when installing SSM Agent on machines in your hybrid environment. For more information about requirements for managing on-premises machines using Systems Manager, see [Using Amazon Web Services Systems Manager in hybrid and multicloud environments](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-hybrid-multicloud.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices, and on-premises servers and VMs that are configured for Systems Manager are all called *managed nodes*.
     */
    public suspend fun createActivation(input: CreateActivationRequest): CreateActivationResponse

    /**
     * A State Manager association defines the state that you want to maintain on your managed nodes. For example, an association can specify that anti-virus software must be installed and running on your managed nodes, or that certain ports must be closed. For static targets, the association specifies a schedule for when the configuration is reapplied. For dynamic targets, such as an Amazon Web Services resource group or an Amazon Web Services autoscaling group, State Manager, a tool in Amazon Web Services Systems Manager applies the configuration when new managed nodes are added to the group. The association also specifies actions to take when applying the configuration. For example, an association for anti-virus software might run once a day. If the software isn't installed, then State Manager installs it. If the software is installed, but the service isn't running, then the association might instruct State Manager to start the service.
     */
    public suspend fun createAssociation(input: CreateAssociationRequest): CreateAssociationResponse

    /**
     * Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed nodes or targets.
     *
     * When you associate a document with one or more managed nodes using IDs or tags, Amazon Web Services Systems Manager Agent (SSM Agent) running on the managed node processes the document and configures the node as specified.
     *
     * If you associate a document with a managed node that already has an associated document, the system returns the AssociationAlreadyExists exception.
     */
    public suspend fun createAssociationBatch(input: CreateAssociationBatchRequest): CreateAssociationBatchResponse

    /**
     * Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems Manager performs on your managed nodes. For more information about SSM documents, including information about supported schemas, features, and syntax, see [Amazon Web Services Systems Manager Documents](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public suspend fun createDocument(input: CreateDocumentRequest): CreateDocumentResponse

    /**
     * Creates a new maintenance window.
     *
     * The value you specify for `Duration` determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for `Cutoff`. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for `Cutoff` is one hour, no maintenance window tasks can start after 5 PM.
     */
    public suspend fun createMaintenanceWindow(input: CreateMaintenanceWindowRequest): CreateMaintenanceWindowResponse

    /**
     * Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see [Amazon Web Services Systems Manager OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public suspend fun createOpsItem(input: CreateOpsItemRequest): CreateOpsItemResponse

    /**
     * If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API operation to specify information about the new application, including the application type.
     */
    public suspend fun createOpsMetadata(input: CreateOpsMetadataRequest): CreateOpsMetadataResponse

    /**
     * Creates a patch baseline.
     *
     * For information about valid key-value pairs in `PatchFilters` for each supported operating system type, see PatchFilter.
     */
    public suspend fun createPatchBaseline(input: CreatePatchBaselineRequest): CreatePatchBaselineResponse

    /**
     * A resource data sync helps you view data from multiple sources in a single location. Amazon Web Services Systems Manager offers two types of resource data sync: `SyncToDestination` and `SyncFromSource`.
     *
     * You can configure Systems Manager Inventory to use the `SyncToDestination` type to synchronize Inventory data from multiple Amazon Web Services Regions to a single Amazon Simple Storage Service (Amazon S3) bucket. For more information, see [Creating a resource data sync for Inventory](https://docs.aws.amazon.com/systems-manager/latest/userguide/inventory-create-resource-data-sync.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * You can configure Systems Manager Explorer to use the `SyncFromSource` type to synchronize operational work items (OpsItems) and operational data (OpsData) from multiple Amazon Web Services Regions to a single Amazon S3 bucket. This type can synchronize OpsItems and OpsData from multiple Amazon Web Services accounts and Amazon Web Services Regions or `EntireOrganization` by using Organizations. For more information, see [Setting up Systems Manager Explorer to display data from multiple accounts and Regions](https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is completed, the system continuously syncs data. To check the status of a sync, use the ListResourceDataSync.
     *
     * By default, data isn't encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a restrictive bucket policy.
     */
    public suspend fun createResourceDataSync(input: CreateResourceDataSyncRequest): CreateResourceDataSyncResponse

    /**
     * Deletes an activation. You aren't required to delete an activation. If you delete an activation, you can no longer use it to register additional managed nodes. Deleting an activation doesn't de-register managed nodes. You must manually de-register managed nodes.
     */
    public suspend fun deleteActivation(input: DeleteActivationRequest): DeleteActivationResponse

    /**
     * Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified managed node. If you created the association by using the `Targets` parameter, then you must delete the association by using the association ID.
     *
     * When you disassociate a document from a managed node, it doesn't change the configuration of the node. To change the configuration state of a managed node after you disassociate a document, you must create a new document with the desired configuration and associate it with the node.
     */
    public suspend fun deleteAssociation(input: DeleteAssociationRequest = DeleteAssociationRequest { }): DeleteAssociationResponse

    /**
     * Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the document.
     *
     * Before you delete the document, we recommend that you use DeleteAssociation to disassociate all managed nodes that are associated with the document.
     */
    public suspend fun deleteDocument(input: DeleteDocumentRequest): DeleteDocumentResponse

    /**
     * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory type is also referred to as deleting a custom inventory schema.
     */
    public suspend fun deleteInventory(input: DeleteInventoryRequest): DeleteInventoryResponse

    /**
     * Deletes a maintenance window.
     */
    public suspend fun deleteMaintenanceWindow(input: DeleteMaintenanceWindowRequest): DeleteMaintenanceWindowResponse

    /**
     * Delete an OpsItem. You must have permission in Identity and Access Management (IAM) to delete an OpsItem.
     *
     * Note the following important information about this operation.
     * + Deleting an OpsItem is irreversible. You can't restore a deleted OpsItem.
     * + This operation uses an *eventual consistency model*, which means the system can take a few minutes to complete this operation. If you delete an OpsItem and immediately call, for example, GetOpsItem, the deleted OpsItem might still appear in the response.
     * + This operation is idempotent. The system doesn't throw an exception if you repeatedly call this operation for the same OpsItem. If the first call is successful, all additional calls return the same successful response as the first call.
     * + This operation doesn't support cross-account calls. A delegated administrator or management account can't delete OpsItems in other accounts, even if OpsCenter has been set up for cross-account administration. For more information about cross-account administration, see [Setting up OpsCenter to centrally manage OpsItems across accounts](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setting-up-cross-account.html) in the *Systems Manager User Guide*.
     */
    public suspend fun deleteOpsItem(input: DeleteOpsItemRequest): DeleteOpsItemResponse

    /**
     * Delete OpsMetadata related to an application.
     */
    public suspend fun deleteOpsMetadata(input: DeleteOpsMetadataRequest): DeleteOpsMetadataResponse

    /**
     * Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.
     */
    public suspend fun deleteParameter(input: DeleteParameterRequest): DeleteParameterResponse

    /**
     * Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.
     */
    public suspend fun deleteParameters(input: DeleteParametersRequest): DeleteParametersResponse

    /**
     * Deletes a patch baseline.
     */
    public suspend fun deletePatchBaseline(input: DeletePatchBaselineRequest): DeletePatchBaselineResponse

    /**
     * Deletes a resource data sync configuration. After the configuration is deleted, changes to data on managed nodes are no longer synced to or from the target. Deleting a sync configuration doesn't delete data.
     */
    public suspend fun deleteResourceDataSync(input: DeleteResourceDataSyncRequest): DeleteResourceDataSyncResponse

    /**
     * Deletes a Systems Manager resource policy. A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account) that can manage your Systems Manager resources. The following resources support Systems Manager resource policies.
     * + `OpsItemGroup` - The resource policy for `OpsItemGroup` enables Amazon Web Services accounts to view and interact with OpsCenter operational work items (OpsItems).
     * + `Parameter` - The resource policy is used to share a parameter with other accounts using Resource Access Manager (RAM). For more information about cross-account sharing of parameters, see [Working with shared parameters](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-shared-parameters.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Removes the server or virtual machine from the list of registered servers.
     *
     * If you want to reregister an on-premises server, edge device, or VM, you must use a different Activation Code and Activation ID than used to register the machine previously. The Activation Code and Activation ID must not have already been used on the maximum number of activations specified when they were created. For more information, see [Deregistering managed nodes in a hybrid and multicloud environment](https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-manager-deregister-hybrid-nodes.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public suspend fun deregisterManagedInstance(input: DeregisterManagedInstanceRequest): DeregisterManagedInstanceResponse

    /**
     * Removes a patch group from a patch baseline.
     */
    public suspend fun deregisterPatchBaselineForPatchGroup(input: DeregisterPatchBaselineForPatchGroupRequest): DeregisterPatchBaselineForPatchGroupResponse

    /**
     * Removes a target from a maintenance window.
     */
    public suspend fun deregisterTargetFromMaintenanceWindow(input: DeregisterTargetFromMaintenanceWindowRequest): DeregisterTargetFromMaintenanceWindowResponse

    /**
     * Removes a task from a maintenance window.
     */
    public suspend fun deregisterTaskFromMaintenanceWindow(input: DeregisterTaskFromMaintenanceWindowRequest): DeregisterTaskFromMaintenanceWindowResponse

    /**
     * Describes details about the activation, such as the date and time the activation was created, its expiration date, the Identity and Access Management (IAM) role assigned to the managed nodes in the activation, and the number of nodes registered by using this activation.
     */
    public suspend fun describeActivations(input: DescribeActivationsRequest = DescribeActivationsRequest { }): DescribeActivationsResponse

    /**
     * Describes the association for the specified target or managed node. If you created the association by using the `Targets` parameter, then you must retrieve the association by using the association ID.
     */
    public suspend fun describeAssociation(input: DescribeAssociationRequest = DescribeAssociationRequest { }): DescribeAssociationResponse

    /**
     * Views information about a specific execution of a specific association.
     */
    public suspend fun describeAssociationExecutionTargets(input: DescribeAssociationExecutionTargetsRequest): DescribeAssociationExecutionTargetsResponse

    /**
     * Views all executions for a specific association ID.
     */
    public suspend fun describeAssociationExecutions(input: DescribeAssociationExecutionsRequest): DescribeAssociationExecutionsResponse

    /**
     * Provides details about all active and terminated Automation executions.
     */
    public suspend fun describeAutomationExecutions(input: DescribeAutomationExecutionsRequest = DescribeAutomationExecutionsRequest { }): DescribeAutomationExecutionsResponse

    /**
     * Information about all active and terminated step executions in an Automation workflow.
     */
    public suspend fun describeAutomationStepExecutions(input: DescribeAutomationStepExecutionsRequest): DescribeAutomationStepExecutionsResponse

    /**
     * Lists all patches eligible to be included in a patch baseline.
     *
     * Currently, `DescribeAvailablePatches` supports only the Amazon Linux 1, Amazon Linux 2, and Windows Server operating systems.
     */
    public suspend fun describeAvailablePatches(input: DescribeAvailablePatchesRequest = DescribeAvailablePatchesRequest { }): DescribeAvailablePatchesResponse

    /**
     * Describes the specified Amazon Web Services Systems Manager document (SSM document).
     */
    public suspend fun describeDocument(input: DescribeDocumentRequest): DescribeDocumentResponse

    /**
     * Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the document, you are the owner. If a document is shared, it can either be shared privately (by specifying a user's Amazon Web Services account ID) or publicly (*All*).
     */
    public suspend fun describeDocumentPermission(input: DescribeDocumentPermissionRequest): DescribeDocumentPermissionResponse

    /**
     * All associations for the managed nodes.
     */
    public suspend fun describeEffectiveInstanceAssociations(input: DescribeEffectiveInstanceAssociationsRequest): DescribeEffectiveInstanceAssociationsResponse

    /**
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Applies to patch baselines for Windows only.
     */
    public suspend fun describeEffectivePatchesForPatchBaseline(input: DescribeEffectivePatchesForPatchBaselineRequest): DescribeEffectivePatchesForPatchBaselineResponse

    /**
     * The status of the associations for the managed nodes.
     */
    public suspend fun describeInstanceAssociationsStatus(input: DescribeInstanceAssociationsStatusRequest): DescribeInstanceAssociationsStatusResponse

    /**
     * Provides information about one or more of your managed nodes, including the operating system platform, SSM Agent version, association status, and IP address. This operation does not return information for nodes that are either Stopped or Terminated.
     *
     * If you specify one or more node IDs, the operation returns information for those managed nodes. If you don't specify node IDs, it returns information for all your managed nodes. If you specify a node ID that isn't valid or a node that you don't own, you receive an error.
     *
     * The `IamRole` field returned for this API operation is the role assigned to an Amazon EC2 instance configured with a Systems Manager Quick Setup host management configuration or the role assigned to an on-premises managed node.
     */
    public suspend fun describeInstanceInformation(input: DescribeInstanceInformationRequest = DescribeInstanceInformationRequest { }): DescribeInstanceInformationResponse

    /**
     * Retrieves the high-level patch state of one or more managed nodes.
     */
    public suspend fun describeInstancePatchStates(input: DescribeInstancePatchStatesRequest): DescribeInstancePatchStatesResponse

    /**
     * Retrieves the high-level patch state for the managed nodes in the specified patch group.
     */
    public suspend fun describeInstancePatchStatesForPatchGroup(input: DescribeInstancePatchStatesForPatchGroupRequest): DescribeInstancePatchStatesForPatchGroupResponse

    /**
     * Retrieves information about the patches on the specified managed node and their state relative to the patch baseline being used for the node.
     */
    public suspend fun describeInstancePatches(input: DescribeInstancePatchesRequest): DescribeInstancePatchesResponse

    /**
     * An API operation used by the Systems Manager console to display information about Systems Manager managed nodes.
     */
    public suspend fun describeInstanceProperties(input: DescribeInstancePropertiesRequest = DescribeInstancePropertiesRequest { }): DescribeInstancePropertiesResponse

    /**
     * Describes a specific delete inventory operation.
     */
    public suspend fun describeInventoryDeletions(input: DescribeInventoryDeletionsRequest = DescribeInventoryDeletionsRequest { }): DescribeInventoryDeletionsResponse

    /**
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance window execution.
     */
    public suspend fun describeMaintenanceWindowExecutionTaskInvocations(input: DescribeMaintenanceWindowExecutionTaskInvocationsRequest): DescribeMaintenanceWindowExecutionTaskInvocationsResponse

    /**
     * For a given maintenance window execution, lists the tasks that were run.
     */
    public suspend fun describeMaintenanceWindowExecutionTasks(input: DescribeMaintenanceWindowExecutionTasksRequest): DescribeMaintenanceWindowExecutionTasksResponse

    /**
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was scheduled to be active, and information about tasks registered and run with the maintenance window.
     */
    public suspend fun describeMaintenanceWindowExecutions(input: DescribeMaintenanceWindowExecutionsRequest): DescribeMaintenanceWindowExecutionsResponse

    /**
     * Retrieves information about upcoming executions of a maintenance window.
     */
    public suspend fun describeMaintenanceWindowSchedule(input: DescribeMaintenanceWindowScheduleRequest = DescribeMaintenanceWindowScheduleRequest { }): DescribeMaintenanceWindowScheduleResponse

    /**
     * Lists the targets registered with the maintenance window.
     */
    public suspend fun describeMaintenanceWindowTargets(input: DescribeMaintenanceWindowTargetsRequest): DescribeMaintenanceWindowTargetsResponse

    /**
     * Lists the tasks in a maintenance window.
     *
     * For maintenance window tasks without a specified target, you can't supply values for `--max-errors` and `--max-concurrency`. Instead, the system inserts a placeholder value of `1`, which may be reported in the response to this command. These values don't affect the running of your task and can be ignored.
     */
    public suspend fun describeMaintenanceWindowTasks(input: DescribeMaintenanceWindowTasksRequest): DescribeMaintenanceWindowTasksResponse

    /**
     * Retrieves the maintenance windows in an Amazon Web Services account.
     */
    public suspend fun describeMaintenanceWindows(input: DescribeMaintenanceWindowsRequest = DescribeMaintenanceWindowsRequest { }): DescribeMaintenanceWindowsResponse

    /**
     * Retrieves information about the maintenance window targets or tasks that a managed node is associated with.
     */
    public suspend fun describeMaintenanceWindowsForTarget(input: DescribeMaintenanceWindowsForTargetRequest): DescribeMaintenanceWindowsForTargetResponse

    /**
     * Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of OpsItems. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see [Amazon Web Services Systems Manager OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public suspend fun describeOpsItems(input: DescribeOpsItemsRequest = DescribeOpsItemsRequest { }): DescribeOpsItemsResponse

    /**
     * Lists the parameters in your Amazon Web Services account or the parameters shared with you when you enable the [Shared](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribeParameters.html#systemsmanager-DescribeParameters-request-Shared) option.
     *
     * Request results are returned on a best-effort basis. If you specify `MaxResults` in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of `MaxResults`. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a `NextToken`. You can specify the `NextToken` in a subsequent call to get the next set of results.
     *
     * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
     *
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key alias the parameter uses to reference KMS. Otherwise, `DescribeParameters` retrieves whatever the original key alias was referencing.
     */
    public suspend fun describeParameters(input: DescribeParametersRequest = DescribeParametersRequest { }): DescribeParametersResponse

    /**
     * Lists the patch baselines in your Amazon Web Services account.
     */
    public suspend fun describePatchBaselines(input: DescribePatchBaselinesRequest = DescribePatchBaselinesRequest { }): DescribePatchBaselinesResponse

    /**
     * Returns high-level aggregated patch compliance state information for a patch group.
     */
    public suspend fun describePatchGroupState(input: DescribePatchGroupStateRequest): DescribePatchGroupStateResponse

    /**
     * Lists all patch groups that have been registered with patch baselines.
     */
    public suspend fun describePatchGroups(input: DescribePatchGroupsRequest = DescribePatchGroupsRequest { }): DescribePatchGroupsResponse

    /**
     * Lists the properties of available patches organized by product, product family, classification, severity, and other properties of available patches. You can use the reported properties in the filters you specify in requests for operations such as CreatePatchBaseline, UpdatePatchBaseline, DescribeAvailablePatches, and DescribePatchBaselines.
     *
     * The following section lists the properties that can be used in filters for each major operating system type:
     *
     * ## AMAZON_LINUX
     * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
     *
     * ## AMAZON_LINUX_2
     * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
     *
     * ## AMAZON_LINUX_2023
     * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
     *
     * ## CENTOS
     * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
     *
     * ## DEBIAN
     * Valid properties: `PRODUCT` | `PRIORITY`
     *
     * ## MACOS
     * Valid properties: `PRODUCT` | `CLASSIFICATION`
     *
     * ## ORACLE_LINUX
     * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
     *
     * ## REDHAT_ENTERPRISE_LINUX
     * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
     *
     * ## SUSE
     * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
     *
     * ## UBUNTU
     * Valid properties: `PRODUCT` | `PRIORITY`
     *
     * ## WINDOWS
     * Valid properties: `PRODUCT` | `PRODUCT_FAMILY` | `CLASSIFICATION` | `MSRC_SEVERITY`
     */
    public suspend fun describePatchProperties(input: DescribePatchPropertiesRequest): DescribePatchPropertiesResponse

    /**
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30 days.
     */
    public suspend fun describeSessions(input: DescribeSessionsRequest): DescribeSessionsResponse

    /**
     * Deletes the association between an OpsItem and a related item. For example, this API operation can delete an Incident Manager incident from an OpsItem. Incident Manager is a tool in Amazon Web Services Systems Manager.
     */
    public suspend fun disassociateOpsItemRelatedItem(input: DisassociateOpsItemRelatedItemRequest): DisassociateOpsItemRelatedItemResponse

    /**
     * Returns a credentials set to be used with just-in-time node access.
     */
    public suspend fun getAccessToken(input: GetAccessTokenRequest): GetAccessTokenResponse

    /**
     * Get detailed information about a particular Automation execution.
     */
    public suspend fun getAutomationExecution(input: GetAutomationExecutionRequest): GetAutomationExecutionResponse

    /**
     * Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time. If you specify a time, `GetCalendarState` returns the state of the calendar at that specific time, and returns the next time that the change calendar state will transition. If you don't specify a time, `GetCalendarState` uses the current time. Change Calendar entries have two possible states: `OPEN` or `CLOSED`.
     *
     * If you specify more than one calendar in a request, the command returns the status of `OPEN` only if all calendars in the request are open. If one or more calendars in the request are closed, the status returned is `CLOSED`.
     *
     * For more information about Change Calendar, a tool in Amazon Web Services Systems Manager, see [Amazon Web Services Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public suspend fun getCalendarState(input: GetCalendarStateRequest): GetCalendarStateResponse

    /**
     * Returns detailed information about command execution for an invocation or plugin. The Run Command API follows an eventual consistency model, due to the distributed nature of the system supporting the API. This means that the result of an API command you run that affects your resources might not be immediately visible to all subsequent commands you run. You should keep this in mind when you carry out an API command that immediately follows a previous API command.
     *
     * `GetCommandInvocation` only gives the execution status of a plugin in a document. To get the command execution status on a specific managed node, use ListCommandInvocations. To get the command execution status across managed nodes, use ListCommands.
     */
    public suspend fun getCommandInvocation(input: GetCommandInvocationRequest): GetCommandInvocationResponse

    /**
     * Retrieves the Session Manager connection status for a managed node to determine whether it is running and ready to receive Session Manager connections.
     */
    public suspend fun getConnectionStatus(input: GetConnectionStatusRequest): GetConnectionStatusResponse

    /**
     * Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.
     *
     * If you don't specify an operating system value, the default patch baseline for Windows is returned.
     */
    public suspend fun getDefaultPatchBaseline(input: GetDefaultPatchBaselineRequest = GetDefaultPatchBaselineRequest { }): GetDefaultPatchBaselineResponse

    /**
     * Retrieves the current snapshot for the patch baseline the managed node uses. This API is primarily used by the `AWS-RunPatchBaseline` Systems Manager document (SSM document).
     *
     * If you run the command locally, such as with the Command Line Interface (CLI), the system attempts to use your local Amazon Web Services credentials and the operation fails. To avoid this, you can run the command in the Amazon Web Services Systems Manager console. Use Run Command, a tool in Amazon Web Services Systems Manager, with an SSM document that enables you to target a managed node with a script or command. For example, run the command using the `AWS-RunShellScript` document or the `AWS-RunPowerShellScript` document.
     */
    public suspend fun getDeployablePatchSnapshotForInstance(input: GetDeployablePatchSnapshotForInstanceRequest): GetDeployablePatchSnapshotForInstanceResponse

    /**
     * Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).
     */
    public suspend fun getDocument(input: GetDocumentRequest): GetDocumentResponse

    /**
     * Initiates the process of retrieving an existing preview that shows the effects that running a specified Automation runbook would have on the targeted resources.
     */
    public suspend fun getExecutionPreview(input: GetExecutionPreviewRequest): GetExecutionPreviewResponse

    /**
     * Query inventory information. This includes managed node status, such as `Stopped` or `Terminated`.
     */
    public suspend fun getInventory(input: GetInventoryRequest = GetInventoryRequest { }): GetInventoryResponse

    /**
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific Inventory item type.
     */
    public suspend fun getInventorySchema(input: GetInventorySchemaRequest = GetInventorySchemaRequest { }): GetInventorySchemaResponse

    /**
     * Retrieves a maintenance window.
     */
    public suspend fun getMaintenanceWindow(input: GetMaintenanceWindowRequest): GetMaintenanceWindowResponse

    /**
     * Retrieves details about a specific a maintenance window execution.
     */
    public suspend fun getMaintenanceWindowExecution(input: GetMaintenanceWindowExecutionRequest): GetMaintenanceWindowExecutionResponse

    /**
     * Retrieves the details about a specific task run as part of a maintenance window execution.
     */
    public suspend fun getMaintenanceWindowExecutionTask(input: GetMaintenanceWindowExecutionTaskRequest): GetMaintenanceWindowExecutionTaskResponse

    /**
     * Retrieves information about a specific task running on a specific target.
     */
    public suspend fun getMaintenanceWindowExecutionTaskInvocation(input: GetMaintenanceWindowExecutionTaskInvocationRequest): GetMaintenanceWindowExecutionTaskInvocationResponse

    /**
     * Retrieves the details of a maintenance window task.
     *
     * For maintenance window tasks without a specified target, you can't supply values for `--max-errors` and `--max-concurrency`. Instead, the system inserts a placeholder value of `1`, which may be reported in the response to this command. These values don't affect the running of your task and can be ignored.
     *
     * To retrieve a list of tasks in a maintenance window, instead use the DescribeMaintenanceWindowTasks command.
     */
    public suspend fun getMaintenanceWindowTask(input: GetMaintenanceWindowTaskRequest): GetMaintenanceWindowTaskResponse

    /**
     * Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management (IAM) to view information about an OpsItem. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see [Amazon Web Services Systems Manager OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public suspend fun getOpsItem(input: GetOpsItemRequest): GetOpsItemResponse

    /**
     * View operational metadata related to an application in Application Manager.
     */
    public suspend fun getOpsMetadata(input: GetOpsMetadataRequest): GetOpsMetadataResponse

    /**
     * View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services Systems Manager Explorer.
     */
    public suspend fun getOpsSummary(input: GetOpsSummaryRequest = GetOpsSummaryRequest { }): GetOpsSummaryResponse

    /**
     * Get information about a single parameter by specifying the parameter name.
     *
     * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
     *
     * To get information about more than one parameter at a time, use the GetParameters operation.
     */
    public suspend fun getParameter(input: GetParameterRequest): GetParameterResponse

    /**
     * Retrieves the history of all changes to a parameter.
     *
     * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
     *
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key alias the parameter uses to reference KMS. Otherwise, `GetParameterHistory` retrieves whatever the original key alias was referencing.
     */
    public suspend fun getParameterHistory(input: GetParameterHistoryRequest): GetParameterHistoryResponse

    /**
     * Get information about one or more parameters by specifying multiple parameter names.
     *
     * To get information about a single parameter, you can use the GetParameter operation instead.
     *
     * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
     */
    public suspend fun getParameters(input: GetParametersRequest): GetParametersResponse

    /**
     * Retrieve information about one or more parameters under a specified level in a hierarchy.
     *
     * Request results are returned on a best-effort basis. If you specify `MaxResults` in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of `MaxResults`. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a `NextToken`. You can specify the `NextToken` in a subsequent call to get the next set of results.
     *
     * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
     */
    public suspend fun getParametersByPath(input: GetParametersByPathRequest): GetParametersByPathResponse

    /**
     * Retrieves information about a patch baseline.
     */
    public suspend fun getPatchBaseline(input: GetPatchBaselineRequest): GetPatchBaselineResponse

    /**
     * Retrieves the patch baseline that should be used for the specified patch group.
     */
    public suspend fun getPatchBaselineForPatchGroup(input: GetPatchBaselineForPatchGroupRequest): GetPatchBaselineForPatchGroupResponse

    /**
     * Returns an array of the `Policy` object.
     */
    public suspend fun getResourcePolicies(input: GetResourcePoliciesRequest): GetResourcePoliciesResponse

    /**
     * `ServiceSetting` is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of `false`. This means the user can't use this feature unless they change the setting to `true` and intentionally opt in for a paid feature.
     *
     * Services map a `SettingId` object to a setting value. Amazon Web Services services teams define the default value for a `SettingId`. You can't create a new `SettingId`, but you can overwrite the default value if you have the `ssm:UpdateServiceSetting` permission for the setting. Use the UpdateServiceSetting API operation to change the default setting. Or use the ResetServiceSetting to change the value back to the original value defined by the Amazon Web Services service team.
     *
     * Query the current service setting for the Amazon Web Services account.
     */
    public suspend fun getServiceSetting(input: GetServiceSettingRequest): GetServiceSettingResponse

    /**
     * A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically saves a new version and increments the version number by one. A label can help you remember the purpose of a parameter when there are multiple versions.
     *
     * Parameter labels have the following requirements and restrictions.
     * + A version of a parameter can have a maximum of 10 labels.
     * + You can't attach the same label to different versions of the same parameter. For example, if version 1 has the label Production, then you can't attach Production to version 2.
     * + You can move a label from one version of a parameter to another.
     * + You can't create a label when you create a new parameter. You must attach a label to a specific version of a parameter.
     * + If you no longer want to use a parameter label, then you can either delete it or move it to a different version of a parameter.
     * + A label can have a maximum of 100 characters.
     * + Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).
     * + Labels can't begin with a number, "`aws`" or "`ssm`" (not case sensitive). If a label fails to meet these requirements, then the label isn't associated with a parameter and the system displays it in the list of InvalidLabels.
     * + Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
     */
    public suspend fun labelParameterVersion(input: LabelParameterVersionRequest): LabelParameterVersionResponse

    /**
     * Retrieves all versions of an association for a specific association ID.
     */
    public suspend fun listAssociationVersions(input: ListAssociationVersionsRequest): ListAssociationVersionsResponse

    /**
     * Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region. You can limit the results to a specific State Manager association document or managed node by specifying a filter. State Manager is a tool in Amazon Web Services Systems Manager.
     */
    public suspend fun listAssociations(input: ListAssociationsRequest = ListAssociationsRequest { }): ListAssociationsResponse

    /**
     * An invocation is copy of a command sent to a specific managed node. A command can apply to one or more managed nodes. A command invocation applies to one managed node. For example, if a user runs `SendCommand` against three managed nodes, then a command invocation is created for each requested managed node ID. `ListCommandInvocations` provide status about command execution.
     */
    public suspend fun listCommandInvocations(input: ListCommandInvocationsRequest = ListCommandInvocationsRequest { }): ListCommandInvocationsResponse

    /**
     * Lists the commands requested by users of the Amazon Web Services account.
     */
    public suspend fun listCommands(input: ListCommandsRequest = ListCommandsRequest { }): ListCommandsResponse

    /**
     * For a specified resource ID, this API operation returns a list of compliance statuses for different resource types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the filter.
     */
    public suspend fun listComplianceItems(input: ListComplianceItemsRequest = ListComplianceItemsRequest { }): ListComplianceItemsResponse

    /**
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call can return State Manager associations, patches, or custom compliance types according to the filter criteria that you specify.
     */
    public suspend fun listComplianceSummaries(input: ListComplianceSummariesRequest = ListComplianceSummariesRequest { }): ListComplianceSummariesResponse

    /**
     * Information about approval reviews for a version of a change template in Change Manager.
     */
    public suspend fun listDocumentMetadataHistory(input: ListDocumentMetadataHistoryRequest): ListDocumentMetadataHistoryResponse

    /**
     * List all versions for a document.
     */
    public suspend fun listDocumentVersions(input: ListDocumentVersionsRequest): ListDocumentVersionsResponse

    /**
     * Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services Region. You can limit the results of this request by using a filter.
     */
    public suspend fun listDocuments(input: ListDocumentsRequest = ListDocumentsRequest { }): ListDocumentsResponse

    /**
     * A list of inventory items returned by the request.
     */
    public suspend fun listInventoryEntries(input: ListInventoryEntriesRequest): ListInventoryEntriesResponse

    /**
     * Takes in filters and returns a list of managed nodes matching the filter criteria.
     */
    public suspend fun listNodes(input: ListNodesRequest = ListNodesRequest { }): ListNodesResponse

    /**
     * Generates a summary of managed instance/node metadata based on the filters and aggregators you specify. Results are grouped by the input aggregator you specify.
     *
     * @sample aws.sdk.kotlin.services.ssm.samples.ListNodesSummary.sample
     */
    public suspend fun listNodesSummary(input: ListNodesSummaryRequest): ListNodesSummaryResponse

    /**
     * Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account. You can limit the results to events associated with specific OpsItems by specifying a filter.
     */
    public suspend fun listOpsItemEvents(input: ListOpsItemEventsRequest = ListOpsItemEventsRequest { }): ListOpsItemEventsResponse

    /**
     * Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a tool in Amazon Web Services Systems Manager.
     */
    public suspend fun listOpsItemRelatedItems(input: ListOpsItemRelatedItemsRequest = ListOpsItemRelatedItemsRequest { }): ListOpsItemRelatedItemsResponse

    /**
     * Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata objects or blobs.
     */
    public suspend fun listOpsMetadata(input: ListOpsMetadataRequest = ListOpsMetadataRequest { }): ListOpsMetadataResponse

    /**
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     */
    public suspend fun listResourceComplianceSummaries(input: ListResourceComplianceSummariesRequest = ListResourceComplianceSummariesRequest { }): ListResourceComplianceSummariesResponse

    /**
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start, the last sync status, and the last time a sync successfully completed.
     *
     * The number of sync configurations might be too large to return using a single call to `ListResourceDataSync`. You can limit the number of sync configurations returned by using the `MaxResults` parameter. To determine whether there are more sync configurations to list, check the value of `NextToken` in the output. If there are more sync configurations to list, you can request them by specifying the `NextToken` returned in the call to the parameter of a subsequent call.
     */
    public suspend fun listResourceDataSync(input: ListResourceDataSyncRequest = ListResourceDataSyncRequest { }): ListResourceDataSyncResponse

    /**
     * Returns a list of the tags assigned to the specified resource.
     *
     * For information about the ID format for each supported resource type, see AddTagsToResource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a document privately, you must specify the Amazon Web Services user IDs for those people who can use the document. If you share a document publicly, you must specify *All* as the account ID.
     */
    public suspend fun modifyDocumentPermission(input: ModifyDocumentPermissionRequest): ModifyDocumentPermissionResponse

    /**
     * Registers a compliance type and other compliance details on a designated resource. This operation lets you register custom compliance details with a resource. This call overwrites existing compliance information on the resource, so you must provide a full list of compliance items each time that you send the request.
     *
     * ComplianceType can be one of the following:
     * + ExecutionId: The execution ID when the patch, association, or custom compliance item was applied.
     * + ExecutionType: Specify patch, association, or Custom:`string`.
     * + ExecutionTime. The time the patch, association, or custom compliance item was applied to the managed node.For State Manager associations, this represents the time when compliance status was captured by the Systems Manager service during its internal compliance aggregation workflow, not necessarily when the association was executed on the managed node. State Manager updates compliance information for all associations on an instance whenever any association executes, which may result in multiple associations showing the same execution time.
     * + Id: The patch, association, or custom compliance ID.
     * + Title: A title.
     * + Status: The status of the compliance item. For example, `approved` for patches, or `Failed` for associations.
     * + Severity: A patch severity. For example, `Critical`.
     * + DocumentName: An SSM document name. For example, `AWS-RunPatchBaseline`.
     * + DocumentVersion: An SSM document version number. For example, 4.
     * + Classification: A patch classification. For example, `security updates`.
     * + PatchBaselineId: A patch baseline ID.
     * + PatchSeverity: A patch severity. For example, `Critical`.
     * + PatchState: A patch state. For example, `InstancesWithFailedPatches`.
     * + PatchGroup: The name of a patch group.
     * + InstalledTime: The time the association, patch, or custom compliance item was applied to the resource. Specify the time by using the following format: `yyyy-MM-dd'T'HH:mm:ss'Z'`
     */
    public suspend fun putComplianceItems(input: PutComplianceItemsRequest): PutComplianceItemsResponse

    /**
     * Bulk update custom inventory items on one or more managed nodes. The request adds an inventory item, if it doesn't already exist, or updates an inventory item, if it does exist.
     */
    public suspend fun putInventory(input: PutInventoryRequest): PutInventoryResponse

    /**
     * Create or update a parameter in Parameter Store.
     */
    public suspend fun putParameter(input: PutParameterRequest): PutParameterResponse

    /**
     * Creates or updates a Systems Manager resource policy. A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account) that can manage your Systems Manager resources. The following resources support Systems Manager resource policies.
     * + `OpsItemGroup` - The resource policy for `OpsItemGroup` enables Amazon Web Services accounts to view and interact with OpsCenter operational work items (OpsItems).
     * + `Parameter` - The resource policy is used to share a parameter with other accounts using Resource Access Manager (RAM). To share a parameter, it must be in the advanced parameter tier. For information about parameter tiers, see [Managing parameter tiers](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html). For information about changing an existing standard parameter to an advanced parameter, see [Changing a standard parameter to an advanced parameter](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html#parameter-store-advanced-parameters-enabling).To share a `SecureString` parameter, it must be encrypted with a customer managed key, and you must share the key separately through Key Management Service. Amazon Web Services managed keys cannot be shared. Parameters encrypted with the default Amazon Web Services managed key can be updated to use a customer managed key instead. For KMS key definitions, see [KMS concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html) in the *Key Management Service Developer Guide*.While you can share a parameter using the Systems Manager `PutResourcePolicy` operation, we recommend using Resource Access Manager (RAM) instead. This is because using `PutResourcePolicy` requires the extra step of promoting the parameter to a standard RAM Resource Share using the RAM [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) API operation. Otherwise, the parameter won't be returned by the Systems Manager [DescribeParameters](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribeParameters.html) API operation using the `--shared` option.For more information, see [Sharing a parameter](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-shared-parameters.html#share) in the *Amazon Web Services Systems Manager User Guide*
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Defines the default patch baseline for the relevant operating system.
     *
     * To reset the Amazon Web Services-predefined patch baseline as the default, specify the full patch baseline Amazon Resource Name (ARN) as the baseline ID value. For example, for CentOS, specify `arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed` instead of `pb-0574b43a65ea646ed`.
     */
    public suspend fun registerDefaultPatchBaseline(input: RegisterDefaultPatchBaselineRequest): RegisterDefaultPatchBaselineResponse

    /**
     * Registers a patch baseline for a patch group.
     */
    public suspend fun registerPatchBaselineForPatchGroup(input: RegisterPatchBaselineForPatchGroupRequest): RegisterPatchBaselineForPatchGroupResponse

    /**
     * Registers a target with a maintenance window.
     */
    public suspend fun registerTargetWithMaintenanceWindow(input: RegisterTargetWithMaintenanceWindowRequest): RegisterTargetWithMaintenanceWindowResponse

    /**
     * Adds a new task to a maintenance window.
     */
    public suspend fun registerTaskWithMaintenanceWindow(input: RegisterTaskWithMaintenanceWindowRequest): RegisterTaskWithMaintenanceWindowResponse

    /**
     * Removes tag keys from the specified resource.
     */
    public suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * `ServiceSetting` is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.
     *
     * Services map a `SettingId` object to a setting value. Amazon Web Services services teams define the default value for a `SettingId`. You can't create a new `SettingId`, but you can overwrite the default value if you have the `ssm:UpdateServiceSetting` permission for the setting. Use the GetServiceSetting API operation to view the current value. Use the UpdateServiceSetting API operation to change the default setting.
     *
     * Reset the service setting for the account to the default value as provisioned by the Amazon Web Services service team.
     */
    public suspend fun resetServiceSetting(input: ResetServiceSettingRequest): ResetServiceSettingResponse

    /**
     * Reconnects a session to a managed node after it has been disconnected. Connections can be resumed for disconnected sessions, but not terminated sessions.
     *
     * This command is primarily for use by client machines to automatically reconnect during intermittent network issues. It isn't intended for any other use.
     */
    public suspend fun resumeSession(input: ResumeSessionRequest): ResumeSessionResponse

    /**
     * Sends a signal to an Automation execution to change the current behavior or status of the execution.
     */
    public suspend fun sendAutomationSignal(input: SendAutomationSignalRequest): SendAutomationSignalResponse

    /**
     * Runs commands on one or more managed nodes.
     */
    public suspend fun sendCommand(input: SendCommandRequest): SendCommandResponse

    /**
     * Starts the workflow for just-in-time node access sessions.
     */
    public suspend fun startAccessRequest(input: StartAccessRequestRequest): StartAccessRequestResponse

    /**
     * Runs an association immediately and only one time. This operation can be helpful when troubleshooting associations.
     */
    public suspend fun startAssociationsOnce(input: StartAssociationsOnceRequest): StartAssociationsOnceResponse

    /**
     * Initiates execution of an Automation runbook.
     */
    public suspend fun startAutomationExecution(input: StartAutomationExecutionRequest): StartAutomationExecutionResponse

    /**
     * Creates a change request for Change Manager. The Automation runbooks specified in the change request run only after all required approvals for the change request have been received.
     */
    public suspend fun startChangeRequestExecution(input: StartChangeRequestExecutionRequest): StartChangeRequestExecutionResponse

    /**
     * Initiates the process of creating a preview showing the effects that running a specified Automation runbook would have on the targeted resources.
     *
     * @sample aws.sdk.kotlin.services.ssm.samples.StartExecutionPreview.sample
     */
    public suspend fun startExecutionPreview(input: StartExecutionPreviewRequest): StartExecutionPreviewResponse

    /**
     * Initiates a connection to a target (for example, a managed node) for a Session Manager session. Returns a URL and token that can be used to open a WebSocket connection for sending input and receiving outputs.
     *
     * Amazon Web Services CLI usage: `start-session` is an interactive command that requires the Session Manager plugin to be installed on the client machine making the call. For information, see [Install the Session Manager plugin for the Amazon Web Services CLI](https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * Amazon Web Services Tools for PowerShell usage: Start-SSMSession isn't currently supported by Amazon Web Services Tools for PowerShell on Windows local machines.
     */
    public suspend fun startSession(input: StartSessionRequest): StartSessionResponse

    /**
     * Stop an Automation that is currently running.
     */
    public suspend fun stopAutomationExecution(input: StopAutomationExecutionRequest): StopAutomationExecutionResponse

    /**
     * Permanently ends a session and closes the data connection between the Session Manager client and SSM Agent on the managed node. A terminated session can't be resumed.
     */
    public suspend fun terminateSession(input: TerminateSessionRequest): TerminateSessionResponse

    /**
     * Remove a label or labels from a parameter.
     *
     * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
     */
    public suspend fun unlabelParameterVersion(input: UnlabelParameterVersionRequest): UnlabelParameterVersionResponse

    /**
     * Updates an association. You can update the association name and version, the document version, schedule, parameters, and Amazon Simple Storage Service (Amazon S3) output. When you call `UpdateAssociation`, the system removes all optional parameters from the request and overwrites the association with null values for those parameters. This is by design. You must specify all optional parameters in the call, even if you are not changing the parameters. This includes the `Name` parameter. Before calling this API action, we recommend that you call the DescribeAssociation API operation and make a note of all optional parameters required for your `UpdateAssociation` call.
     *
     * In order to call this API operation, a user, group, or role must be granted permission to call the DescribeAssociation API operation. If you don't have permission to call `DescribeAssociation`, then you receive the following error: `An error occurred (AccessDeniedException) when calling the UpdateAssociation operation: User: <user_arn> isn't authorized to perform: ssm:DescribeAssociation on resource: <resource_arn>`
     *
     * When you update an association, the association immediately runs against the specified targets. You can add the `ApplyOnlyAtCronInterval` parameter to run the association during the next schedule run.
     */
    public suspend fun updateAssociation(input: UpdateAssociationRequest): UpdateAssociationResponse

    /**
     * Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the specified managed node.
     *
     * `UpdateAssociationStatus` is primarily used by the Amazon Web Services Systems Manager Agent (SSM Agent) to report status updates about your associations and is only used for associations created with the `InstanceId` legacy parameter.
     */
    public suspend fun updateAssociationStatus(input: UpdateAssociationStatusRequest): UpdateAssociationStatusResponse

    /**
     * Updates one or more values for an SSM document.
     */
    public suspend fun updateDocument(input: UpdateDocumentRequest): UpdateDocumentResponse

    /**
     * Set the default version of a document.
     *
     * If you change a document version for a State Manager association, Systems Manager immediately runs the association unless you previously specifed the `apply-only-at-cron-interval` parameter.
     */
    public suspend fun updateDocumentDefaultVersion(input: UpdateDocumentDefaultVersionRequest): UpdateDocumentDefaultVersionResponse

    /**
     * Updates information related to approval reviews for a specific version of a change template in Change Manager.
     */
    public suspend fun updateDocumentMetadata(input: UpdateDocumentMetadataRequest): UpdateDocumentMetadataResponse

    /**
     * Updates an existing maintenance window. Only specified parameters are modified.
     *
     * The value you specify for `Duration` determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for `Cutoff`. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for `Cutoff` is one hour, no maintenance window tasks can start after 5 PM.
     */
    public suspend fun updateMaintenanceWindow(input: UpdateMaintenanceWindowRequest): UpdateMaintenanceWindowResponse

    /**
     * Modifies the target of an existing maintenance window. You can change the following:
     * + Name
     * + Description
     * + Owner
     * + IDs for an ID target
     * + Tags for a Tag target
     * + From any supported tag type to another. The three supported tag types are ID target, Tag target, and resource group. For more information, see Target.
     *
     * If a parameter is null, then the corresponding field isn't modified.
     */
    public suspend fun updateMaintenanceWindowTarget(input: UpdateMaintenanceWindowTargetRequest): UpdateMaintenanceWindowTargetResponse

    /**
     * Modifies a task assigned to a maintenance window. You can't change the task type, but you can change the following values:
     * + `TaskARN`. For example, you can change a `RUN_COMMAND` task from `AWS-RunPowerShellScript` to `AWS-RunShellScript`.
     * + `ServiceRoleArn`
     * + `TaskInvocationParameters`
     * + `Priority`
     * + `MaxConcurrency`
     * + `MaxErrors`
     *
     * One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don't specify targets, see [Registering maintenance window tasks without targets](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * If the value for a parameter in `UpdateMaintenanceWindowTask` is null, then the corresponding field isn't modified. If you set `Replace` to true, then all fields required by the RegisterTaskWithMaintenanceWindow operation are required for this request. Optional fields that aren't specified are set to null.
     *
     * When you update a maintenance window task that has options specified in `TaskInvocationParameters`, you must provide again all the `TaskInvocationParameters` values that you want to retain. The values you don't specify again are removed. For example, suppose that when you registered a Run Command task, you specified `TaskInvocationParameters` values for `Comment`, `NotificationConfig`, and `OutputS3BucketName`. If you update the maintenance window task and specify only a different `OutputS3BucketName` value, the values for `Comment` and `NotificationConfig` are removed.
     */
    public suspend fun updateMaintenanceWindowTask(input: UpdateMaintenanceWindowTaskRequest): UpdateMaintenanceWindowTaskResponse

    /**
     * Changes the Identity and Access Management (IAM) role that is assigned to the on-premises server, edge device, or virtual machines (VM). IAM roles are first assigned to these hybrid nodes during the activation process. For more information, see CreateActivation.
     */
    public suspend fun updateManagedInstanceRole(input: UpdateManagedInstanceRoleRequest): UpdateManagedInstanceRoleResponse

    /**
     * Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM) to update an OpsItem. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see [Amazon Web Services Systems Manager OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public suspend fun updateOpsItem(input: UpdateOpsItemRequest): UpdateOpsItemResponse

    /**
     * Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager.
     */
    public suspend fun updateOpsMetadata(input: UpdateOpsMetadataRequest): UpdateOpsMetadataResponse

    /**
     * Modifies an existing patch baseline. Fields not specified in the request are left unchanged.
     *
     * For information about valid key-value pairs in `PatchFilters` for each supported operating system type, see PatchFilter.
     */
    public suspend fun updatePatchBaseline(input: UpdatePatchBaselineRequest): UpdatePatchBaselineResponse

    /**
     * Update a resource data sync. After you create a resource data sync for a Region, you can't change the account options for that sync. For example, if you create a sync in the us-east-2 (Ohio) Region and you choose the `Include only the current account` option, you can't edit that sync later and choose the `Include all accounts from my Organizations configuration` option. Instead, you must delete the first resource data sync, and create a new one.
     *
     * This API operation only supports a resource data sync that was created with a SyncFromSource `SyncType`.
     */
    public suspend fun updateResourceDataSync(input: UpdateResourceDataSyncRequest): UpdateResourceDataSyncResponse

    /**
     * `ServiceSetting` is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.
     *
     * Services map a `SettingId` object to a setting value. Amazon Web Services services teams define the default value for a `SettingId`. You can't create a new `SettingId`, but you can overwrite the default value if you have the `ssm:UpdateServiceSetting` permission for the setting. Use the GetServiceSetting API operation to view the current value. Or, use the ResetServiceSetting to change the value back to the original value defined by the Amazon Web Services service team.
     *
     * Update the service setting for the account.
     */
    public suspend fun updateServiceSetting(input: UpdateServiceSettingRequest): UpdateServiceSettingResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SsmClient.withConfig(block: SsmClient.Config.Builder.() -> Unit): SsmClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSsmClient(newConfig)
}

/**
 * Adds or overwrites one or more tags for the specified resource. *Tags* are metadata that you can assign to your automations, documents, managed nodes, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. For example, you could define a set of tags for your account's managed nodes that helps you track each node's owner and stack level. For example:
 * + `Key=Owner,Value=DbAdmin`
 * + `Key=Owner,Value=SysAdmin`
 * + `Key=Owner,Value=Dev`
 * + `Key=Stack,Value=Production`
 * + `Key=Stack,Value=Pre-Production`
 * + `Key=Stack,Value=Test`
 *
 * Most resources can have a maximum of 50 tags. Automations can have a maximum of 5 tags.
 *
 * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of characters.
 *
 * For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see [Tag your Amazon EC2 resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html) in the *Amazon EC2 User Guide*.
 */
public suspend inline fun SsmClient.addTagsToResource(crossinline block: AddTagsToResourceRequest.Builder.() -> Unit): AddTagsToResourceResponse = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

/**
 * Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an Incident Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are tools in Amazon Web Services Systems Manager.
 */
public suspend inline fun SsmClient.associateOpsItemRelatedItem(crossinline block: AssociateOpsItemRelatedItemRequest.Builder.() -> Unit): AssociateOpsItemRelatedItemResponse = associateOpsItemRelatedItem(AssociateOpsItemRelatedItemRequest.Builder().apply(block).build())

/**
 * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be terminated and the underlying process stopped.
 */
public suspend inline fun SsmClient.cancelCommand(crossinline block: CancelCommandRequest.Builder.() -> Unit): CancelCommandResponse = cancelCommand(CancelCommandRequest.Builder().apply(block).build())

/**
 * Stops a maintenance window execution that is already in progress and cancels any tasks in the window that haven't already starting running. Tasks already in progress will continue to completion.
 */
public suspend inline fun SsmClient.cancelMaintenanceWindowExecution(crossinline block: CancelMaintenanceWindowExecutionRequest.Builder.() -> Unit): CancelMaintenanceWindowExecutionResponse = cancelMaintenanceWindowExecution(CancelMaintenanceWindowExecutionRequest.Builder().apply(block).build())

/**
 * Generates an activation code and activation ID you can use to register your on-premises servers, edge devices, or virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using Systems Manager tools. You use the activation code and ID when installing SSM Agent on machines in your hybrid environment. For more information about requirements for managing on-premises machines using Systems Manager, see [Using Amazon Web Services Systems Manager in hybrid and multicloud environments](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-hybrid-multicloud.html) in the *Amazon Web Services Systems Manager User Guide*.
 *
 * Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices, and on-premises servers and VMs that are configured for Systems Manager are all called *managed nodes*.
 */
public suspend inline fun SsmClient.createActivation(crossinline block: CreateActivationRequest.Builder.() -> Unit): CreateActivationResponse = createActivation(CreateActivationRequest.Builder().apply(block).build())

/**
 * A State Manager association defines the state that you want to maintain on your managed nodes. For example, an association can specify that anti-virus software must be installed and running on your managed nodes, or that certain ports must be closed. For static targets, the association specifies a schedule for when the configuration is reapplied. For dynamic targets, such as an Amazon Web Services resource group or an Amazon Web Services autoscaling group, State Manager, a tool in Amazon Web Services Systems Manager applies the configuration when new managed nodes are added to the group. The association also specifies actions to take when applying the configuration. For example, an association for anti-virus software might run once a day. If the software isn't installed, then State Manager installs it. If the software is installed, but the service isn't running, then the association might instruct State Manager to start the service.
 */
public suspend inline fun SsmClient.createAssociation(crossinline block: CreateAssociationRequest.Builder.() -> Unit): CreateAssociationResponse = createAssociation(CreateAssociationRequest.Builder().apply(block).build())

/**
 * Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed nodes or targets.
 *
 * When you associate a document with one or more managed nodes using IDs or tags, Amazon Web Services Systems Manager Agent (SSM Agent) running on the managed node processes the document and configures the node as specified.
 *
 * If you associate a document with a managed node that already has an associated document, the system returns the AssociationAlreadyExists exception.
 */
public suspend inline fun SsmClient.createAssociationBatch(crossinline block: CreateAssociationBatchRequest.Builder.() -> Unit): CreateAssociationBatchResponse = createAssociationBatch(CreateAssociationBatchRequest.Builder().apply(block).build())

/**
 * Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems Manager performs on your managed nodes. For more information about SSM documents, including information about supported schemas, features, and syntax, see [Amazon Web Services Systems Manager Documents](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents.html) in the *Amazon Web Services Systems Manager User Guide*.
 */
public suspend inline fun SsmClient.createDocument(crossinline block: CreateDocumentRequest.Builder.() -> Unit): CreateDocumentResponse = createDocument(CreateDocumentRequest.Builder().apply(block).build())

/**
 * Creates a new maintenance window.
 *
 * The value you specify for `Duration` determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for `Cutoff`. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for `Cutoff` is one hour, no maintenance window tasks can start after 5 PM.
 */
public suspend inline fun SsmClient.createMaintenanceWindow(crossinline block: CreateMaintenanceWindowRequest.Builder.() -> Unit): CreateMaintenanceWindowResponse = createMaintenanceWindow(CreateMaintenanceWindowRequest.Builder().apply(block).build())

/**
 * Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
 *
 * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see [Amazon Web Services Systems Manager OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html) in the *Amazon Web Services Systems Manager User Guide*.
 */
public suspend inline fun SsmClient.createOpsItem(crossinline block: CreateOpsItemRequest.Builder.() -> Unit): CreateOpsItemResponse = createOpsItem(CreateOpsItemRequest.Builder().apply(block).build())

/**
 * If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API operation to specify information about the new application, including the application type.
 */
public suspend inline fun SsmClient.createOpsMetadata(crossinline block: CreateOpsMetadataRequest.Builder.() -> Unit): CreateOpsMetadataResponse = createOpsMetadata(CreateOpsMetadataRequest.Builder().apply(block).build())

/**
 * Creates a patch baseline.
 *
 * For information about valid key-value pairs in `PatchFilters` for each supported operating system type, see PatchFilter.
 */
public suspend inline fun SsmClient.createPatchBaseline(crossinline block: CreatePatchBaselineRequest.Builder.() -> Unit): CreatePatchBaselineResponse = createPatchBaseline(CreatePatchBaselineRequest.Builder().apply(block).build())

/**
 * A resource data sync helps you view data from multiple sources in a single location. Amazon Web Services Systems Manager offers two types of resource data sync: `SyncToDestination` and `SyncFromSource`.
 *
 * You can configure Systems Manager Inventory to use the `SyncToDestination` type to synchronize Inventory data from multiple Amazon Web Services Regions to a single Amazon Simple Storage Service (Amazon S3) bucket. For more information, see [Creating a resource data sync for Inventory](https://docs.aws.amazon.com/systems-manager/latest/userguide/inventory-create-resource-data-sync.html) in the *Amazon Web Services Systems Manager User Guide*.
 *
 * You can configure Systems Manager Explorer to use the `SyncFromSource` type to synchronize operational work items (OpsItems) and operational data (OpsData) from multiple Amazon Web Services Regions to a single Amazon S3 bucket. This type can synchronize OpsItems and OpsData from multiple Amazon Web Services accounts and Amazon Web Services Regions or `EntireOrganization` by using Organizations. For more information, see [Setting up Systems Manager Explorer to display data from multiple accounts and Regions](https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html) in the *Amazon Web Services Systems Manager User Guide*.
 *
 * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is completed, the system continuously syncs data. To check the status of a sync, use the ListResourceDataSync.
 *
 * By default, data isn't encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a restrictive bucket policy.
 */
public suspend inline fun SsmClient.createResourceDataSync(crossinline block: CreateResourceDataSyncRequest.Builder.() -> Unit): CreateResourceDataSyncResponse = createResourceDataSync(CreateResourceDataSyncRequest.Builder().apply(block).build())

/**
 * Deletes an activation. You aren't required to delete an activation. If you delete an activation, you can no longer use it to register additional managed nodes. Deleting an activation doesn't de-register managed nodes. You must manually de-register managed nodes.
 */
public suspend inline fun SsmClient.deleteActivation(crossinline block: DeleteActivationRequest.Builder.() -> Unit): DeleteActivationResponse = deleteActivation(DeleteActivationRequest.Builder().apply(block).build())

/**
 * Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified managed node. If you created the association by using the `Targets` parameter, then you must delete the association by using the association ID.
 *
 * When you disassociate a document from a managed node, it doesn't change the configuration of the node. To change the configuration state of a managed node after you disassociate a document, you must create a new document with the desired configuration and associate it with the node.
 */
public suspend inline fun SsmClient.deleteAssociation(crossinline block: DeleteAssociationRequest.Builder.() -> Unit): DeleteAssociationResponse = deleteAssociation(DeleteAssociationRequest.Builder().apply(block).build())

/**
 * Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the document.
 *
 * Before you delete the document, we recommend that you use DeleteAssociation to disassociate all managed nodes that are associated with the document.
 */
public suspend inline fun SsmClient.deleteDocument(crossinline block: DeleteDocumentRequest.Builder.() -> Unit): DeleteDocumentResponse = deleteDocument(DeleteDocumentRequest.Builder().apply(block).build())

/**
 * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory type is also referred to as deleting a custom inventory schema.
 */
public suspend inline fun SsmClient.deleteInventory(crossinline block: DeleteInventoryRequest.Builder.() -> Unit): DeleteInventoryResponse = deleteInventory(DeleteInventoryRequest.Builder().apply(block).build())

/**
 * Deletes a maintenance window.
 */
public suspend inline fun SsmClient.deleteMaintenanceWindow(crossinline block: DeleteMaintenanceWindowRequest.Builder.() -> Unit): DeleteMaintenanceWindowResponse = deleteMaintenanceWindow(DeleteMaintenanceWindowRequest.Builder().apply(block).build())

/**
 * Delete an OpsItem. You must have permission in Identity and Access Management (IAM) to delete an OpsItem.
 *
 * Note the following important information about this operation.
 * + Deleting an OpsItem is irreversible. You can't restore a deleted OpsItem.
 * + This operation uses an *eventual consistency model*, which means the system can take a few minutes to complete this operation. If you delete an OpsItem and immediately call, for example, GetOpsItem, the deleted OpsItem might still appear in the response.
 * + This operation is idempotent. The system doesn't throw an exception if you repeatedly call this operation for the same OpsItem. If the first call is successful, all additional calls return the same successful response as the first call.
 * + This operation doesn't support cross-account calls. A delegated administrator or management account can't delete OpsItems in other accounts, even if OpsCenter has been set up for cross-account administration. For more information about cross-account administration, see [Setting up OpsCenter to centrally manage OpsItems across accounts](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setting-up-cross-account.html) in the *Systems Manager User Guide*.
 */
public suspend inline fun SsmClient.deleteOpsItem(crossinline block: DeleteOpsItemRequest.Builder.() -> Unit): DeleteOpsItemResponse = deleteOpsItem(DeleteOpsItemRequest.Builder().apply(block).build())

/**
 * Delete OpsMetadata related to an application.
 */
public suspend inline fun SsmClient.deleteOpsMetadata(crossinline block: DeleteOpsMetadataRequest.Builder.() -> Unit): DeleteOpsMetadataResponse = deleteOpsMetadata(DeleteOpsMetadataRequest.Builder().apply(block).build())

/**
 * Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.
 */
public suspend inline fun SsmClient.deleteParameter(crossinline block: DeleteParameterRequest.Builder.() -> Unit): DeleteParameterResponse = deleteParameter(DeleteParameterRequest.Builder().apply(block).build())

/**
 * Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.
 */
public suspend inline fun SsmClient.deleteParameters(crossinline block: DeleteParametersRequest.Builder.() -> Unit): DeleteParametersResponse = deleteParameters(DeleteParametersRequest.Builder().apply(block).build())

/**
 * Deletes a patch baseline.
 */
public suspend inline fun SsmClient.deletePatchBaseline(crossinline block: DeletePatchBaselineRequest.Builder.() -> Unit): DeletePatchBaselineResponse = deletePatchBaseline(DeletePatchBaselineRequest.Builder().apply(block).build())

/**
 * Deletes a resource data sync configuration. After the configuration is deleted, changes to data on managed nodes are no longer synced to or from the target. Deleting a sync configuration doesn't delete data.
 */
public suspend inline fun SsmClient.deleteResourceDataSync(crossinline block: DeleteResourceDataSyncRequest.Builder.() -> Unit): DeleteResourceDataSyncResponse = deleteResourceDataSync(DeleteResourceDataSyncRequest.Builder().apply(block).build())

/**
 * Deletes a Systems Manager resource policy. A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account) that can manage your Systems Manager resources. The following resources support Systems Manager resource policies.
 * + `OpsItemGroup` - The resource policy for `OpsItemGroup` enables Amazon Web Services accounts to view and interact with OpsCenter operational work items (OpsItems).
 * + `Parameter` - The resource policy is used to share a parameter with other accounts using Resource Access Manager (RAM). For more information about cross-account sharing of parameters, see [Working with shared parameters](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-shared-parameters.html) in the *Amazon Web Services Systems Manager User Guide*.
 */
public suspend inline fun SsmClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Removes the server or virtual machine from the list of registered servers.
 *
 * If you want to reregister an on-premises server, edge device, or VM, you must use a different Activation Code and Activation ID than used to register the machine previously. The Activation Code and Activation ID must not have already been used on the maximum number of activations specified when they were created. For more information, see [Deregistering managed nodes in a hybrid and multicloud environment](https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-manager-deregister-hybrid-nodes.html) in the *Amazon Web Services Systems Manager User Guide*.
 */
public suspend inline fun SsmClient.deregisterManagedInstance(crossinline block: DeregisterManagedInstanceRequest.Builder.() -> Unit): DeregisterManagedInstanceResponse = deregisterManagedInstance(DeregisterManagedInstanceRequest.Builder().apply(block).build())

/**
 * Removes a patch group from a patch baseline.
 */
public suspend inline fun SsmClient.deregisterPatchBaselineForPatchGroup(crossinline block: DeregisterPatchBaselineForPatchGroupRequest.Builder.() -> Unit): DeregisterPatchBaselineForPatchGroupResponse = deregisterPatchBaselineForPatchGroup(DeregisterPatchBaselineForPatchGroupRequest.Builder().apply(block).build())

/**
 * Removes a target from a maintenance window.
 */
public suspend inline fun SsmClient.deregisterTargetFromMaintenanceWindow(crossinline block: DeregisterTargetFromMaintenanceWindowRequest.Builder.() -> Unit): DeregisterTargetFromMaintenanceWindowResponse = deregisterTargetFromMaintenanceWindow(DeregisterTargetFromMaintenanceWindowRequest.Builder().apply(block).build())

/**
 * Removes a task from a maintenance window.
 */
public suspend inline fun SsmClient.deregisterTaskFromMaintenanceWindow(crossinline block: DeregisterTaskFromMaintenanceWindowRequest.Builder.() -> Unit): DeregisterTaskFromMaintenanceWindowResponse = deregisterTaskFromMaintenanceWindow(DeregisterTaskFromMaintenanceWindowRequest.Builder().apply(block).build())

/**
 * Describes details about the activation, such as the date and time the activation was created, its expiration date, the Identity and Access Management (IAM) role assigned to the managed nodes in the activation, and the number of nodes registered by using this activation.
 */
public suspend inline fun SsmClient.describeActivations(crossinline block: DescribeActivationsRequest.Builder.() -> Unit): DescribeActivationsResponse = describeActivations(DescribeActivationsRequest.Builder().apply(block).build())

/**
 * Describes the association for the specified target or managed node. If you created the association by using the `Targets` parameter, then you must retrieve the association by using the association ID.
 */
public suspend inline fun SsmClient.describeAssociation(crossinline block: DescribeAssociationRequest.Builder.() -> Unit): DescribeAssociationResponse = describeAssociation(DescribeAssociationRequest.Builder().apply(block).build())

/**
 * Views information about a specific execution of a specific association.
 */
public suspend inline fun SsmClient.describeAssociationExecutionTargets(crossinline block: DescribeAssociationExecutionTargetsRequest.Builder.() -> Unit): DescribeAssociationExecutionTargetsResponse = describeAssociationExecutionTargets(DescribeAssociationExecutionTargetsRequest.Builder().apply(block).build())

/**
 * Views all executions for a specific association ID.
 */
public suspend inline fun SsmClient.describeAssociationExecutions(crossinline block: DescribeAssociationExecutionsRequest.Builder.() -> Unit): DescribeAssociationExecutionsResponse = describeAssociationExecutions(DescribeAssociationExecutionsRequest.Builder().apply(block).build())

/**
 * Provides details about all active and terminated Automation executions.
 */
public suspend inline fun SsmClient.describeAutomationExecutions(crossinline block: DescribeAutomationExecutionsRequest.Builder.() -> Unit): DescribeAutomationExecutionsResponse = describeAutomationExecutions(DescribeAutomationExecutionsRequest.Builder().apply(block).build())

/**
 * Information about all active and terminated step executions in an Automation workflow.
 */
public suspend inline fun SsmClient.describeAutomationStepExecutions(crossinline block: DescribeAutomationStepExecutionsRequest.Builder.() -> Unit): DescribeAutomationStepExecutionsResponse = describeAutomationStepExecutions(DescribeAutomationStepExecutionsRequest.Builder().apply(block).build())

/**
 * Lists all patches eligible to be included in a patch baseline.
 *
 * Currently, `DescribeAvailablePatches` supports only the Amazon Linux 1, Amazon Linux 2, and Windows Server operating systems.
 */
public suspend inline fun SsmClient.describeAvailablePatches(crossinline block: DescribeAvailablePatchesRequest.Builder.() -> Unit): DescribeAvailablePatchesResponse = describeAvailablePatches(DescribeAvailablePatchesRequest.Builder().apply(block).build())

/**
 * Describes the specified Amazon Web Services Systems Manager document (SSM document).
 */
public suspend inline fun SsmClient.describeDocument(crossinline block: DescribeDocumentRequest.Builder.() -> Unit): DescribeDocumentResponse = describeDocument(DescribeDocumentRequest.Builder().apply(block).build())

/**
 * Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the document, you are the owner. If a document is shared, it can either be shared privately (by specifying a user's Amazon Web Services account ID) or publicly (*All*).
 */
public suspend inline fun SsmClient.describeDocumentPermission(crossinline block: DescribeDocumentPermissionRequest.Builder.() -> Unit): DescribeDocumentPermissionResponse = describeDocumentPermission(DescribeDocumentPermissionRequest.Builder().apply(block).build())

/**
 * All associations for the managed nodes.
 */
public suspend inline fun SsmClient.describeEffectiveInstanceAssociations(crossinline block: DescribeEffectiveInstanceAssociationsRequest.Builder.() -> Unit): DescribeEffectiveInstanceAssociationsResponse = describeEffectiveInstanceAssociations(DescribeEffectiveInstanceAssociationsRequest.Builder().apply(block).build())

/**
 * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Applies to patch baselines for Windows only.
 */
public suspend inline fun SsmClient.describeEffectivePatchesForPatchBaseline(crossinline block: DescribeEffectivePatchesForPatchBaselineRequest.Builder.() -> Unit): DescribeEffectivePatchesForPatchBaselineResponse = describeEffectivePatchesForPatchBaseline(DescribeEffectivePatchesForPatchBaselineRequest.Builder().apply(block).build())

/**
 * The status of the associations for the managed nodes.
 */
public suspend inline fun SsmClient.describeInstanceAssociationsStatus(crossinline block: DescribeInstanceAssociationsStatusRequest.Builder.() -> Unit): DescribeInstanceAssociationsStatusResponse = describeInstanceAssociationsStatus(DescribeInstanceAssociationsStatusRequest.Builder().apply(block).build())

/**
 * Provides information about one or more of your managed nodes, including the operating system platform, SSM Agent version, association status, and IP address. This operation does not return information for nodes that are either Stopped or Terminated.
 *
 * If you specify one or more node IDs, the operation returns information for those managed nodes. If you don't specify node IDs, it returns information for all your managed nodes. If you specify a node ID that isn't valid or a node that you don't own, you receive an error.
 *
 * The `IamRole` field returned for this API operation is the role assigned to an Amazon EC2 instance configured with a Systems Manager Quick Setup host management configuration or the role assigned to an on-premises managed node.
 */
public suspend inline fun SsmClient.describeInstanceInformation(crossinline block: DescribeInstanceInformationRequest.Builder.() -> Unit): DescribeInstanceInformationResponse = describeInstanceInformation(DescribeInstanceInformationRequest.Builder().apply(block).build())

/**
 * Retrieves the high-level patch state of one or more managed nodes.
 */
public suspend inline fun SsmClient.describeInstancePatchStates(crossinline block: DescribeInstancePatchStatesRequest.Builder.() -> Unit): DescribeInstancePatchStatesResponse = describeInstancePatchStates(DescribeInstancePatchStatesRequest.Builder().apply(block).build())

/**
 * Retrieves the high-level patch state for the managed nodes in the specified patch group.
 */
public suspend inline fun SsmClient.describeInstancePatchStatesForPatchGroup(crossinline block: DescribeInstancePatchStatesForPatchGroupRequest.Builder.() -> Unit): DescribeInstancePatchStatesForPatchGroupResponse = describeInstancePatchStatesForPatchGroup(DescribeInstancePatchStatesForPatchGroupRequest.Builder().apply(block).build())

/**
 * Retrieves information about the patches on the specified managed node and their state relative to the patch baseline being used for the node.
 */
public suspend inline fun SsmClient.describeInstancePatches(crossinline block: DescribeInstancePatchesRequest.Builder.() -> Unit): DescribeInstancePatchesResponse = describeInstancePatches(DescribeInstancePatchesRequest.Builder().apply(block).build())

/**
 * An API operation used by the Systems Manager console to display information about Systems Manager managed nodes.
 */
public suspend inline fun SsmClient.describeInstanceProperties(crossinline block: DescribeInstancePropertiesRequest.Builder.() -> Unit): DescribeInstancePropertiesResponse = describeInstanceProperties(DescribeInstancePropertiesRequest.Builder().apply(block).build())

/**
 * Describes a specific delete inventory operation.
 */
public suspend inline fun SsmClient.describeInventoryDeletions(crossinline block: DescribeInventoryDeletionsRequest.Builder.() -> Unit): DescribeInventoryDeletionsResponse = describeInventoryDeletions(DescribeInventoryDeletionsRequest.Builder().apply(block).build())

/**
 * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance window execution.
 */
public suspend inline fun SsmClient.describeMaintenanceWindowExecutionTaskInvocations(crossinline block: DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder.() -> Unit): DescribeMaintenanceWindowExecutionTaskInvocationsResponse = describeMaintenanceWindowExecutionTaskInvocations(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder().apply(block).build())

/**
 * For a given maintenance window execution, lists the tasks that were run.
 */
public suspend inline fun SsmClient.describeMaintenanceWindowExecutionTasks(crossinline block: DescribeMaintenanceWindowExecutionTasksRequest.Builder.() -> Unit): DescribeMaintenanceWindowExecutionTasksResponse = describeMaintenanceWindowExecutionTasks(DescribeMaintenanceWindowExecutionTasksRequest.Builder().apply(block).build())

/**
 * Lists the executions of a maintenance window. This includes information about when the maintenance window was scheduled to be active, and information about tasks registered and run with the maintenance window.
 */
public suspend inline fun SsmClient.describeMaintenanceWindowExecutions(crossinline block: DescribeMaintenanceWindowExecutionsRequest.Builder.() -> Unit): DescribeMaintenanceWindowExecutionsResponse = describeMaintenanceWindowExecutions(DescribeMaintenanceWindowExecutionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about upcoming executions of a maintenance window.
 */
public suspend inline fun SsmClient.describeMaintenanceWindowSchedule(crossinline block: DescribeMaintenanceWindowScheduleRequest.Builder.() -> Unit): DescribeMaintenanceWindowScheduleResponse = describeMaintenanceWindowSchedule(DescribeMaintenanceWindowScheduleRequest.Builder().apply(block).build())

/**
 * Lists the targets registered with the maintenance window.
 */
public suspend inline fun SsmClient.describeMaintenanceWindowTargets(crossinline block: DescribeMaintenanceWindowTargetsRequest.Builder.() -> Unit): DescribeMaintenanceWindowTargetsResponse = describeMaintenanceWindowTargets(DescribeMaintenanceWindowTargetsRequest.Builder().apply(block).build())

/**
 * Lists the tasks in a maintenance window.
 *
 * For maintenance window tasks without a specified target, you can't supply values for `--max-errors` and `--max-concurrency`. Instead, the system inserts a placeholder value of `1`, which may be reported in the response to this command. These values don't affect the running of your task and can be ignored.
 */
public suspend inline fun SsmClient.describeMaintenanceWindowTasks(crossinline block: DescribeMaintenanceWindowTasksRequest.Builder.() -> Unit): DescribeMaintenanceWindowTasksResponse = describeMaintenanceWindowTasks(DescribeMaintenanceWindowTasksRequest.Builder().apply(block).build())

/**
 * Retrieves the maintenance windows in an Amazon Web Services account.
 */
public suspend inline fun SsmClient.describeMaintenanceWindows(crossinline block: DescribeMaintenanceWindowsRequest.Builder.() -> Unit): DescribeMaintenanceWindowsResponse = describeMaintenanceWindows(DescribeMaintenanceWindowsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the maintenance window targets or tasks that a managed node is associated with.
 */
public suspend inline fun SsmClient.describeMaintenanceWindowsForTarget(crossinline block: DescribeMaintenanceWindowsForTargetRequest.Builder.() -> Unit): DescribeMaintenanceWindowsForTargetResponse = describeMaintenanceWindowsForTarget(DescribeMaintenanceWindowsForTargetRequest.Builder().apply(block).build())

/**
 * Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of OpsItems. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
 *
 * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see [Amazon Web Services Systems Manager OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html) in the *Amazon Web Services Systems Manager User Guide*.
 */
public suspend inline fun SsmClient.describeOpsItems(crossinline block: DescribeOpsItemsRequest.Builder.() -> Unit): DescribeOpsItemsResponse = describeOpsItems(DescribeOpsItemsRequest.Builder().apply(block).build())

/**
 * Lists the parameters in your Amazon Web Services account or the parameters shared with you when you enable the [Shared](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribeParameters.html#systemsmanager-DescribeParameters-request-Shared) option.
 *
 * Request results are returned on a best-effort basis. If you specify `MaxResults` in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of `MaxResults`. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a `NextToken`. You can specify the `NextToken` in a subsequent call to get the next set of results.
 *
 * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
 *
 * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key alias the parameter uses to reference KMS. Otherwise, `DescribeParameters` retrieves whatever the original key alias was referencing.
 */
public suspend inline fun SsmClient.describeParameters(crossinline block: DescribeParametersRequest.Builder.() -> Unit): DescribeParametersResponse = describeParameters(DescribeParametersRequest.Builder().apply(block).build())

/**
 * Lists the patch baselines in your Amazon Web Services account.
 */
public suspend inline fun SsmClient.describePatchBaselines(crossinline block: DescribePatchBaselinesRequest.Builder.() -> Unit): DescribePatchBaselinesResponse = describePatchBaselines(DescribePatchBaselinesRequest.Builder().apply(block).build())

/**
 * Returns high-level aggregated patch compliance state information for a patch group.
 */
public suspend inline fun SsmClient.describePatchGroupState(crossinline block: DescribePatchGroupStateRequest.Builder.() -> Unit): DescribePatchGroupStateResponse = describePatchGroupState(DescribePatchGroupStateRequest.Builder().apply(block).build())

/**
 * Lists all patch groups that have been registered with patch baselines.
 */
public suspend inline fun SsmClient.describePatchGroups(crossinline block: DescribePatchGroupsRequest.Builder.() -> Unit): DescribePatchGroupsResponse = describePatchGroups(DescribePatchGroupsRequest.Builder().apply(block).build())

/**
 * Lists the properties of available patches organized by product, product family, classification, severity, and other properties of available patches. You can use the reported properties in the filters you specify in requests for operations such as CreatePatchBaseline, UpdatePatchBaseline, DescribeAvailablePatches, and DescribePatchBaselines.
 *
 * The following section lists the properties that can be used in filters for each major operating system type:
 *
 * ## AMAZON_LINUX
 * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
 *
 * ## AMAZON_LINUX_2
 * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
 *
 * ## AMAZON_LINUX_2023
 * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
 *
 * ## CENTOS
 * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
 *
 * ## DEBIAN
 * Valid properties: `PRODUCT` | `PRIORITY`
 *
 * ## MACOS
 * Valid properties: `PRODUCT` | `CLASSIFICATION`
 *
 * ## ORACLE_LINUX
 * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
 *
 * ## REDHAT_ENTERPRISE_LINUX
 * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
 *
 * ## SUSE
 * Valid properties: `PRODUCT` | `CLASSIFICATION` | `SEVERITY`
 *
 * ## UBUNTU
 * Valid properties: `PRODUCT` | `PRIORITY`
 *
 * ## WINDOWS
 * Valid properties: `PRODUCT` | `PRODUCT_FAMILY` | `CLASSIFICATION` | `MSRC_SEVERITY`
 */
public suspend inline fun SsmClient.describePatchProperties(crossinline block: DescribePatchPropertiesRequest.Builder.() -> Unit): DescribePatchPropertiesResponse = describePatchProperties(DescribePatchPropertiesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30 days.
 */
public suspend inline fun SsmClient.describeSessions(crossinline block: DescribeSessionsRequest.Builder.() -> Unit): DescribeSessionsResponse = describeSessions(DescribeSessionsRequest.Builder().apply(block).build())

/**
 * Deletes the association between an OpsItem and a related item. For example, this API operation can delete an Incident Manager incident from an OpsItem. Incident Manager is a tool in Amazon Web Services Systems Manager.
 */
public suspend inline fun SsmClient.disassociateOpsItemRelatedItem(crossinline block: DisassociateOpsItemRelatedItemRequest.Builder.() -> Unit): DisassociateOpsItemRelatedItemResponse = disassociateOpsItemRelatedItem(DisassociateOpsItemRelatedItemRequest.Builder().apply(block).build())

/**
 * Returns a credentials set to be used with just-in-time node access.
 */
public suspend inline fun SsmClient.getAccessToken(crossinline block: GetAccessTokenRequest.Builder.() -> Unit): GetAccessTokenResponse = getAccessToken(GetAccessTokenRequest.Builder().apply(block).build())

/**
 * Get detailed information about a particular Automation execution.
 */
public suspend inline fun SsmClient.getAutomationExecution(crossinline block: GetAutomationExecutionRequest.Builder.() -> Unit): GetAutomationExecutionResponse = getAutomationExecution(GetAutomationExecutionRequest.Builder().apply(block).build())

/**
 * Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time. If you specify a time, `GetCalendarState` returns the state of the calendar at that specific time, and returns the next time that the change calendar state will transition. If you don't specify a time, `GetCalendarState` uses the current time. Change Calendar entries have two possible states: `OPEN` or `CLOSED`.
 *
 * If you specify more than one calendar in a request, the command returns the status of `OPEN` only if all calendars in the request are open. If one or more calendars in the request are closed, the status returned is `CLOSED`.
 *
 * For more information about Change Calendar, a tool in Amazon Web Services Systems Manager, see [Amazon Web Services Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html) in the *Amazon Web Services Systems Manager User Guide*.
 */
public suspend inline fun SsmClient.getCalendarState(crossinline block: GetCalendarStateRequest.Builder.() -> Unit): GetCalendarStateResponse = getCalendarState(GetCalendarStateRequest.Builder().apply(block).build())

/**
 * Returns detailed information about command execution for an invocation or plugin. The Run Command API follows an eventual consistency model, due to the distributed nature of the system supporting the API. This means that the result of an API command you run that affects your resources might not be immediately visible to all subsequent commands you run. You should keep this in mind when you carry out an API command that immediately follows a previous API command.
 *
 * `GetCommandInvocation` only gives the execution status of a plugin in a document. To get the command execution status on a specific managed node, use ListCommandInvocations. To get the command execution status across managed nodes, use ListCommands.
 */
public suspend inline fun SsmClient.getCommandInvocation(crossinline block: GetCommandInvocationRequest.Builder.() -> Unit): GetCommandInvocationResponse = getCommandInvocation(GetCommandInvocationRequest.Builder().apply(block).build())

/**
 * Retrieves the Session Manager connection status for a managed node to determine whether it is running and ready to receive Session Manager connections.
 */
public suspend inline fun SsmClient.getConnectionStatus(crossinline block: GetConnectionStatusRequest.Builder.() -> Unit): GetConnectionStatusResponse = getConnectionStatus(GetConnectionStatusRequest.Builder().apply(block).build())

/**
 * Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.
 *
 * If you don't specify an operating system value, the default patch baseline for Windows is returned.
 */
public suspend inline fun SsmClient.getDefaultPatchBaseline(crossinline block: GetDefaultPatchBaselineRequest.Builder.() -> Unit): GetDefaultPatchBaselineResponse = getDefaultPatchBaseline(GetDefaultPatchBaselineRequest.Builder().apply(block).build())

/**
 * Retrieves the current snapshot for the patch baseline the managed node uses. This API is primarily used by the `AWS-RunPatchBaseline` Systems Manager document (SSM document).
 *
 * If you run the command locally, such as with the Command Line Interface (CLI), the system attempts to use your local Amazon Web Services credentials and the operation fails. To avoid this, you can run the command in the Amazon Web Services Systems Manager console. Use Run Command, a tool in Amazon Web Services Systems Manager, with an SSM document that enables you to target a managed node with a script or command. For example, run the command using the `AWS-RunShellScript` document or the `AWS-RunPowerShellScript` document.
 */
public suspend inline fun SsmClient.getDeployablePatchSnapshotForInstance(crossinline block: GetDeployablePatchSnapshotForInstanceRequest.Builder.() -> Unit): GetDeployablePatchSnapshotForInstanceResponse = getDeployablePatchSnapshotForInstance(GetDeployablePatchSnapshotForInstanceRequest.Builder().apply(block).build())

/**
 * Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).
 */
public suspend inline fun SsmClient.getDocument(crossinline block: GetDocumentRequest.Builder.() -> Unit): GetDocumentResponse = getDocument(GetDocumentRequest.Builder().apply(block).build())

/**
 * Initiates the process of retrieving an existing preview that shows the effects that running a specified Automation runbook would have on the targeted resources.
 */
public suspend inline fun SsmClient.getExecutionPreview(crossinline block: GetExecutionPreviewRequest.Builder.() -> Unit): GetExecutionPreviewResponse = getExecutionPreview(GetExecutionPreviewRequest.Builder().apply(block).build())

/**
 * Query inventory information. This includes managed node status, such as `Stopped` or `Terminated`.
 */
public suspend inline fun SsmClient.getInventory(crossinline block: GetInventoryRequest.Builder.() -> Unit): GetInventoryResponse = getInventory(GetInventoryRequest.Builder().apply(block).build())

/**
 * Return a list of inventory type names for the account, or return a list of attribute names for a specific Inventory item type.
 */
public suspend inline fun SsmClient.getInventorySchema(crossinline block: GetInventorySchemaRequest.Builder.() -> Unit): GetInventorySchemaResponse = getInventorySchema(GetInventorySchemaRequest.Builder().apply(block).build())

/**
 * Retrieves a maintenance window.
 */
public suspend inline fun SsmClient.getMaintenanceWindow(crossinline block: GetMaintenanceWindowRequest.Builder.() -> Unit): GetMaintenanceWindowResponse = getMaintenanceWindow(GetMaintenanceWindowRequest.Builder().apply(block).build())

/**
 * Retrieves details about a specific a maintenance window execution.
 */
public suspend inline fun SsmClient.getMaintenanceWindowExecution(crossinline block: GetMaintenanceWindowExecutionRequest.Builder.() -> Unit): GetMaintenanceWindowExecutionResponse = getMaintenanceWindowExecution(GetMaintenanceWindowExecutionRequest.Builder().apply(block).build())

/**
 * Retrieves the details about a specific task run as part of a maintenance window execution.
 */
public suspend inline fun SsmClient.getMaintenanceWindowExecutionTask(crossinline block: GetMaintenanceWindowExecutionTaskRequest.Builder.() -> Unit): GetMaintenanceWindowExecutionTaskResponse = getMaintenanceWindowExecutionTask(GetMaintenanceWindowExecutionTaskRequest.Builder().apply(block).build())

/**
 * Retrieves information about a specific task running on a specific target.
 */
public suspend inline fun SsmClient.getMaintenanceWindowExecutionTaskInvocation(crossinline block: GetMaintenanceWindowExecutionTaskInvocationRequest.Builder.() -> Unit): GetMaintenanceWindowExecutionTaskInvocationResponse = getMaintenanceWindowExecutionTaskInvocation(GetMaintenanceWindowExecutionTaskInvocationRequest.Builder().apply(block).build())

/**
 * Retrieves the details of a maintenance window task.
 *
 * For maintenance window tasks without a specified target, you can't supply values for `--max-errors` and `--max-concurrency`. Instead, the system inserts a placeholder value of `1`, which may be reported in the response to this command. These values don't affect the running of your task and can be ignored.
 *
 * To retrieve a list of tasks in a maintenance window, instead use the DescribeMaintenanceWindowTasks command.
 */
public suspend inline fun SsmClient.getMaintenanceWindowTask(crossinline block: GetMaintenanceWindowTaskRequest.Builder.() -> Unit): GetMaintenanceWindowTaskResponse = getMaintenanceWindowTask(GetMaintenanceWindowTaskRequest.Builder().apply(block).build())

/**
 * Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management (IAM) to view information about an OpsItem. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
 *
 * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see [Amazon Web Services Systems Manager OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html) in the *Amazon Web Services Systems Manager User Guide*.
 */
public suspend inline fun SsmClient.getOpsItem(crossinline block: GetOpsItemRequest.Builder.() -> Unit): GetOpsItemResponse = getOpsItem(GetOpsItemRequest.Builder().apply(block).build())

/**
 * View operational metadata related to an application in Application Manager.
 */
public suspend inline fun SsmClient.getOpsMetadata(crossinline block: GetOpsMetadataRequest.Builder.() -> Unit): GetOpsMetadataResponse = getOpsMetadata(GetOpsMetadataRequest.Builder().apply(block).build())

/**
 * View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services Systems Manager Explorer.
 */
public suspend inline fun SsmClient.getOpsSummary(crossinline block: GetOpsSummaryRequest.Builder.() -> Unit): GetOpsSummaryResponse = getOpsSummary(GetOpsSummaryRequest.Builder().apply(block).build())

/**
 * Get information about a single parameter by specifying the parameter name.
 *
 * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
 *
 * To get information about more than one parameter at a time, use the GetParameters operation.
 */
public suspend inline fun SsmClient.getParameter(crossinline block: GetParameterRequest.Builder.() -> Unit): GetParameterResponse = getParameter(GetParameterRequest.Builder().apply(block).build())

/**
 * Retrieves the history of all changes to a parameter.
 *
 * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
 *
 * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key alias the parameter uses to reference KMS. Otherwise, `GetParameterHistory` retrieves whatever the original key alias was referencing.
 */
public suspend inline fun SsmClient.getParameterHistory(crossinline block: GetParameterHistoryRequest.Builder.() -> Unit): GetParameterHistoryResponse = getParameterHistory(GetParameterHistoryRequest.Builder().apply(block).build())

/**
 * Get information about one or more parameters by specifying multiple parameter names.
 *
 * To get information about a single parameter, you can use the GetParameter operation instead.
 *
 * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
 */
public suspend inline fun SsmClient.getParameters(crossinline block: GetParametersRequest.Builder.() -> Unit): GetParametersResponse = getParameters(GetParametersRequest.Builder().apply(block).build())

/**
 * Retrieve information about one or more parameters under a specified level in a hierarchy.
 *
 * Request results are returned on a best-effort basis. If you specify `MaxResults` in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of `MaxResults`. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a `NextToken`. You can specify the `NextToken` in a subsequent call to get the next set of results.
 *
 * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
 */
public suspend inline fun SsmClient.getParametersByPath(crossinline block: GetParametersByPathRequest.Builder.() -> Unit): GetParametersByPathResponse = getParametersByPath(GetParametersByPathRequest.Builder().apply(block).build())

/**
 * Retrieves information about a patch baseline.
 */
public suspend inline fun SsmClient.getPatchBaseline(crossinline block: GetPatchBaselineRequest.Builder.() -> Unit): GetPatchBaselineResponse = getPatchBaseline(GetPatchBaselineRequest.Builder().apply(block).build())

/**
 * Retrieves the patch baseline that should be used for the specified patch group.
 */
public suspend inline fun SsmClient.getPatchBaselineForPatchGroup(crossinline block: GetPatchBaselineForPatchGroupRequest.Builder.() -> Unit): GetPatchBaselineForPatchGroupResponse = getPatchBaselineForPatchGroup(GetPatchBaselineForPatchGroupRequest.Builder().apply(block).build())

/**
 * Returns an array of the `Policy` object.
 */
public suspend inline fun SsmClient.getResourcePolicies(crossinline block: GetResourcePoliciesRequest.Builder.() -> Unit): GetResourcePoliciesResponse = getResourcePolicies(GetResourcePoliciesRequest.Builder().apply(block).build())

/**
 * `ServiceSetting` is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of `false`. This means the user can't use this feature unless they change the setting to `true` and intentionally opt in for a paid feature.
 *
 * Services map a `SettingId` object to a setting value. Amazon Web Services services teams define the default value for a `SettingId`. You can't create a new `SettingId`, but you can overwrite the default value if you have the `ssm:UpdateServiceSetting` permission for the setting. Use the UpdateServiceSetting API operation to change the default setting. Or use the ResetServiceSetting to change the value back to the original value defined by the Amazon Web Services service team.
 *
 * Query the current service setting for the Amazon Web Services account.
 */
public suspend inline fun SsmClient.getServiceSetting(crossinline block: GetServiceSettingRequest.Builder.() -> Unit): GetServiceSettingResponse = getServiceSetting(GetServiceSettingRequest.Builder().apply(block).build())

/**
 * A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically saves a new version and increments the version number by one. A label can help you remember the purpose of a parameter when there are multiple versions.
 *
 * Parameter labels have the following requirements and restrictions.
 * + A version of a parameter can have a maximum of 10 labels.
 * + You can't attach the same label to different versions of the same parameter. For example, if version 1 has the label Production, then you can't attach Production to version 2.
 * + You can move a label from one version of a parameter to another.
 * + You can't create a label when you create a new parameter. You must attach a label to a specific version of a parameter.
 * + If you no longer want to use a parameter label, then you can either delete it or move it to a different version of a parameter.
 * + A label can have a maximum of 100 characters.
 * + Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).
 * + Labels can't begin with a number, "`aws`" or "`ssm`" (not case sensitive). If a label fails to meet these requirements, then the label isn't associated with a parameter and the system displays it in the list of InvalidLabels.
 * + Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
 */
public suspend inline fun SsmClient.labelParameterVersion(crossinline block: LabelParameterVersionRequest.Builder.() -> Unit): LabelParameterVersionResponse = labelParameterVersion(LabelParameterVersionRequest.Builder().apply(block).build())

/**
 * Retrieves all versions of an association for a specific association ID.
 */
public suspend inline fun SsmClient.listAssociationVersions(crossinline block: ListAssociationVersionsRequest.Builder.() -> Unit): ListAssociationVersionsResponse = listAssociationVersions(ListAssociationVersionsRequest.Builder().apply(block).build())

/**
 * Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region. You can limit the results to a specific State Manager association document or managed node by specifying a filter. State Manager is a tool in Amazon Web Services Systems Manager.
 */
public suspend inline fun SsmClient.listAssociations(crossinline block: ListAssociationsRequest.Builder.() -> Unit): ListAssociationsResponse = listAssociations(ListAssociationsRequest.Builder().apply(block).build())

/**
 * An invocation is copy of a command sent to a specific managed node. A command can apply to one or more managed nodes. A command invocation applies to one managed node. For example, if a user runs `SendCommand` against three managed nodes, then a command invocation is created for each requested managed node ID. `ListCommandInvocations` provide status about command execution.
 */
public suspend inline fun SsmClient.listCommandInvocations(crossinline block: ListCommandInvocationsRequest.Builder.() -> Unit): ListCommandInvocationsResponse = listCommandInvocations(ListCommandInvocationsRequest.Builder().apply(block).build())

/**
 * Lists the commands requested by users of the Amazon Web Services account.
 */
public suspend inline fun SsmClient.listCommands(crossinline block: ListCommandsRequest.Builder.() -> Unit): ListCommandsResponse = listCommands(ListCommandsRequest.Builder().apply(block).build())

/**
 * For a specified resource ID, this API operation returns a list of compliance statuses for different resource types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the filter.
 */
public suspend inline fun SsmClient.listComplianceItems(crossinline block: ListComplianceItemsRequest.Builder.() -> Unit): ListComplianceItemsResponse = listComplianceItems(ListComplianceItemsRequest.Builder().apply(block).build())

/**
 * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call can return State Manager associations, patches, or custom compliance types according to the filter criteria that you specify.
 */
public suspend inline fun SsmClient.listComplianceSummaries(crossinline block: ListComplianceSummariesRequest.Builder.() -> Unit): ListComplianceSummariesResponse = listComplianceSummaries(ListComplianceSummariesRequest.Builder().apply(block).build())

/**
 * Information about approval reviews for a version of a change template in Change Manager.
 */
public suspend inline fun SsmClient.listDocumentMetadataHistory(crossinline block: ListDocumentMetadataHistoryRequest.Builder.() -> Unit): ListDocumentMetadataHistoryResponse = listDocumentMetadataHistory(ListDocumentMetadataHistoryRequest.Builder().apply(block).build())

/**
 * List all versions for a document.
 */
public suspend inline fun SsmClient.listDocumentVersions(crossinline block: ListDocumentVersionsRequest.Builder.() -> Unit): ListDocumentVersionsResponse = listDocumentVersions(ListDocumentVersionsRequest.Builder().apply(block).build())

/**
 * Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services Region. You can limit the results of this request by using a filter.
 */
public suspend inline fun SsmClient.listDocuments(crossinline block: ListDocumentsRequest.Builder.() -> Unit): ListDocumentsResponse = listDocuments(ListDocumentsRequest.Builder().apply(block).build())

/**
 * A list of inventory items returned by the request.
 */
public suspend inline fun SsmClient.listInventoryEntries(crossinline block: ListInventoryEntriesRequest.Builder.() -> Unit): ListInventoryEntriesResponse = listInventoryEntries(ListInventoryEntriesRequest.Builder().apply(block).build())

/**
 * Takes in filters and returns a list of managed nodes matching the filter criteria.
 */
public suspend inline fun SsmClient.listNodes(crossinline block: ListNodesRequest.Builder.() -> Unit): ListNodesResponse = listNodes(ListNodesRequest.Builder().apply(block).build())

/**
 * Generates a summary of managed instance/node metadata based on the filters and aggregators you specify. Results are grouped by the input aggregator you specify.
 *
 * @sample aws.sdk.kotlin.services.ssm.samples.ListNodesSummary.sample
 */
public suspend inline fun SsmClient.listNodesSummary(crossinline block: ListNodesSummaryRequest.Builder.() -> Unit): ListNodesSummaryResponse = listNodesSummary(ListNodesSummaryRequest.Builder().apply(block).build())

/**
 * Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account. You can limit the results to events associated with specific OpsItems by specifying a filter.
 */
public suspend inline fun SsmClient.listOpsItemEvents(crossinline block: ListOpsItemEventsRequest.Builder.() -> Unit): ListOpsItemEventsResponse = listOpsItemEvents(ListOpsItemEventsRequest.Builder().apply(block).build())

/**
 * Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a tool in Amazon Web Services Systems Manager.
 */
public suspend inline fun SsmClient.listOpsItemRelatedItems(crossinline block: ListOpsItemRelatedItemsRequest.Builder.() -> Unit): ListOpsItemRelatedItemsResponse = listOpsItemRelatedItems(ListOpsItemRelatedItemsRequest.Builder().apply(block).build())

/**
 * Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata objects or blobs.
 */
public suspend inline fun SsmClient.listOpsMetadata(crossinline block: ListOpsMetadataRequest.Builder.() -> Unit): ListOpsMetadataResponse = listOpsMetadata(ListOpsMetadataRequest.Builder().apply(block).build())

/**
 * Returns a resource-level summary count. The summary includes information about compliant and non-compliant statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
 */
public suspend inline fun SsmClient.listResourceComplianceSummaries(crossinline block: ListResourceComplianceSummariesRequest.Builder.() -> Unit): ListResourceComplianceSummariesResponse = listResourceComplianceSummaries(ListResourceComplianceSummariesRequest.Builder().apply(block).build())

/**
 * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start, the last sync status, and the last time a sync successfully completed.
 *
 * The number of sync configurations might be too large to return using a single call to `ListResourceDataSync`. You can limit the number of sync configurations returned by using the `MaxResults` parameter. To determine whether there are more sync configurations to list, check the value of `NextToken` in the output. If there are more sync configurations to list, you can request them by specifying the `NextToken` returned in the call to the parameter of a subsequent call.
 */
public suspend inline fun SsmClient.listResourceDataSync(crossinline block: ListResourceDataSyncRequest.Builder.() -> Unit): ListResourceDataSyncResponse = listResourceDataSync(ListResourceDataSyncRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags assigned to the specified resource.
 *
 * For information about the ID format for each supported resource type, see AddTagsToResource.
 */
public suspend inline fun SsmClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a document privately, you must specify the Amazon Web Services user IDs for those people who can use the document. If you share a document publicly, you must specify *All* as the account ID.
 */
public suspend inline fun SsmClient.modifyDocumentPermission(crossinline block: ModifyDocumentPermissionRequest.Builder.() -> Unit): ModifyDocumentPermissionResponse = modifyDocumentPermission(ModifyDocumentPermissionRequest.Builder().apply(block).build())

/**
 * Registers a compliance type and other compliance details on a designated resource. This operation lets you register custom compliance details with a resource. This call overwrites existing compliance information on the resource, so you must provide a full list of compliance items each time that you send the request.
 *
 * ComplianceType can be one of the following:
 * + ExecutionId: The execution ID when the patch, association, or custom compliance item was applied.
 * + ExecutionType: Specify patch, association, or Custom:`string`.
 * + ExecutionTime. The time the patch, association, or custom compliance item was applied to the managed node.For State Manager associations, this represents the time when compliance status was captured by the Systems Manager service during its internal compliance aggregation workflow, not necessarily when the association was executed on the managed node. State Manager updates compliance information for all associations on an instance whenever any association executes, which may result in multiple associations showing the same execution time.
 * + Id: The patch, association, or custom compliance ID.
 * + Title: A title.
 * + Status: The status of the compliance item. For example, `approved` for patches, or `Failed` for associations.
 * + Severity: A patch severity. For example, `Critical`.
 * + DocumentName: An SSM document name. For example, `AWS-RunPatchBaseline`.
 * + DocumentVersion: An SSM document version number. For example, 4.
 * + Classification: A patch classification. For example, `security updates`.
 * + PatchBaselineId: A patch baseline ID.
 * + PatchSeverity: A patch severity. For example, `Critical`.
 * + PatchState: A patch state. For example, `InstancesWithFailedPatches`.
 * + PatchGroup: The name of a patch group.
 * + InstalledTime: The time the association, patch, or custom compliance item was applied to the resource. Specify the time by using the following format: `yyyy-MM-dd'T'HH:mm:ss'Z'`
 */
public suspend inline fun SsmClient.putComplianceItems(crossinline block: PutComplianceItemsRequest.Builder.() -> Unit): PutComplianceItemsResponse = putComplianceItems(PutComplianceItemsRequest.Builder().apply(block).build())

/**
 * Bulk update custom inventory items on one or more managed nodes. The request adds an inventory item, if it doesn't already exist, or updates an inventory item, if it does exist.
 */
public suspend inline fun SsmClient.putInventory(crossinline block: PutInventoryRequest.Builder.() -> Unit): PutInventoryResponse = putInventory(PutInventoryRequest.Builder().apply(block).build())

/**
 * Create or update a parameter in Parameter Store.
 */
public suspend inline fun SsmClient.putParameter(crossinline block: PutParameterRequest.Builder.() -> Unit): PutParameterResponse = putParameter(PutParameterRequest.Builder().apply(block).build())

/**
 * Creates or updates a Systems Manager resource policy. A resource policy helps you to define the IAM entity (for example, an Amazon Web Services account) that can manage your Systems Manager resources. The following resources support Systems Manager resource policies.
 * + `OpsItemGroup` - The resource policy for `OpsItemGroup` enables Amazon Web Services accounts to view and interact with OpsCenter operational work items (OpsItems).
 * + `Parameter` - The resource policy is used to share a parameter with other accounts using Resource Access Manager (RAM). To share a parameter, it must be in the advanced parameter tier. For information about parameter tiers, see [Managing parameter tiers](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html). For information about changing an existing standard parameter to an advanced parameter, see [Changing a standard parameter to an advanced parameter](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html#parameter-store-advanced-parameters-enabling).To share a `SecureString` parameter, it must be encrypted with a customer managed key, and you must share the key separately through Key Management Service. Amazon Web Services managed keys cannot be shared. Parameters encrypted with the default Amazon Web Services managed key can be updated to use a customer managed key instead. For KMS key definitions, see [KMS concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html) in the *Key Management Service Developer Guide*.While you can share a parameter using the Systems Manager `PutResourcePolicy` operation, we recommend using Resource Access Manager (RAM) instead. This is because using `PutResourcePolicy` requires the extra step of promoting the parameter to a standard RAM Resource Share using the RAM [PromoteResourceShareCreatedFromPolicy](https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) API operation. Otherwise, the parameter won't be returned by the Systems Manager [DescribeParameters](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribeParameters.html) API operation using the `--shared` option.For more information, see [Sharing a parameter](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-shared-parameters.html#share) in the *Amazon Web Services Systems Manager User Guide*
 */
public suspend inline fun SsmClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Defines the default patch baseline for the relevant operating system.
 *
 * To reset the Amazon Web Services-predefined patch baseline as the default, specify the full patch baseline Amazon Resource Name (ARN) as the baseline ID value. For example, for CentOS, specify `arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed` instead of `pb-0574b43a65ea646ed`.
 */
public suspend inline fun SsmClient.registerDefaultPatchBaseline(crossinline block: RegisterDefaultPatchBaselineRequest.Builder.() -> Unit): RegisterDefaultPatchBaselineResponse = registerDefaultPatchBaseline(RegisterDefaultPatchBaselineRequest.Builder().apply(block).build())

/**
 * Registers a patch baseline for a patch group.
 */
public suspend inline fun SsmClient.registerPatchBaselineForPatchGroup(crossinline block: RegisterPatchBaselineForPatchGroupRequest.Builder.() -> Unit): RegisterPatchBaselineForPatchGroupResponse = registerPatchBaselineForPatchGroup(RegisterPatchBaselineForPatchGroupRequest.Builder().apply(block).build())

/**
 * Registers a target with a maintenance window.
 */
public suspend inline fun SsmClient.registerTargetWithMaintenanceWindow(crossinline block: RegisterTargetWithMaintenanceWindowRequest.Builder.() -> Unit): RegisterTargetWithMaintenanceWindowResponse = registerTargetWithMaintenanceWindow(RegisterTargetWithMaintenanceWindowRequest.Builder().apply(block).build())

/**
 * Adds a new task to a maintenance window.
 */
public suspend inline fun SsmClient.registerTaskWithMaintenanceWindow(crossinline block: RegisterTaskWithMaintenanceWindowRequest.Builder.() -> Unit): RegisterTaskWithMaintenanceWindowResponse = registerTaskWithMaintenanceWindow(RegisterTaskWithMaintenanceWindowRequest.Builder().apply(block).build())

/**
 * Removes tag keys from the specified resource.
 */
public suspend inline fun SsmClient.removeTagsFromResource(crossinline block: RemoveTagsFromResourceRequest.Builder.() -> Unit): RemoveTagsFromResourceResponse = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

/**
 * `ServiceSetting` is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.
 *
 * Services map a `SettingId` object to a setting value. Amazon Web Services services teams define the default value for a `SettingId`. You can't create a new `SettingId`, but you can overwrite the default value if you have the `ssm:UpdateServiceSetting` permission for the setting. Use the GetServiceSetting API operation to view the current value. Use the UpdateServiceSetting API operation to change the default setting.
 *
 * Reset the service setting for the account to the default value as provisioned by the Amazon Web Services service team.
 */
public suspend inline fun SsmClient.resetServiceSetting(crossinline block: ResetServiceSettingRequest.Builder.() -> Unit): ResetServiceSettingResponse = resetServiceSetting(ResetServiceSettingRequest.Builder().apply(block).build())

/**
 * Reconnects a session to a managed node after it has been disconnected. Connections can be resumed for disconnected sessions, but not terminated sessions.
 *
 * This command is primarily for use by client machines to automatically reconnect during intermittent network issues. It isn't intended for any other use.
 */
public suspend inline fun SsmClient.resumeSession(crossinline block: ResumeSessionRequest.Builder.() -> Unit): ResumeSessionResponse = resumeSession(ResumeSessionRequest.Builder().apply(block).build())

/**
 * Sends a signal to an Automation execution to change the current behavior or status of the execution.
 */
public suspend inline fun SsmClient.sendAutomationSignal(crossinline block: SendAutomationSignalRequest.Builder.() -> Unit): SendAutomationSignalResponse = sendAutomationSignal(SendAutomationSignalRequest.Builder().apply(block).build())

/**
 * Runs commands on one or more managed nodes.
 */
public suspend inline fun SsmClient.sendCommand(crossinline block: SendCommandRequest.Builder.() -> Unit): SendCommandResponse = sendCommand(SendCommandRequest.Builder().apply(block).build())

/**
 * Starts the workflow for just-in-time node access sessions.
 */
public suspend inline fun SsmClient.startAccessRequest(crossinline block: StartAccessRequestRequest.Builder.() -> Unit): StartAccessRequestResponse = startAccessRequest(StartAccessRequestRequest.Builder().apply(block).build())

/**
 * Runs an association immediately and only one time. This operation can be helpful when troubleshooting associations.
 */
public suspend inline fun SsmClient.startAssociationsOnce(crossinline block: StartAssociationsOnceRequest.Builder.() -> Unit): StartAssociationsOnceResponse = startAssociationsOnce(StartAssociationsOnceRequest.Builder().apply(block).build())

/**
 * Initiates execution of an Automation runbook.
 */
public suspend inline fun SsmClient.startAutomationExecution(crossinline block: StartAutomationExecutionRequest.Builder.() -> Unit): StartAutomationExecutionResponse = startAutomationExecution(StartAutomationExecutionRequest.Builder().apply(block).build())

/**
 * Creates a change request for Change Manager. The Automation runbooks specified in the change request run only after all required approvals for the change request have been received.
 */
public suspend inline fun SsmClient.startChangeRequestExecution(crossinline block: StartChangeRequestExecutionRequest.Builder.() -> Unit): StartChangeRequestExecutionResponse = startChangeRequestExecution(StartChangeRequestExecutionRequest.Builder().apply(block).build())

/**
 * Initiates the process of creating a preview showing the effects that running a specified Automation runbook would have on the targeted resources.
 *
 * @sample aws.sdk.kotlin.services.ssm.samples.StartExecutionPreview.sample
 */
public suspend inline fun SsmClient.startExecutionPreview(crossinline block: StartExecutionPreviewRequest.Builder.() -> Unit): StartExecutionPreviewResponse = startExecutionPreview(StartExecutionPreviewRequest.Builder().apply(block).build())

/**
 * Initiates a connection to a target (for example, a managed node) for a Session Manager session. Returns a URL and token that can be used to open a WebSocket connection for sending input and receiving outputs.
 *
 * Amazon Web Services CLI usage: `start-session` is an interactive command that requires the Session Manager plugin to be installed on the client machine making the call. For information, see [Install the Session Manager plugin for the Amazon Web Services CLI](https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html) in the *Amazon Web Services Systems Manager User Guide*.
 *
 * Amazon Web Services Tools for PowerShell usage: Start-SSMSession isn't currently supported by Amazon Web Services Tools for PowerShell on Windows local machines.
 */
public suspend inline fun SsmClient.startSession(crossinline block: StartSessionRequest.Builder.() -> Unit): StartSessionResponse = startSession(StartSessionRequest.Builder().apply(block).build())

/**
 * Stop an Automation that is currently running.
 */
public suspend inline fun SsmClient.stopAutomationExecution(crossinline block: StopAutomationExecutionRequest.Builder.() -> Unit): StopAutomationExecutionResponse = stopAutomationExecution(StopAutomationExecutionRequest.Builder().apply(block).build())

/**
 * Permanently ends a session and closes the data connection between the Session Manager client and SSM Agent on the managed node. A terminated session can't be resumed.
 */
public suspend inline fun SsmClient.terminateSession(crossinline block: TerminateSessionRequest.Builder.() -> Unit): TerminateSessionResponse = terminateSession(TerminateSessionRequest.Builder().apply(block).build())

/**
 * Remove a label or labels from a parameter.
 *
 * Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
 */
public suspend inline fun SsmClient.unlabelParameterVersion(crossinline block: UnlabelParameterVersionRequest.Builder.() -> Unit): UnlabelParameterVersionResponse = unlabelParameterVersion(UnlabelParameterVersionRequest.Builder().apply(block).build())

/**
 * Updates an association. You can update the association name and version, the document version, schedule, parameters, and Amazon Simple Storage Service (Amazon S3) output. When you call `UpdateAssociation`, the system removes all optional parameters from the request and overwrites the association with null values for those parameters. This is by design. You must specify all optional parameters in the call, even if you are not changing the parameters. This includes the `Name` parameter. Before calling this API action, we recommend that you call the DescribeAssociation API operation and make a note of all optional parameters required for your `UpdateAssociation` call.
 *
 * In order to call this API operation, a user, group, or role must be granted permission to call the DescribeAssociation API operation. If you don't have permission to call `DescribeAssociation`, then you receive the following error: `An error occurred (AccessDeniedException) when calling the UpdateAssociation operation: User: <user_arn> isn't authorized to perform: ssm:DescribeAssociation on resource: <resource_arn>`
 *
 * When you update an association, the association immediately runs against the specified targets. You can add the `ApplyOnlyAtCronInterval` parameter to run the association during the next schedule run.
 */
public suspend inline fun SsmClient.updateAssociation(crossinline block: UpdateAssociationRequest.Builder.() -> Unit): UpdateAssociationResponse = updateAssociation(UpdateAssociationRequest.Builder().apply(block).build())

/**
 * Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the specified managed node.
 *
 * `UpdateAssociationStatus` is primarily used by the Amazon Web Services Systems Manager Agent (SSM Agent) to report status updates about your associations and is only used for associations created with the `InstanceId` legacy parameter.
 */
public suspend inline fun SsmClient.updateAssociationStatus(crossinline block: UpdateAssociationStatusRequest.Builder.() -> Unit): UpdateAssociationStatusResponse = updateAssociationStatus(UpdateAssociationStatusRequest.Builder().apply(block).build())

/**
 * Updates one or more values for an SSM document.
 */
public suspend inline fun SsmClient.updateDocument(crossinline block: UpdateDocumentRequest.Builder.() -> Unit): UpdateDocumentResponse = updateDocument(UpdateDocumentRequest.Builder().apply(block).build())

/**
 * Set the default version of a document.
 *
 * If you change a document version for a State Manager association, Systems Manager immediately runs the association unless you previously specifed the `apply-only-at-cron-interval` parameter.
 */
public suspend inline fun SsmClient.updateDocumentDefaultVersion(crossinline block: UpdateDocumentDefaultVersionRequest.Builder.() -> Unit): UpdateDocumentDefaultVersionResponse = updateDocumentDefaultVersion(UpdateDocumentDefaultVersionRequest.Builder().apply(block).build())

/**
 * Updates information related to approval reviews for a specific version of a change template in Change Manager.
 */
public suspend inline fun SsmClient.updateDocumentMetadata(crossinline block: UpdateDocumentMetadataRequest.Builder.() -> Unit): UpdateDocumentMetadataResponse = updateDocumentMetadata(UpdateDocumentMetadataRequest.Builder().apply(block).build())

/**
 * Updates an existing maintenance window. Only specified parameters are modified.
 *
 * The value you specify for `Duration` determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for `Cutoff`. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for `Cutoff` is one hour, no maintenance window tasks can start after 5 PM.
 */
public suspend inline fun SsmClient.updateMaintenanceWindow(crossinline block: UpdateMaintenanceWindowRequest.Builder.() -> Unit): UpdateMaintenanceWindowResponse = updateMaintenanceWindow(UpdateMaintenanceWindowRequest.Builder().apply(block).build())

/**
 * Modifies the target of an existing maintenance window. You can change the following:
 * + Name
 * + Description
 * + Owner
 * + IDs for an ID target
 * + Tags for a Tag target
 * + From any supported tag type to another. The three supported tag types are ID target, Tag target, and resource group. For more information, see Target.
 *
 * If a parameter is null, then the corresponding field isn't modified.
 */
public suspend inline fun SsmClient.updateMaintenanceWindowTarget(crossinline block: UpdateMaintenanceWindowTargetRequest.Builder.() -> Unit): UpdateMaintenanceWindowTargetResponse = updateMaintenanceWindowTarget(UpdateMaintenanceWindowTargetRequest.Builder().apply(block).build())

/**
 * Modifies a task assigned to a maintenance window. You can't change the task type, but you can change the following values:
 * + `TaskARN`. For example, you can change a `RUN_COMMAND` task from `AWS-RunPowerShellScript` to `AWS-RunShellScript`.
 * + `ServiceRoleArn`
 * + `TaskInvocationParameters`
 * + `Priority`
 * + `MaxConcurrency`
 * + `MaxErrors`
 *
 * One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don't specify targets, see [Registering maintenance window tasks without targets](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) in the *Amazon Web Services Systems Manager User Guide*.
 *
 * If the value for a parameter in `UpdateMaintenanceWindowTask` is null, then the corresponding field isn't modified. If you set `Replace` to true, then all fields required by the RegisterTaskWithMaintenanceWindow operation are required for this request. Optional fields that aren't specified are set to null.
 *
 * When you update a maintenance window task that has options specified in `TaskInvocationParameters`, you must provide again all the `TaskInvocationParameters` values that you want to retain. The values you don't specify again are removed. For example, suppose that when you registered a Run Command task, you specified `TaskInvocationParameters` values for `Comment`, `NotificationConfig`, and `OutputS3BucketName`. If you update the maintenance window task and specify only a different `OutputS3BucketName` value, the values for `Comment` and `NotificationConfig` are removed.
 */
public suspend inline fun SsmClient.updateMaintenanceWindowTask(crossinline block: UpdateMaintenanceWindowTaskRequest.Builder.() -> Unit): UpdateMaintenanceWindowTaskResponse = updateMaintenanceWindowTask(UpdateMaintenanceWindowTaskRequest.Builder().apply(block).build())

/**
 * Changes the Identity and Access Management (IAM) role that is assigned to the on-premises server, edge device, or virtual machines (VM). IAM roles are first assigned to these hybrid nodes during the activation process. For more information, see CreateActivation.
 */
public suspend inline fun SsmClient.updateManagedInstanceRole(crossinline block: UpdateManagedInstanceRoleRequest.Builder.() -> Unit): UpdateManagedInstanceRoleResponse = updateManagedInstanceRole(UpdateManagedInstanceRoleRequest.Builder().apply(block).build())

/**
 * Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM) to update an OpsItem. For more information, see [Set up OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html) in the *Amazon Web Services Systems Manager User Guide*.
 *
 * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see [Amazon Web Services Systems Manager OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html) in the *Amazon Web Services Systems Manager User Guide*.
 */
public suspend inline fun SsmClient.updateOpsItem(crossinline block: UpdateOpsItemRequest.Builder.() -> Unit): UpdateOpsItemResponse = updateOpsItem(UpdateOpsItemRequest.Builder().apply(block).build())

/**
 * Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager.
 */
public suspend inline fun SsmClient.updateOpsMetadata(crossinline block: UpdateOpsMetadataRequest.Builder.() -> Unit): UpdateOpsMetadataResponse = updateOpsMetadata(UpdateOpsMetadataRequest.Builder().apply(block).build())

/**
 * Modifies an existing patch baseline. Fields not specified in the request are left unchanged.
 *
 * For information about valid key-value pairs in `PatchFilters` for each supported operating system type, see PatchFilter.
 */
public suspend inline fun SsmClient.updatePatchBaseline(crossinline block: UpdatePatchBaselineRequest.Builder.() -> Unit): UpdatePatchBaselineResponse = updatePatchBaseline(UpdatePatchBaselineRequest.Builder().apply(block).build())

/**
 * Update a resource data sync. After you create a resource data sync for a Region, you can't change the account options for that sync. For example, if you create a sync in the us-east-2 (Ohio) Region and you choose the `Include only the current account` option, you can't edit that sync later and choose the `Include all accounts from my Organizations configuration` option. Instead, you must delete the first resource data sync, and create a new one.
 *
 * This API operation only supports a resource data sync that was created with a SyncFromSource `SyncType`.
 */
public suspend inline fun SsmClient.updateResourceDataSync(crossinline block: UpdateResourceDataSyncRequest.Builder.() -> Unit): UpdateResourceDataSyncResponse = updateResourceDataSync(UpdateResourceDataSyncRequest.Builder().apply(block).build())

/**
 * `ServiceSetting` is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.
 *
 * Services map a `SettingId` object to a setting value. Amazon Web Services services teams define the default value for a `SettingId`. You can't create a new `SettingId`, but you can overwrite the default value if you have the `ssm:UpdateServiceSetting` permission for the setting. Use the GetServiceSetting API operation to view the current value. Or, use the ResetServiceSetting to change the value back to the original value defined by the Amazon Web Services service team.
 *
 * Update the service setting for the account.
 */
public suspend inline fun SsmClient.updateServiceSetting(crossinline block: UpdateServiceSettingRequest.Builder.() -> Unit): UpdateServiceSettingResponse = updateServiceSetting(UpdateServiceSettingRequest.Builder().apply(block).build())
