// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class ModifyDocumentPermissionOperationDeserializer: HttpDeserializer.NonStreaming<ModifyDocumentPermissionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifyDocumentPermissionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyDocumentPermissionError(context, call, payload)
        }
        val builder = ModifyDocumentPermissionResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifyDocumentPermissionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DocumentLimitExceeded" -> DocumentLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "DocumentPermissionLimit" -> DocumentPermissionLimitDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocument" -> InvalidDocumentDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPermissionType" -> InvalidPermissionTypeDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
