// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig
import aws.sdk.kotlin.services.ssm.model.CommandInvocationStatus
import aws.sdk.kotlin.services.ssm.model.GetCommandInvocationResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCommandInvocationOperationDeserializer: HttpDeserializer.NonStreaming<GetCommandInvocationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetCommandInvocationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetCommandInvocationError(context, call, payload)
        }
        val builder = GetCommandInvocationResponse.Builder()

        if (payload != null) {
            deserializeGetCommandInvocationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetCommandInvocationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCommandId" -> InvalidCommandIdDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPluginName" -> InvalidPluginNameDeserializer().deserialize(context, wrappedCall, payload)
        "InvocationDoesNotExist" -> InvocationDoesNotExistDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCommandInvocationOperationBody(builder: GetCommandInvocationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLOUDWATCHOUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CloudWatchOutputConfig"))
    val COMMANDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CommandId"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Comment"))
    val DOCUMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentName"))
    val DOCUMENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentVersion"))
    val EXECUTIONELAPSEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionElapsedTime"))
    val EXECUTIONENDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionEndDateTime"))
    val EXECUTIONSTARTDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionStartDateTime"))
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceId"))
    val PLUGINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PluginName"))
    val RESPONSECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ResponseCode"))
    val STANDARDERRORCONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StandardErrorContent"))
    val STANDARDERRORURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StandardErrorUrl"))
    val STANDARDOUTPUTCONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StandardOutputContent"))
    val STANDARDOUTPUTURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StandardOutputUrl"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLOUDWATCHOUTPUTCONFIG_DESCRIPTOR)
        field(COMMANDID_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(DOCUMENTNAME_DESCRIPTOR)
        field(DOCUMENTVERSION_DESCRIPTOR)
        field(EXECUTIONELAPSEDTIME_DESCRIPTOR)
        field(EXECUTIONENDDATETIME_DESCRIPTOR)
        field(EXECUTIONSTARTDATETIME_DESCRIPTOR)
        field(INSTANCEID_DESCRIPTOR)
        field(PLUGINNAME_DESCRIPTOR)
        field(RESPONSECODE_DESCRIPTOR)
        field(STANDARDERRORCONTENT_DESCRIPTOR)
        field(STANDARDERRORURL_DESCRIPTOR)
        field(STANDARDOUTPUTCONTENT_DESCRIPTOR)
        field(STANDARDOUTPUTURL_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLOUDWATCHOUTPUTCONFIG_DESCRIPTOR.index -> builder.cloudWatchOutputConfig = deserializeCloudWatchOutputConfigDocument(deserializer)
                COMMANDID_DESCRIPTOR.index -> builder.commandId = deserializeString()
                COMMENT_DESCRIPTOR.index -> builder.comment = deserializeString()
                DOCUMENTNAME_DESCRIPTOR.index -> builder.documentName = deserializeString()
                DOCUMENTVERSION_DESCRIPTOR.index -> builder.documentVersion = deserializeString()
                EXECUTIONELAPSEDTIME_DESCRIPTOR.index -> builder.executionElapsedTime = deserializeString()
                EXECUTIONENDDATETIME_DESCRIPTOR.index -> builder.executionEndDateTime = deserializeString()
                EXECUTIONSTARTDATETIME_DESCRIPTOR.index -> builder.executionStartDateTime = deserializeString()
                INSTANCEID_DESCRIPTOR.index -> builder.instanceId = deserializeString()
                PLUGINNAME_DESCRIPTOR.index -> builder.pluginName = deserializeString()
                RESPONSECODE_DESCRIPTOR.index -> builder.responseCode = deserializeInt()
                STANDARDERRORCONTENT_DESCRIPTOR.index -> builder.standardErrorContent = deserializeString()
                STANDARDERRORURL_DESCRIPTOR.index -> builder.standardErrorUrl = deserializeString()
                STANDARDOUTPUTCONTENT_DESCRIPTOR.index -> builder.standardOutputContent = deserializeString()
                STANDARDOUTPUTURL_DESCRIPTOR.index -> builder.standardOutputUrl = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { CommandInvocationStatus.fromValue(it) }
                STATUSDETAILS_DESCRIPTOR.index -> builder.statusDetails = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
