// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a filter for a specific list of managed nodes.
 */
public class InstanceInformation private constructor(builder: Builder) {
    /**
     * The activation ID created by Amazon Web Services Systems Manager when the server or virtual machine (VM) was registered.
     */
    public val activationId: kotlin.String? = builder.activationId
    /**
     * The version of SSM Agent running on your Linux managed node.
     */
    public val agentVersion: kotlin.String? = builder.agentVersion
    /**
     * Information about the association.
     */
    public val associationOverview: aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview? = builder.associationOverview
    /**
     * The status of the association.
     */
    public val associationStatus: kotlin.String? = builder.associationStatus
    /**
     * The fully qualified host name of the managed node.
     */
    public val computerName: kotlin.String? = builder.computerName
    /**
     * The role assigned to an Amazon EC2 instance configured with a Systems Manager Quick Setup host management configuration or the role assigned to an on-premises managed node.
     *
     *  This call doesn't return the IAM role for *unmanaged* Amazon EC2 instances (instances not configured for Systems Manager). To retrieve the role for an unmanaged instance, use the Amazon EC2 `DescribeInstances` operation. For information, see [DescribeInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html) in the *Amazon EC2 API Reference* or [describe-instances](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-instances.html) in the *Amazon Web Services CLI Command Reference*.
     */
    public val iamRole: kotlin.String? = builder.iamRole
    /**
     * The managed node ID.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The IP address of the managed node.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Indicates whether the latest version of SSM Agent is running on your Linux managed node. This field doesn't indicate whether or not the latest version is installed on Windows managed nodes, because some older versions of Windows Server use the EC2Config service to process Systems Manager requests.
     */
    public val isLatestVersion: kotlin.Boolean? = builder.isLatestVersion
    /**
     * The date the association was last run.
     */
    public val lastAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAssociationExecutionDate
    /**
     * The date and time when the agent last pinged the Systems Manager service.
     */
    public val lastPingDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastPingDateTime
    /**
     * The last date the association was successfully run.
     */
    public val lastSuccessfulAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulAssociationExecutionDate
    /**
     * The name assigned to an on-premises server, edge device, or virtual machine (VM) when it is activated as a Systems Manager managed node. The name is specified as the `DefaultInstanceName` property using the CreateActivation command. It is applied to the managed node by specifying the Activation Code and Activation ID when you install SSM Agent on the node, as explained in [How to install SSM Agent on hybrid Linux nodes](https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-ssm-agent-install-linux.html) and [How to install SSM Agent on hybrid Windows Server nodes](https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-ssm-agent-install-windows.html). To retrieve the `Name` tag of an EC2 instance, use the Amazon EC2 `DescribeInstances` operation. For information, see [DescribeInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html) in the *Amazon EC2 API Reference* or [describe-instances](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-instances.html) in the *Amazon Web Services CLI Command Reference*.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Connection status of SSM Agent.
     *
     * The status `Inactive` has been deprecated and is no longer in use.
     */
    public val pingStatus: aws.sdk.kotlin.services.ssm.model.PingStatus? = builder.pingStatus
    /**
     * The name of the operating system platform running on your managed node.
     */
    public val platformName: kotlin.String? = builder.platformName
    /**
     * The operating system platform type.
     */
    public val platformType: aws.sdk.kotlin.services.ssm.model.PlatformType? = builder.platformType
    /**
     * The version of the OS platform running on your managed node.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * The date the server or VM was registered with Amazon Web Services as a managed node.
     */
    public val registrationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.registrationDate
    /**
     * The type of instance. Instances are either EC2 instances or managed instances.
     */
    public val resourceType: aws.sdk.kotlin.services.ssm.model.ResourceType? = builder.resourceType
    /**
     * The ID of the source resource. For IoT Greengrass devices, `SourceId` is the Thing name.
     */
    public val sourceId: kotlin.String? = builder.sourceId
    /**
     * The type of the source resource. For IoT Greengrass devices, `SourceType` is `AWS::IoT::Thing`.
     */
    public val sourceType: aws.sdk.kotlin.services.ssm.model.SourceType? = builder.sourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InstanceInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceInformation(")
        append("activationId=$activationId,")
        append("agentVersion=$agentVersion,")
        append("associationOverview=$associationOverview,")
        append("associationStatus=$associationStatus,")
        append("computerName=$computerName,")
        append("iamRole=$iamRole,")
        append("instanceId=$instanceId,")
        append("ipAddress=*** Sensitive Data Redacted ***,")
        append("isLatestVersion=$isLatestVersion,")
        append("lastAssociationExecutionDate=$lastAssociationExecutionDate,")
        append("lastPingDateTime=$lastPingDateTime,")
        append("lastSuccessfulAssociationExecutionDate=$lastSuccessfulAssociationExecutionDate,")
        append("name=$name,")
        append("pingStatus=$pingStatus,")
        append("platformName=$platformName,")
        append("platformType=$platformType,")
        append("platformVersion=$platformVersion,")
        append("registrationDate=$registrationDate,")
        append("resourceType=$resourceType,")
        append("sourceId=$sourceId,")
        append("sourceType=$sourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationId?.hashCode() ?: 0
        result = 31 * result + (agentVersion?.hashCode() ?: 0)
        result = 31 * result + (associationOverview?.hashCode() ?: 0)
        result = 31 * result + (associationStatus?.hashCode() ?: 0)
        result = 31 * result + (computerName?.hashCode() ?: 0)
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (isLatestVersion?.hashCode() ?: 0)
        result = 31 * result + (lastAssociationExecutionDate?.hashCode() ?: 0)
        result = 31 * result + (lastPingDateTime?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulAssociationExecutionDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pingStatus?.hashCode() ?: 0)
        result = 31 * result + (platformName?.hashCode() ?: 0)
        result = 31 * result + (platformType?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (registrationDate?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceId?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceInformation

        if (activationId != other.activationId) return false
        if (agentVersion != other.agentVersion) return false
        if (associationOverview != other.associationOverview) return false
        if (associationStatus != other.associationStatus) return false
        if (computerName != other.computerName) return false
        if (iamRole != other.iamRole) return false
        if (instanceId != other.instanceId) return false
        if (ipAddress != other.ipAddress) return false
        if (isLatestVersion != other.isLatestVersion) return false
        if (lastAssociationExecutionDate != other.lastAssociationExecutionDate) return false
        if (lastPingDateTime != other.lastPingDateTime) return false
        if (lastSuccessfulAssociationExecutionDate != other.lastSuccessfulAssociationExecutionDate) return false
        if (name != other.name) return false
        if (pingStatus != other.pingStatus) return false
        if (platformName != other.platformName) return false
        if (platformType != other.platformType) return false
        if (platformVersion != other.platformVersion) return false
        if (registrationDate != other.registrationDate) return false
        if (resourceType != other.resourceType) return false
        if (sourceId != other.sourceId) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InstanceInformation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The activation ID created by Amazon Web Services Systems Manager when the server or virtual machine (VM) was registered.
         */
        public var activationId: kotlin.String? = null
        /**
         * The version of SSM Agent running on your Linux managed node.
         */
        public var agentVersion: kotlin.String? = null
        /**
         * Information about the association.
         */
        public var associationOverview: aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview? = null
        /**
         * The status of the association.
         */
        public var associationStatus: kotlin.String? = null
        /**
         * The fully qualified host name of the managed node.
         */
        public var computerName: kotlin.String? = null
        /**
         * The role assigned to an Amazon EC2 instance configured with a Systems Manager Quick Setup host management configuration or the role assigned to an on-premises managed node.
         *
         *  This call doesn't return the IAM role for *unmanaged* Amazon EC2 instances (instances not configured for Systems Manager). To retrieve the role for an unmanaged instance, use the Amazon EC2 `DescribeInstances` operation. For information, see [DescribeInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html) in the *Amazon EC2 API Reference* or [describe-instances](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-instances.html) in the *Amazon Web Services CLI Command Reference*.
         */
        public var iamRole: kotlin.String? = null
        /**
         * The managed node ID.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The IP address of the managed node.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * Indicates whether the latest version of SSM Agent is running on your Linux managed node. This field doesn't indicate whether or not the latest version is installed on Windows managed nodes, because some older versions of Windows Server use the EC2Config service to process Systems Manager requests.
         */
        public var isLatestVersion: kotlin.Boolean? = null
        /**
         * The date the association was last run.
         */
        public var lastAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time when the agent last pinged the Systems Manager service.
         */
        public var lastPingDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last date the association was successfully run.
         */
        public var lastSuccessfulAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name assigned to an on-premises server, edge device, or virtual machine (VM) when it is activated as a Systems Manager managed node. The name is specified as the `DefaultInstanceName` property using the CreateActivation command. It is applied to the managed node by specifying the Activation Code and Activation ID when you install SSM Agent on the node, as explained in [How to install SSM Agent on hybrid Linux nodes](https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-ssm-agent-install-linux.html) and [How to install SSM Agent on hybrid Windows Server nodes](https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-ssm-agent-install-windows.html). To retrieve the `Name` tag of an EC2 instance, use the Amazon EC2 `DescribeInstances` operation. For information, see [DescribeInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html) in the *Amazon EC2 API Reference* or [describe-instances](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-instances.html) in the *Amazon Web Services CLI Command Reference*.
         */
        public var name: kotlin.String? = null
        /**
         * Connection status of SSM Agent.
         *
         * The status `Inactive` has been deprecated and is no longer in use.
         */
        public var pingStatus: aws.sdk.kotlin.services.ssm.model.PingStatus? = null
        /**
         * The name of the operating system platform running on your managed node.
         */
        public var platformName: kotlin.String? = null
        /**
         * The operating system platform type.
         */
        public var platformType: aws.sdk.kotlin.services.ssm.model.PlatformType? = null
        /**
         * The version of the OS platform running on your managed node.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * The date the server or VM was registered with Amazon Web Services as a managed node.
         */
        public var registrationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of instance. Instances are either EC2 instances or managed instances.
         */
        public var resourceType: aws.sdk.kotlin.services.ssm.model.ResourceType? = null
        /**
         * The ID of the source resource. For IoT Greengrass devices, `SourceId` is the Thing name.
         */
        public var sourceId: kotlin.String? = null
        /**
         * The type of the source resource. For IoT Greengrass devices, `SourceType` is `AWS::IoT::Thing`.
         */
        public var sourceType: aws.sdk.kotlin.services.ssm.model.SourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InstanceInformation) : this() {
            this.activationId = x.activationId
            this.agentVersion = x.agentVersion
            this.associationOverview = x.associationOverview
            this.associationStatus = x.associationStatus
            this.computerName = x.computerName
            this.iamRole = x.iamRole
            this.instanceId = x.instanceId
            this.ipAddress = x.ipAddress
            this.isLatestVersion = x.isLatestVersion
            this.lastAssociationExecutionDate = x.lastAssociationExecutionDate
            this.lastPingDateTime = x.lastPingDateTime
            this.lastSuccessfulAssociationExecutionDate = x.lastSuccessfulAssociationExecutionDate
            this.name = x.name
            this.pingStatus = x.pingStatus
            this.platformName = x.platformName
            this.platformType = x.platformType
            this.platformVersion = x.platformVersion
            this.registrationDate = x.registrationDate
            this.resourceType = x.resourceType
            this.sourceId = x.sourceId
            this.sourceType = x.sourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InstanceInformation = InstanceInformation(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview] inside the given [block]
         */
        public fun associationOverview(block: aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview.Builder.() -> kotlin.Unit) {
            this.associationOverview = aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
