// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.Runbook
import aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionRequest
import aws.sdk.kotlin.services.ssm.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class StartChangeRequestExecutionOperationSerializer: HttpSerializer.NonStreaming<StartChangeRequestExecutionRequest> {
    override fun serialize(context: ExecutionContext, input: StartChangeRequestExecutionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeStartChangeRequestExecutionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeStartChangeRequestExecutionOperationBody(context: ExecutionContext, input: StartChangeRequestExecutionRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTOAPPROVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AutoApprove"))
    val CHANGEDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChangeDetails"))
    val CHANGEREQUESTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChangeRequestName"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val DOCUMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentName"))
    val DOCUMENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentVersion"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Parameters"))
    val PARAMETERS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val RUNBOOKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Runbooks"))
    val SCHEDULEDENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ScheduledEndTime"))
    val SCHEDULEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ScheduledTime"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOAPPROVE_DESCRIPTOR)
        field(CHANGEDETAILS_DESCRIPTOR)
        field(CHANGEREQUESTNAME_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DOCUMENTNAME_DESCRIPTOR)
        field(DOCUMENTVERSION_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(RUNBOOKS_DESCRIPTOR)
        field(SCHEDULEDENDTIME_DESCRIPTOR)
        field(SCHEDULEDTIME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.autoApprove?.let { field(AUTOAPPROVE_DESCRIPTOR, it) }
        input.changeDetails?.let { field(CHANGEDETAILS_DESCRIPTOR, it) }
        input.changeRequestName?.let { field(CHANGEREQUESTNAME_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) }
        input.documentName?.let { field(DOCUMENTNAME_DESCRIPTOR, it) }
        input.documentVersion?.let { field(DOCUMENTVERSION_DESCRIPTOR, it) }
        if (input.parameters != null) {
            mapField(PARAMETERS_DESCRIPTOR) {
                input.parameters.forEach { (key, value) ->
                    listEntry(key, PARAMETERS_C0_DESCRIPTOR) {
                        for (el1 in value) {
                            serializeString(el1)
                        }
                    }
                }
            }
        }
        if (input.runbooks != null) {
            listField(RUNBOOKS_DESCRIPTOR) {
                for (el0 in input.runbooks) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeRunbookDocument))
                }
            }
        }
        input.scheduledEndTime?.let { field(SCHEDULEDENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.scheduledTime?.let { field(SCHEDULEDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
