// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartChangeRequestExecutionOperationDeserializer: HttpDeserializer.NonStreaming<StartChangeRequestExecutionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartChangeRequestExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartChangeRequestExecutionError(context, call, payload)
        }
        val builder = StartChangeRequestExecutionResponse.Builder()

        if (payload != null) {
            deserializeStartChangeRequestExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartChangeRequestExecutionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AutomationDefinitionNotApprovedException" -> AutomationDefinitionNotApprovedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AutomationDefinitionNotFoundException" -> AutomationDefinitionNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AutomationDefinitionVersionNotFoundException" -> AutomationDefinitionVersionNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AutomationExecutionLimitExceededException" -> AutomationExecutionLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IdempotentParameterMismatch" -> IdempotentParameterMismatchDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidAutomationExecutionParametersException" -> InvalidAutomationExecutionParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartChangeRequestExecutionOperationBody(builder: StartChangeRequestExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOMATIONEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AutomationExecutionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOMATIONEXECUTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOMATIONEXECUTIONID_DESCRIPTOR.index -> builder.automationExecutionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
