// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.GetPatchBaselineResponse
import aws.sdk.kotlin.services.ssm.model.OperatingSystem
import aws.sdk.kotlin.services.ssm.model.PatchAction
import aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel
import aws.sdk.kotlin.services.ssm.model.PatchComplianceStatus
import aws.sdk.kotlin.services.ssm.model.PatchFilterGroup
import aws.sdk.kotlin.services.ssm.model.PatchRuleGroup
import aws.sdk.kotlin.services.ssm.model.PatchSource
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetPatchBaselineOperationDeserializer: HttpDeserializer.NonStreaming<GetPatchBaselineResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetPatchBaselineResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPatchBaselineError(context, call, payload)
        }
        val builder = GetPatchBaselineResponse.Builder()

        if (payload != null) {
            deserializeGetPatchBaselineOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetPatchBaselineError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DoesNotExistException" -> DoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidResourceId" -> InvalidResourceIdDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPatchBaselineOperationBody(builder: GetPatchBaselineResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPROVALRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ApprovalRules"))
    val APPROVEDPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ApprovedPatches"))
    val APPROVEDPATCHESCOMPLIANCELEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ApprovedPatchesComplianceLevel"))
    val APPROVEDPATCHESENABLENONSECURITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ApprovedPatchesEnableNonSecurity"))
    val AVAILABLESECURITYUPDATESCOMPLIANCESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AvailableSecurityUpdatesComplianceStatus"))
    val BASELINEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BaselineId"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val GLOBALFILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("GlobalFilters"))
    val MODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ModifiedDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OPERATINGSYSTEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OperatingSystem"))
    val PATCHGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PatchGroups"))
    val REJECTEDPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RejectedPatches"))
    val REJECTEDPATCHESACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("RejectedPatchesAction"))
    val SOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Sources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPROVALRULES_DESCRIPTOR)
        field(APPROVEDPATCHES_DESCRIPTOR)
        field(APPROVEDPATCHESCOMPLIANCELEVEL_DESCRIPTOR)
        field(APPROVEDPATCHESENABLENONSECURITY_DESCRIPTOR)
        field(AVAILABLESECURITYUPDATESCOMPLIANCESTATUS_DESCRIPTOR)
        field(BASELINEID_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(GLOBALFILTERS_DESCRIPTOR)
        field(MODIFIEDDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OPERATINGSYSTEM_DESCRIPTOR)
        field(PATCHGROUPS_DESCRIPTOR)
        field(REJECTEDPATCHES_DESCRIPTOR)
        field(REJECTEDPATCHESACTION_DESCRIPTOR)
        field(SOURCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPROVALRULES_DESCRIPTOR.index -> builder.approvalRules = deserializePatchRuleGroupDocument(deserializer)
                APPROVEDPATCHES_DESCRIPTOR.index -> builder.approvedPatches =
                    deserializer.deserializeList(APPROVEDPATCHES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                APPROVEDPATCHESCOMPLIANCELEVEL_DESCRIPTOR.index -> builder.approvedPatchesComplianceLevel = deserializeString().let { PatchComplianceLevel.fromValue(it) }
                APPROVEDPATCHESENABLENONSECURITY_DESCRIPTOR.index -> builder.approvedPatchesEnableNonSecurity = deserializeBoolean()
                AVAILABLESECURITYUPDATESCOMPLIANCESTATUS_DESCRIPTOR.index -> builder.availableSecurityUpdatesComplianceStatus = deserializeString().let { PatchComplianceStatus.fromValue(it) }
                BASELINEID_DESCRIPTOR.index -> builder.baselineId = deserializeString()
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                GLOBALFILTERS_DESCRIPTOR.index -> builder.globalFilters = deserializePatchFilterGroupDocument(deserializer)
                MODIFIEDDATE_DESCRIPTOR.index -> builder.modifiedDate = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OPERATINGSYSTEM_DESCRIPTOR.index -> builder.operatingSystem = deserializeString().let { OperatingSystem.fromValue(it) }
                PATCHGROUPS_DESCRIPTOR.index -> builder.patchGroups =
                    deserializer.deserializeList(PATCHGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REJECTEDPATCHES_DESCRIPTOR.index -> builder.rejectedPatches =
                    deserializer.deserializeList(REJECTEDPATCHES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REJECTEDPATCHESACTION_DESCRIPTOR.index -> builder.rejectedPatchesAction = deserializeString().let { PatchAction.fromValue(it) }
                SOURCES_DESCRIPTOR.index -> builder.sources =
                    deserializer.deserializeList(SOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<PatchSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePatchSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
