// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateMaintenanceWindowRequest private constructor(builder: Builder) {
    /**
     * Whether targets must be registered with the maintenance window before tasks can be defined for those targets.
     */
    public val allowUnassociatedTargets: kotlin.Boolean? = builder.allowUnassociatedTargets
    /**
     * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.
     */
    public val cutoff: kotlin.Int? = builder.cutoff
    /**
     * An optional description for the update request.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The duration of the maintenance window in hours.
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * Whether the maintenance window is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. `EndDate` allows you to set a date and time in the future when the maintenance window will no longer run.
     */
    public val endDate: kotlin.String? = builder.endDate
    /**
     * The name of the maintenance window.
     */
    public val name: kotlin.String? = builder.name
    /**
     * If `True`, then all fields that are required by the CreateMaintenanceWindow operation are also required for this API request. Optional fields that aren't specified are set to null.
     */
    public val replace: kotlin.Boolean? = builder.replace
    /**
     * The schedule of the maintenance window in the form of a cron or rate expression.
     */
    public val schedule: kotlin.String? = builder.schedule
    /**
     * The number of days to wait after the date and time specified by a cron expression before running the maintenance window.
     *
     * For example, the following cron expression schedules a maintenance window to run the third Tuesday of every month at 11:30 PM.
     *
     * `cron(30 23 ? * TUE#3 *)`
     *
     * If the schedule offset is `2`, the maintenance window won't run until two days later.
     */
    public val scheduleOffset: kotlin.Int? = builder.scheduleOffset
    /**
     * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the [Time Zone Database](https://www.iana.org/time-zones) on the IANA website.
     */
    public val scheduleTimezone: kotlin.String? = builder.scheduleTimezone
    /**
     * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active. `StartDate` allows you to delay activation of the maintenance window until the specified future date.
     *
     * When using a rate schedule, if you provide a start date that occurs in the past, the current date and time are used as the start date.
     */
    public val startDate: kotlin.String? = builder.startDate
    /**
     * The ID of the maintenance window to update.
     */
    public val windowId: kotlin.String? = builder.windowId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMaintenanceWindowRequest(")
        append("allowUnassociatedTargets=$allowUnassociatedTargets,")
        append("cutoff=$cutoff,")
        append("description=*** Sensitive Data Redacted ***,")
        append("duration=$duration,")
        append("enabled=$enabled,")
        append("endDate=$endDate,")
        append("name=$name,")
        append("replace=$replace,")
        append("schedule=$schedule,")
        append("scheduleOffset=$scheduleOffset,")
        append("scheduleTimezone=$scheduleTimezone,")
        append("startDate=$startDate,")
        append("windowId=$windowId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowUnassociatedTargets?.hashCode() ?: 0
        result = 31 * result + (cutoff ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (replace?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (scheduleOffset ?: 0)
        result = 31 * result + (scheduleTimezone?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (windowId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMaintenanceWindowRequest

        if (allowUnassociatedTargets != other.allowUnassociatedTargets) return false
        if (cutoff != other.cutoff) return false
        if (description != other.description) return false
        if (duration != other.duration) return false
        if (enabled != other.enabled) return false
        if (endDate != other.endDate) return false
        if (name != other.name) return false
        if (replace != other.replace) return false
        if (schedule != other.schedule) return false
        if (scheduleOffset != other.scheduleOffset) return false
        if (scheduleTimezone != other.scheduleTimezone) return false
        if (startDate != other.startDate) return false
        if (windowId != other.windowId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether targets must be registered with the maintenance window before tasks can be defined for those targets.
         */
        public var allowUnassociatedTargets: kotlin.Boolean? = null
        /**
         * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.
         */
        public var cutoff: kotlin.Int? = null
        /**
         * An optional description for the update request.
         */
        public var description: kotlin.String? = null
        /**
         * The duration of the maintenance window in hours.
         */
        public var duration: kotlin.Int? = null
        /**
         * Whether the maintenance window is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. `EndDate` allows you to set a date and time in the future when the maintenance window will no longer run.
         */
        public var endDate: kotlin.String? = null
        /**
         * The name of the maintenance window.
         */
        public var name: kotlin.String? = null
        /**
         * If `True`, then all fields that are required by the CreateMaintenanceWindow operation are also required for this API request. Optional fields that aren't specified are set to null.
         */
        public var replace: kotlin.Boolean? = null
        /**
         * The schedule of the maintenance window in the form of a cron or rate expression.
         */
        public var schedule: kotlin.String? = null
        /**
         * The number of days to wait after the date and time specified by a cron expression before running the maintenance window.
         *
         * For example, the following cron expression schedules a maintenance window to run the third Tuesday of every month at 11:30 PM.
         *
         * `cron(30 23 ? * TUE#3 *)`
         *
         * If the schedule offset is `2`, the maintenance window won't run until two days later.
         */
        public var scheduleOffset: kotlin.Int? = null
        /**
         * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the [Time Zone Database](https://www.iana.org/time-zones) on the IANA website.
         */
        public var scheduleTimezone: kotlin.String? = null
        /**
         * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active. `StartDate` allows you to delay activation of the maintenance window until the specified future date.
         *
         * When using a rate schedule, if you provide a start date that occurs in the past, the current date and time are used as the start date.
         */
        public var startDate: kotlin.String? = null
        /**
         * The ID of the maintenance window to update.
         */
        public var windowId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowRequest) : this() {
            this.allowUnassociatedTargets = x.allowUnassociatedTargets
            this.cutoff = x.cutoff
            this.description = x.description
            this.duration = x.duration
            this.enabled = x.enabled
            this.endDate = x.endDate
            this.name = x.name
            this.replace = x.replace
            this.schedule = x.schedule
            this.scheduleOffset = x.scheduleOffset
            this.scheduleTimezone = x.scheduleTimezone
            this.startDate = x.startDate
            this.windowId = x.windowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowRequest = UpdateMaintenanceWindowRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
