// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object containing various properties of a managed node.
 */
public class InstanceProperty private constructor(builder: Builder) {
    /**
     * The activation ID created by Systems Manager when the server or virtual machine (VM) was registered
     */
    public val activationId: kotlin.String? = builder.activationId
    /**
     * The version of SSM Agent running on your managed node.
     */
    public val agentVersion: kotlin.String? = builder.agentVersion
    /**
     * The CPU architecture of the node. For example, `x86_64`.
     */
    public val architecture: kotlin.String? = builder.architecture
    /**
     * Status information about the aggregated associations.
     */
    public val associationOverview: aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview? = builder.associationOverview
    /**
     * The status of the State Manager association applied to the managed node.
     */
    public val associationStatus: kotlin.String? = builder.associationStatus
    /**
     * The fully qualified host name of the managed node.
     */
    public val computerName: kotlin.String? = builder.computerName
    /**
     * The IAM role used in the hybrid activation to register the node with Systems Manager.
     */
    public val iamRole: kotlin.String? = builder.iamRole
    /**
     * The ID of the managed node.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The instance profile attached to the node. If an instance profile isn't attached to the node, this value is blank.
     */
    public val instanceRole: kotlin.String? = builder.instanceRole
    /**
     * The current state of the node.
     */
    public val instanceState: kotlin.String? = builder.instanceState
    /**
     * The instance type of the managed node. For example, t3.large.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The public IPv4 address assigned to the node. If a public IPv4 address isn't assigned to the node, this value is blank.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * The name of the key pair associated with the node. If a key pair isnt't associated with the node, this value is blank.
     */
    public val keyName: kotlin.String? = builder.keyName
    /**
     * The date the association was last run.
     */
    public val lastAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAssociationExecutionDate
    /**
     * The date and time when the SSM Agent last pinged the Systems Manager service.
     */
    public val lastPingDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastPingDateTime
    /**
     * The last date the association was successfully run.
     */
    public val lastSuccessfulAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulAssociationExecutionDate
    /**
     * The timestamp for when the node was launched.
     */
    public val launchTime: aws.smithy.kotlin.runtime.time.Instant? = builder.launchTime
    /**
     * The value of the EC2 `Name` tag associated with the node. If a `Name` tag hasn't been applied to the node, this value is blank.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Connection status of the SSM Agent on the managed node.
     */
    public val pingStatus: aws.sdk.kotlin.services.ssm.model.PingStatus? = builder.pingStatus
    /**
     * The name of the operating system platform running on your managed node.
     */
    public val platformName: kotlin.String? = builder.platformName
    /**
     * The operating system platform type of the managed node. For example, Windows Server or Amazon Linux 2.
     */
    public val platformType: aws.sdk.kotlin.services.ssm.model.PlatformType? = builder.platformType
    /**
     * The version of the OS platform running on your managed node.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * The date the node was registered with Systems Manager.
     */
    public val registrationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.registrationDate
    /**
     * The type of managed node.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The ID of the source resource.
     */
    public val sourceId: kotlin.String? = builder.sourceId
    /**
     * The type of the source resource.
     */
    public val sourceType: aws.sdk.kotlin.services.ssm.model.SourceType? = builder.sourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InstanceProperty = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceProperty(")
        append("activationId=$activationId,")
        append("agentVersion=$agentVersion,")
        append("architecture=$architecture,")
        append("associationOverview=$associationOverview,")
        append("associationStatus=$associationStatus,")
        append("computerName=$computerName,")
        append("iamRole=$iamRole,")
        append("instanceId=$instanceId,")
        append("instanceRole=$instanceRole,")
        append("instanceState=$instanceState,")
        append("instanceType=$instanceType,")
        append("ipAddress=*** Sensitive Data Redacted ***,")
        append("keyName=$keyName,")
        append("lastAssociationExecutionDate=$lastAssociationExecutionDate,")
        append("lastPingDateTime=$lastPingDateTime,")
        append("lastSuccessfulAssociationExecutionDate=$lastSuccessfulAssociationExecutionDate,")
        append("launchTime=$launchTime,")
        append("name=$name,")
        append("pingStatus=$pingStatus,")
        append("platformName=$platformName,")
        append("platformType=$platformType,")
        append("platformVersion=$platformVersion,")
        append("registrationDate=$registrationDate,")
        append("resourceType=$resourceType,")
        append("sourceId=$sourceId,")
        append("sourceType=$sourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationId?.hashCode() ?: 0
        result = 31 * result + (agentVersion?.hashCode() ?: 0)
        result = 31 * result + (architecture?.hashCode() ?: 0)
        result = 31 * result + (associationOverview?.hashCode() ?: 0)
        result = 31 * result + (associationStatus?.hashCode() ?: 0)
        result = 31 * result + (computerName?.hashCode() ?: 0)
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceRole?.hashCode() ?: 0)
        result = 31 * result + (instanceState?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (lastAssociationExecutionDate?.hashCode() ?: 0)
        result = 31 * result + (lastPingDateTime?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulAssociationExecutionDate?.hashCode() ?: 0)
        result = 31 * result + (launchTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pingStatus?.hashCode() ?: 0)
        result = 31 * result + (platformName?.hashCode() ?: 0)
        result = 31 * result + (platformType?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (registrationDate?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceId?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceProperty

        if (activationId != other.activationId) return false
        if (agentVersion != other.agentVersion) return false
        if (architecture != other.architecture) return false
        if (associationOverview != other.associationOverview) return false
        if (associationStatus != other.associationStatus) return false
        if (computerName != other.computerName) return false
        if (iamRole != other.iamRole) return false
        if (instanceId != other.instanceId) return false
        if (instanceRole != other.instanceRole) return false
        if (instanceState != other.instanceState) return false
        if (instanceType != other.instanceType) return false
        if (ipAddress != other.ipAddress) return false
        if (keyName != other.keyName) return false
        if (lastAssociationExecutionDate != other.lastAssociationExecutionDate) return false
        if (lastPingDateTime != other.lastPingDateTime) return false
        if (lastSuccessfulAssociationExecutionDate != other.lastSuccessfulAssociationExecutionDate) return false
        if (launchTime != other.launchTime) return false
        if (name != other.name) return false
        if (pingStatus != other.pingStatus) return false
        if (platformName != other.platformName) return false
        if (platformType != other.platformType) return false
        if (platformVersion != other.platformVersion) return false
        if (registrationDate != other.registrationDate) return false
        if (resourceType != other.resourceType) return false
        if (sourceId != other.sourceId) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InstanceProperty = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The activation ID created by Systems Manager when the server or virtual machine (VM) was registered
         */
        public var activationId: kotlin.String? = null
        /**
         * The version of SSM Agent running on your managed node.
         */
        public var agentVersion: kotlin.String? = null
        /**
         * The CPU architecture of the node. For example, `x86_64`.
         */
        public var architecture: kotlin.String? = null
        /**
         * Status information about the aggregated associations.
         */
        public var associationOverview: aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview? = null
        /**
         * The status of the State Manager association applied to the managed node.
         */
        public var associationStatus: kotlin.String? = null
        /**
         * The fully qualified host name of the managed node.
         */
        public var computerName: kotlin.String? = null
        /**
         * The IAM role used in the hybrid activation to register the node with Systems Manager.
         */
        public var iamRole: kotlin.String? = null
        /**
         * The ID of the managed node.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The instance profile attached to the node. If an instance profile isn't attached to the node, this value is blank.
         */
        public var instanceRole: kotlin.String? = null
        /**
         * The current state of the node.
         */
        public var instanceState: kotlin.String? = null
        /**
         * The instance type of the managed node. For example, t3.large.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The public IPv4 address assigned to the node. If a public IPv4 address isn't assigned to the node, this value is blank.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * The name of the key pair associated with the node. If a key pair isnt't associated with the node, this value is blank.
         */
        public var keyName: kotlin.String? = null
        /**
         * The date the association was last run.
         */
        public var lastAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time when the SSM Agent last pinged the Systems Manager service.
         */
        public var lastPingDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last date the association was successfully run.
         */
        public var lastSuccessfulAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp for when the node was launched.
         */
        public var launchTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The value of the EC2 `Name` tag associated with the node. If a `Name` tag hasn't been applied to the node, this value is blank.
         */
        public var name: kotlin.String? = null
        /**
         * Connection status of the SSM Agent on the managed node.
         */
        public var pingStatus: aws.sdk.kotlin.services.ssm.model.PingStatus? = null
        /**
         * The name of the operating system platform running on your managed node.
         */
        public var platformName: kotlin.String? = null
        /**
         * The operating system platform type of the managed node. For example, Windows Server or Amazon Linux 2.
         */
        public var platformType: aws.sdk.kotlin.services.ssm.model.PlatformType? = null
        /**
         * The version of the OS platform running on your managed node.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * The date the node was registered with Systems Manager.
         */
        public var registrationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of managed node.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The ID of the source resource.
         */
        public var sourceId: kotlin.String? = null
        /**
         * The type of the source resource.
         */
        public var sourceType: aws.sdk.kotlin.services.ssm.model.SourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InstanceProperty) : this() {
            this.activationId = x.activationId
            this.agentVersion = x.agentVersion
            this.architecture = x.architecture
            this.associationOverview = x.associationOverview
            this.associationStatus = x.associationStatus
            this.computerName = x.computerName
            this.iamRole = x.iamRole
            this.instanceId = x.instanceId
            this.instanceRole = x.instanceRole
            this.instanceState = x.instanceState
            this.instanceType = x.instanceType
            this.ipAddress = x.ipAddress
            this.keyName = x.keyName
            this.lastAssociationExecutionDate = x.lastAssociationExecutionDate
            this.lastPingDateTime = x.lastPingDateTime
            this.lastSuccessfulAssociationExecutionDate = x.lastSuccessfulAssociationExecutionDate
            this.launchTime = x.launchTime
            this.name = x.name
            this.pingStatus = x.pingStatus
            this.platformName = x.platformName
            this.platformType = x.platformType
            this.platformVersion = x.platformVersion
            this.registrationDate = x.registrationDate
            this.resourceType = x.resourceType
            this.sourceId = x.sourceId
            this.sourceType = x.sourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InstanceProperty = InstanceProperty(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview] inside the given [block]
         */
        public fun associationOverview(block: aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview.Builder.() -> kotlin.Unit) {
            this.associationOverview = aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
