// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An SSM document required by the current document.
 */
public class DocumentRequires private constructor(builder: Builder) {
    /**
     * The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The document type of the required SSM document.
     */
    public val requireType: kotlin.String? = builder.requireType
    /**
     * The document version required by the current document.
     */
    public val version: kotlin.String? = builder.version
    /**
     * An optional field specifying the version of the artifact associated with the document. For example, 12.6. This value is unique across all versions of a document, and can't be changed.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.DocumentRequires = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentRequires(")
        append("name=$name,")
        append("requireType=$requireType,")
        append("version=$version,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (requireType?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentRequires

        if (name != other.name) return false
        if (requireType != other.requireType) return false
        if (version != other.version) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.DocumentRequires = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
         */
        public var name: kotlin.String? = null
        /**
         * The document type of the required SSM document.
         */
        public var requireType: kotlin.String? = null
        /**
         * The document version required by the current document.
         */
        public var version: kotlin.String? = null
        /**
         * An optional field specifying the version of the artifact associated with the document. For example, 12.6. This value is unique across all versions of a document, and can't be changed.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.DocumentRequires) : this() {
            this.name = x.name
            this.requireType = x.requireType
            this.version = x.version
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.DocumentRequires = DocumentRequires(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
