// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.sdk.kotlin.services.ssm.model.UnlabelParameterVersionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UnlabelParameterVersionOperationDeserializer: HttpDeserializer.NonStreaming<UnlabelParameterVersionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UnlabelParameterVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUnlabelParameterVersionError(context, call, payload)
        }
        val builder = UnlabelParameterVersionResponse.Builder()

        if (payload != null) {
            deserializeUnlabelParameterVersionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUnlabelParameterVersionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "ParameterNotFound" -> ParameterNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "ParameterVersionNotFound" -> ParameterVersionNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyUpdates" -> TooManyUpdatesDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUnlabelParameterVersionOperationBody(builder: UnlabelParameterVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INVALIDLABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InvalidLabels"))
    val REMOVEDLABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RemovedLabels"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INVALIDLABELS_DESCRIPTOR)
        field(REMOVEDLABELS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INVALIDLABELS_DESCRIPTOR.index -> builder.invalidLabels =
                    deserializer.deserializeList(INVALIDLABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REMOVEDLABELS_DESCRIPTOR.index -> builder.removedLabels =
                    deserializer.deserializeList(REMOVEDLABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
