// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.CreateDocumentResponse
import aws.sdk.kotlin.services.ssm.model.DocumentDescription
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDocumentOperationDeserializer: HttpDeserializer.NonStreaming<CreateDocumentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDocumentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDocumentError(context, call, payload)
        }
        val builder = CreateDocumentResponse.Builder()

        if (payload != null) {
            deserializeCreateDocumentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDocumentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DocumentAlreadyExists" -> DocumentAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        "DocumentLimitExceeded" -> DocumentLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocumentContent" -> InvalidDocumentContentDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocumentSchemaVersion" -> InvalidDocumentSchemaVersionDeserializer().deserialize(context, wrappedCall, payload)
        "MaxDocumentSizeExceeded" -> MaxDocumentSizeExceededDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyUpdates" -> TooManyUpdatesDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDocumentOperationBody(builder: CreateDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOCUMENTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DocumentDescription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOCUMENTDESCRIPTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOCUMENTDESCRIPTION_DESCRIPTOR.index -> builder.documentDescription = deserializeDocumentDescriptionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
