// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Metadata includes information like the Amazon Resource Name (ARN) of the last user to update the parameter and the date and time the parameter was last used.
 */
public class ParameterMetadata private constructor(builder: Builder) {
    /**
     * A parameter name can include only the following letters and symbols.
     *
     * a-zA-Z0-9_.-
     */
    public val allowedPattern: kotlin.String? = builder.allowedPattern
    /**
     * The Amazon Resource Name (ARN) of the parameter.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The data type of the parameter, such as `text` or `aws:ec2:image`. The default is `text`.
     */
    public val dataType: kotlin.String? = builder.dataType
    /**
     * Description of the parameter actions.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The alias of the Key Management Service (KMS) key used to encrypt the parameter. Applies to `SecureString` parameters only.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Date the parameter was last changed or updated.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.
     */
    public val lastModifiedUser: kotlin.String? = builder.lastModifiedUser
    /**
     * The parameter name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of policies associated with a parameter.
     */
    public val policies: List<ParameterInlinePolicy>? = builder.policies
    /**
     * The parameter tier.
     */
    public val tier: aws.sdk.kotlin.services.ssm.model.ParameterTier? = builder.tier
    /**
     * The type of parameter. Valid parameter types include the following: `String`, `StringList`, and `SecureString`.
     */
    public val type: aws.sdk.kotlin.services.ssm.model.ParameterType? = builder.type
    /**
     * The parameter version.
     */
    public val version: kotlin.Long = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ParameterMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParameterMetadata(")
        append("allowedPattern=$allowedPattern,")
        append("arn=$arn,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("keyId=$keyId,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("lastModifiedUser=$lastModifiedUser,")
        append("name=$name,")
        append("policies=$policies,")
        append("tier=$tier,")
        append("type=$type,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedPattern?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedUser?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policies?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParameterMetadata

        if (allowedPattern != other.allowedPattern) return false
        if (arn != other.arn) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (keyId != other.keyId) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (lastModifiedUser != other.lastModifiedUser) return false
        if (name != other.name) return false
        if (policies != other.policies) return false
        if (tier != other.tier) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ParameterMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A parameter name can include only the following letters and symbols.
         *
         * a-zA-Z0-9_.-
         */
        public var allowedPattern: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the parameter.
         */
        public var arn: kotlin.String? = null
        /**
         * The data type of the parameter, such as `text` or `aws:ec2:image`. The default is `text`.
         */
        public var dataType: kotlin.String? = null
        /**
         * Description of the parameter actions.
         */
        public var description: kotlin.String? = null
        /**
         * The alias of the Key Management Service (KMS) key used to encrypt the parameter. Applies to `SecureString` parameters only.
         */
        public var keyId: kotlin.String? = null
        /**
         * Date the parameter was last changed or updated.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.
         */
        public var lastModifiedUser: kotlin.String? = null
        /**
         * The parameter name.
         */
        public var name: kotlin.String? = null
        /**
         * A list of policies associated with a parameter.
         */
        public var policies: List<ParameterInlinePolicy>? = null
        /**
         * The parameter tier.
         */
        public var tier: aws.sdk.kotlin.services.ssm.model.ParameterTier? = null
        /**
         * The type of parameter. Valid parameter types include the following: `String`, `StringList`, and `SecureString`.
         */
        public var type: aws.sdk.kotlin.services.ssm.model.ParameterType? = null
        /**
         * The parameter version.
         */
        public var version: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ParameterMetadata) : this() {
            this.allowedPattern = x.allowedPattern
            this.arn = x.arn
            this.dataType = x.dataType
            this.description = x.description
            this.keyId = x.keyId
            this.lastModifiedDate = x.lastModifiedDate
            this.lastModifiedUser = x.lastModifiedUser
            this.name = x.name
            this.policies = x.policies
            this.tier = x.tier
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ParameterMetadata = ParameterMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
