// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * One or more aggregators for viewing counts of nodes using different dimensions.
 */
public class NodeAggregator private constructor(builder: Builder) {
    /**
     * The aggregator type for limiting a node summary. Currently, only `Count` is supported.
     */
    public val aggregatorType: aws.sdk.kotlin.services.ssm.model.NodeAggregatorType = requireNotNull(builder.aggregatorType) { "A non-null value must be provided for aggregatorType" }
    /**
     * Information about aggregators used to refine a node summary.
     */
    public val aggregators: List<NodeAggregator>? = builder.aggregators
    /**
     * The name of a node attribute on which to limit the count of nodes.
     */
    public val attributeName: aws.sdk.kotlin.services.ssm.model.NodeAttributeName = requireNotNull(builder.attributeName) { "A non-null value must be provided for attributeName" }
    /**
     * The data type name to use for viewing counts of nodes. Currently, only `Instance` is supported.
     */
    public val typeName: aws.sdk.kotlin.services.ssm.model.NodeTypeName = requireNotNull(builder.typeName) { "A non-null value must be provided for typeName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.NodeAggregator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeAggregator(")
        append("aggregatorType=$aggregatorType,")
        append("aggregators=$aggregators,")
        append("attributeName=$attributeName,")
        append("typeName=$typeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregatorType.hashCode()
        result = 31 * result + (aggregators?.hashCode() ?: 0)
        result = 31 * result + (attributeName.hashCode())
        result = 31 * result + (typeName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeAggregator

        if (aggregatorType != other.aggregatorType) return false
        if (aggregators != other.aggregators) return false
        if (attributeName != other.attributeName) return false
        if (typeName != other.typeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.NodeAggregator = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The aggregator type for limiting a node summary. Currently, only `Count` is supported.
         */
        public var aggregatorType: aws.sdk.kotlin.services.ssm.model.NodeAggregatorType? = null
        /**
         * Information about aggregators used to refine a node summary.
         */
        public var aggregators: List<NodeAggregator>? = null
        /**
         * The name of a node attribute on which to limit the count of nodes.
         */
        public var attributeName: aws.sdk.kotlin.services.ssm.model.NodeAttributeName? = null
        /**
         * The data type name to use for viewing counts of nodes. Currently, only `Instance` is supported.
         */
        public var typeName: aws.sdk.kotlin.services.ssm.model.NodeTypeName? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.NodeAggregator) : this() {
            this.aggregatorType = x.aggregatorType
            this.aggregators = x.aggregators
            this.attributeName = x.attributeName
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.NodeAggregator = NodeAggregator(this)

        internal fun correctErrors(): Builder {
            if (aggregatorType == null) aggregatorType = NodeAggregatorType.SdkUnknown("no value provided")
            if (attributeName == null) attributeName = NodeAttributeName.SdkUnknown("no value provided")
            if (typeName == null) typeName = NodeTypeName.SdkUnknown("no value provided")
            return this
        }
    }
}
