// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDocumentRequest private constructor(builder: Builder) {
    /**
     * A list of key-value pairs that describe attachments to a version of a document.
     */
    public val attachments: List<AttachmentsSource>? = builder.attachments
    /**
     * The content for the new SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
     *
     * For examples, see the following topics in the *Amazon Web Services Systems Manager User Guide*.
     * + [Create an SSM document (console)](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html#create-ssm-console)
     * + [Create an SSM document (command line)](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html#create-ssm-document-cli)
     * + [Create an SSM document (API)](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html#create-ssm-document-api)
     */
    public val content: kotlin.String? = builder.content
    /**
     * An optional field where you can specify a friendly name for the SSM document. This value can differ for each version of the document. You can update this value at a later time using the UpdateDocument operation.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the default format.
     */
    public val documentFormat: aws.sdk.kotlin.services.ssm.model.DocumentFormat? = builder.documentFormat
    /**
     * The type of document to create.
     *
     * The `DeploymentStrategy` document type is an internal-use-only document type reserved for AppConfig.
     */
    public val documentType: aws.sdk.kotlin.services.ssm.model.DocumentType? = builder.documentType
    /**
     * A name for the SSM document.
     *
     * You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services for use as document name prefixes:
     * + `aws`
     * + `amazon`
     * + `amzn`
     * + `AWSEC2`
     * + `AWSConfigRemediation`
     * + `AWSSupport`
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of SSM documents required by a document. This parameter is used exclusively by AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an `ApplicationConfiguration` document requires an `ApplicationConfigurationSchema` document for validation purposes. For more information, see [What is AppConfig?](https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html) in the *AppConfig User Guide*.
     */
    public val requires: List<DocumentRequires>? = builder.requires
    /**
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the types of targets or the environment where it will run. In this case, you could specify the following key-value pairs:
     * + `Key=OS,Value=Windows`
     * + `Key=Environment,Value=Production`
     *
     * To add tags to an existing SSM document, use the AddTagsToResource operation.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specify a target type to define the kinds of resources the document can run on. For example, to run a document on EC2 instances, specify the following value: `/AWS::EC2::Instance`. If you specify a value of '/' the document can run on all types of resources. If you don't specify a value, the document can't run on any resources. For a list of valid resource types, see [Amazon Web Services resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation User Guide*.
     */
    public val targetType: kotlin.String? = builder.targetType
    /**
     * An optional field specifying the version of the artifact you are creating with the document. For example, `Release12.1`. This value is unique across all versions of a document, and can't be changed.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CreateDocumentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDocumentRequest(")
        append("attachments=$attachments,")
        append("content=$content,")
        append("displayName=$displayName,")
        append("documentFormat=$documentFormat,")
        append("documentType=$documentType,")
        append("name=$name,")
        append("requires=$requires,")
        append("tags=$tags,")
        append("targetType=$targetType,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachments?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (documentFormat?.hashCode() ?: 0)
        result = 31 * result + (documentType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requires?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDocumentRequest

        if (attachments != other.attachments) return false
        if (content != other.content) return false
        if (displayName != other.displayName) return false
        if (documentFormat != other.documentFormat) return false
        if (documentType != other.documentType) return false
        if (name != other.name) return false
        if (requires != other.requires) return false
        if (tags != other.tags) return false
        if (targetType != other.targetType) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CreateDocumentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of key-value pairs that describe attachments to a version of a document.
         */
        public var attachments: List<AttachmentsSource>? = null
        /**
         * The content for the new SSM document in JSON or YAML format. The content of the document must not exceed 64KB. This quota also includes the content specified for input parameters at runtime. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.
         *
         * For examples, see the following topics in the *Amazon Web Services Systems Manager User Guide*.
         * + [Create an SSM document (console)](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html#create-ssm-console)
         * + [Create an SSM document (command line)](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html#create-ssm-document-cli)
         * + [Create an SSM document (API)](https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html#create-ssm-document-api)
         */
        public var content: kotlin.String? = null
        /**
         * An optional field where you can specify a friendly name for the SSM document. This value can differ for each version of the document. You can update this value at a later time using the UpdateDocument operation.
         */
        public var displayName: kotlin.String? = null
        /**
         * Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the default format.
         */
        public var documentFormat: aws.sdk.kotlin.services.ssm.model.DocumentFormat? = null
        /**
         * The type of document to create.
         *
         * The `DeploymentStrategy` document type is an internal-use-only document type reserved for AppConfig.
         */
        public var documentType: aws.sdk.kotlin.services.ssm.model.DocumentType? = null
        /**
         * A name for the SSM document.
         *
         * You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services for use as document name prefixes:
         * + `aws`
         * + `amazon`
         * + `amzn`
         * + `AWSEC2`
         * + `AWSConfigRemediation`
         * + `AWSSupport`
         */
        public var name: kotlin.String? = null
        /**
         * A list of SSM documents required by a document. This parameter is used exclusively by AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an `ApplicationConfiguration` document requires an `ApplicationConfigurationSchema` document for validation purposes. For more information, see [What is AppConfig?](https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html) in the *AppConfig User Guide*.
         */
        public var requires: List<DocumentRequires>? = null
        /**
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the types of targets or the environment where it will run. In this case, you could specify the following key-value pairs:
         * + `Key=OS,Value=Windows`
         * + `Key=Environment,Value=Production`
         *
         * To add tags to an existing SSM document, use the AddTagsToResource operation.
         */
        public var tags: List<Tag>? = null
        /**
         * Specify a target type to define the kinds of resources the document can run on. For example, to run a document on EC2 instances, specify the following value: `/AWS::EC2::Instance`. If you specify a value of '/' the document can run on all types of resources. If you don't specify a value, the document can't run on any resources. For a list of valid resource types, see [Amazon Web Services resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation User Guide*.
         */
        public var targetType: kotlin.String? = null
        /**
         * An optional field specifying the version of the artifact you are creating with the document. For example, `Release12.1`. This value is unique across all versions of a document, and can't be changed.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CreateDocumentRequest) : this() {
            this.attachments = x.attachments
            this.content = x.content
            this.displayName = x.displayName
            this.documentFormat = x.documentFormat
            this.documentType = x.documentType
            this.name = x.name
            this.requires = x.requires
            this.tags = x.tags
            this.targetType = x.targetType
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CreateDocumentRequest = CreateDocumentRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
