// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteResourcePolicyOperationDeserializer: HttpDeserializer.NonStreaming<DeleteResourcePolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteResourcePolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteResourcePolicyError(context, call, payload)
        }
        val builder = DeleteResourcePolicyResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteResourcePolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "MalformedResourcePolicyDocumentException" -> MalformedResourcePolicyDocumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourcePolicyConflictException" -> ResourcePolicyConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourcePolicyInvalidParameterException" -> ResourcePolicyInvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourcePolicyNotFoundException" -> ResourcePolicyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
