// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SendCommandRequest private constructor(builder: Builder) {
    /**
     * The CloudWatch alarm you want to apply to your command.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * Enables Amazon Web Services Systems Manager to send Run Command output to Amazon CloudWatch Logs. Run Command is a tool in Amazon Web Services Systems Manager.
     */
    public val cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = builder.cloudWatchOutputConfig
    /**
     * User-specified information about the command, such as a brief description of what the command should do.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The Sha256 or Sha1 hash created by the system when the document was created.
     *
     * Sha1 hashes have been deprecated.
     */
    public val documentHash: kotlin.String? = builder.documentHash
    /**
     * Sha256 or Sha1.
     *
     * Sha1 hashes have been deprecated.
     */
    public val documentHashType: aws.sdk.kotlin.services.ssm.model.DocumentHashType? = builder.documentHashType
    /**
     * The name of the Amazon Web Services Systems Manager document (SSM document) to run. This can be a public document or a custom document. To run a shared document belonging to another account, specify the document Amazon Resource Name (ARN). For more information about how to use shared documents, see [Sharing SSM documents](https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * If you specify a document name or ARN that hasn't been shared with your account, you receive an `InvalidDocument` error.
     */
    public val documentName: kotlin.String? = builder.documentName
    /**
     * The SSM document version to use in the request. You can specify $DEFAULT, $LATEST, or a specific version number. If you run commands by using the Command Line Interface (Amazon Web Services CLI), then you must escape the first two options by using a backslash. If you specify a version number, then you don't need to use the backslash. For example:
     *
     * --document-version "\$DEFAULT"
     *
     * --document-version "\$LATEST"
     *
     * --document-version "3"
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The IDs of the managed nodes where the command should run. Specifying managed node IDs is most useful when you are targeting a limited number of managed nodes, though you can specify up to 50 IDs.
     *
     * To target a larger number of managed nodes, or if you prefer not to list individual node IDs, we recommend using the `Targets` option instead. Using `Targets`, which accepts tag key-value pairs to identify the managed nodes to send commands to, you can a send command to tens, hundreds, or thousands of nodes at once.
     *
     * For more information about how to use targets, see [Run commands at scale](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val instanceIds: List<String>? = builder.instanceIds
    /**
     * (Optional) The maximum number of managed nodes that are allowed to run the command at the same time. You can specify a number such as 10 or a percentage such as 10%. The default value is `50`. For more information about how to use `MaxConcurrency`, see [Using concurrency controls](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The maximum number of errors allowed without the command failing. When the command fails one more time beyond the value of `MaxErrors`, the systems stops sending the command to additional targets. You can specify a number like 10 or a percentage like 10%. The default value is `0`. For more information about how to use `MaxErrors`, see [Using error controls](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * Configurations for sending notifications.
     */
    public val notificationConfig: aws.sdk.kotlin.services.ssm.model.NotificationConfig? = builder.notificationConfig
    /**
     * The name of the S3 bucket where command execution responses should be stored.
     */
    public val outputS3BucketName: kotlin.String? = builder.outputS3BucketName
    /**
     * The directory structure within the S3 bucket where the responses should be stored.
     */
    public val outputS3KeyPrefix: kotlin.String? = builder.outputS3KeyPrefix
    /**
     * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon Web Services Region of the S3 bucket.
     */
    public val outputS3Region: kotlin.String? = builder.outputS3Region
    /**
     * The required and optional parameters specified in the document being run.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * The ARN of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for Run Command commands.
     *
     * This role must provide the `sns:Publish` permission for your notification topic. For information about creating and using this service role, see [Monitoring Systems Manager status changes using Amazon SNS notifications](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * An array of search criteria that targets managed nodes using a `Key,Value` combination that you specify. Specifying targets is most useful when you want to send a command to a large number of managed nodes at once. Using `Targets`, which accepts tag key-value pairs to identify managed nodes, you can send a command to tens, hundreds, or thousands of nodes at once.
     *
     * To send a command to a smaller number of managed nodes, you can use the `InstanceIds` option instead.
     *
     * For more information about how to use targets, see [Run commands at scale](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val targets: List<Target>? = builder.targets
    /**
     * If this time is reached and the command hasn't already started running, it won't run.
     */
    public val timeoutSeconds: kotlin.Int? = builder.timeoutSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.SendCommandRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendCommandRequest(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("cloudWatchOutputConfig=$cloudWatchOutputConfig,")
        append("comment=$comment,")
        append("documentHash=$documentHash,")
        append("documentHashType=$documentHashType,")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("instanceIds=$instanceIds,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("notificationConfig=$notificationConfig,")
        append("outputS3BucketName=$outputS3BucketName,")
        append("outputS3KeyPrefix=$outputS3KeyPrefix,")
        append("outputS3Region=$outputS3Region,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("targets=$targets,")
        append("timeoutSeconds=$timeoutSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (cloudWatchOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (documentHash?.hashCode() ?: 0)
        result = 31 * result + (documentHashType?.hashCode() ?: 0)
        result = 31 * result + (documentName?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceIds?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (notificationConfig?.hashCode() ?: 0)
        result = 31 * result + (outputS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (outputS3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (outputS3Region?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (timeoutSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendCommandRequest

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (cloudWatchOutputConfig != other.cloudWatchOutputConfig) return false
        if (comment != other.comment) return false
        if (documentHash != other.documentHash) return false
        if (documentHashType != other.documentHashType) return false
        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (instanceIds != other.instanceIds) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (notificationConfig != other.notificationConfig) return false
        if (outputS3BucketName != other.outputS3BucketName) return false
        if (outputS3KeyPrefix != other.outputS3KeyPrefix) return false
        if (outputS3Region != other.outputS3Region) return false
        if (parameters != other.parameters) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (targets != other.targets) return false
        if (timeoutSeconds != other.timeoutSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.SendCommandRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The CloudWatch alarm you want to apply to your command.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * Enables Amazon Web Services Systems Manager to send Run Command output to Amazon CloudWatch Logs. Run Command is a tool in Amazon Web Services Systems Manager.
         */
        public var cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = null
        /**
         * User-specified information about the command, such as a brief description of what the command should do.
         */
        public var comment: kotlin.String? = null
        /**
         * The Sha256 or Sha1 hash created by the system when the document was created.
         *
         * Sha1 hashes have been deprecated.
         */
        public var documentHash: kotlin.String? = null
        /**
         * Sha256 or Sha1.
         *
         * Sha1 hashes have been deprecated.
         */
        public var documentHashType: aws.sdk.kotlin.services.ssm.model.DocumentHashType? = null
        /**
         * The name of the Amazon Web Services Systems Manager document (SSM document) to run. This can be a public document or a custom document. To run a shared document belonging to another account, specify the document Amazon Resource Name (ARN). For more information about how to use shared documents, see [Sharing SSM documents](https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html) in the *Amazon Web Services Systems Manager User Guide*.
         *
         * If you specify a document name or ARN that hasn't been shared with your account, you receive an `InvalidDocument` error.
         */
        public var documentName: kotlin.String? = null
        /**
         * The SSM document version to use in the request. You can specify $DEFAULT, $LATEST, or a specific version number. If you run commands by using the Command Line Interface (Amazon Web Services CLI), then you must escape the first two options by using a backslash. If you specify a version number, then you don't need to use the backslash. For example:
         *
         * --document-version "\$DEFAULT"
         *
         * --document-version "\$LATEST"
         *
         * --document-version "3"
         */
        public var documentVersion: kotlin.String? = null
        /**
         * The IDs of the managed nodes where the command should run. Specifying managed node IDs is most useful when you are targeting a limited number of managed nodes, though you can specify up to 50 IDs.
         *
         * To target a larger number of managed nodes, or if you prefer not to list individual node IDs, we recommend using the `Targets` option instead. Using `Targets`, which accepts tag key-value pairs to identify the managed nodes to send commands to, you can a send command to tens, hundreds, or thousands of nodes at once.
         *
         * For more information about how to use targets, see [Run commands at scale](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var instanceIds: List<String>? = null
        /**
         * (Optional) The maximum number of managed nodes that are allowed to run the command at the same time. You can specify a number such as 10 or a percentage such as 10%. The default value is `50`. For more information about how to use `MaxConcurrency`, see [Using concurrency controls](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var maxConcurrency: kotlin.String? = null
        /**
         * The maximum number of errors allowed without the command failing. When the command fails one more time beyond the value of `MaxErrors`, the systems stops sending the command to additional targets. You can specify a number like 10 or a percentage like 10%. The default value is `0`. For more information about how to use `MaxErrors`, see [Using error controls](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var maxErrors: kotlin.String? = null
        /**
         * Configurations for sending notifications.
         */
        public var notificationConfig: aws.sdk.kotlin.services.ssm.model.NotificationConfig? = null
        /**
         * The name of the S3 bucket where command execution responses should be stored.
         */
        public var outputS3BucketName: kotlin.String? = null
        /**
         * The directory structure within the S3 bucket where the responses should be stored.
         */
        public var outputS3KeyPrefix: kotlin.String? = null
        /**
         * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon Web Services Region of the S3 bucket.
         */
        public var outputS3Region: kotlin.String? = null
        /**
         * The required and optional parameters specified in the document being run.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * The ARN of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for Run Command commands.
         *
         * This role must provide the `sns:Publish` permission for your notification topic. For information about creating and using this service role, see [Monitoring Systems Manager status changes using Amazon SNS notifications](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * An array of search criteria that targets managed nodes using a `Key,Value` combination that you specify. Specifying targets is most useful when you want to send a command to a large number of managed nodes at once. Using `Targets`, which accepts tag key-value pairs to identify managed nodes, you can send a command to tens, hundreds, or thousands of nodes at once.
         *
         * To send a command to a smaller number of managed nodes, you can use the `InstanceIds` option instead.
         *
         * For more information about how to use targets, see [Run commands at scale](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var targets: List<Target>? = null
        /**
         * If this time is reached and the command hasn't already started running, it won't run.
         */
        public var timeoutSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.SendCommandRequest) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.cloudWatchOutputConfig = x.cloudWatchOutputConfig
            this.comment = x.comment
            this.documentHash = x.documentHash
            this.documentHashType = x.documentHashType
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.instanceIds = x.instanceIds
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.notificationConfig = x.notificationConfig
            this.outputS3BucketName = x.outputS3BucketName
            this.outputS3KeyPrefix = x.outputS3KeyPrefix
            this.outputS3Region = x.outputS3Region
            this.parameters = x.parameters
            this.serviceRoleArn = x.serviceRoleArn
            this.targets = x.targets
            this.timeoutSeconds = x.timeoutSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.SendCommandRequest = SendCommandRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig] inside the given [block]
         */
        public fun cloudWatchOutputConfig(block: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.Builder.() -> kotlin.Unit) {
            this.cloudWatchOutputConfig = aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.NotificationConfig] inside the given [block]
         */
        public fun notificationConfig(block: aws.sdk.kotlin.services.ssm.model.NotificationConfig.Builder.() -> kotlin.Unit) {
            this.notificationConfig = aws.sdk.kotlin.services.ssm.model.NotificationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
