// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetMaintenanceWindowResponse private constructor(builder: Builder) {
    /**
     * Whether targets must be registered with the maintenance window before tasks can be defined for those targets.
     */
    public val allowUnassociatedTargets: kotlin.Boolean = builder.allowUnassociatedTargets
    /**
     * The date the maintenance window was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.
     */
    public val cutoff: kotlin.Int = builder.cutoff
    /**
     * The description of the maintenance window.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The duration of the maintenance window in hours.
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * Indicates whether the maintenance window is enabled.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.
     */
    public val endDate: kotlin.String? = builder.endDate
    /**
     * The date the maintenance window was last modified.
     */
    public val modifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedDate
    /**
     * The name of the maintenance window.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.
     */
    public val nextExecutionTime: kotlin.String? = builder.nextExecutionTime
    /**
     * The schedule of the maintenance window in the form of a cron or rate expression.
     */
    public val schedule: kotlin.String? = builder.schedule
    /**
     * The number of days to wait to run a maintenance window after the scheduled cron expression date and time.
     */
    public val scheduleOffset: kotlin.Int? = builder.scheduleOffset
    /**
     * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the [Time Zone Database](https://www.iana.org/time-zones) on the IANA website.
     */
    public val scheduleTimezone: kotlin.String? = builder.scheduleTimezone
    /**
     * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.
     */
    public val startDate: kotlin.String? = builder.startDate
    /**
     * The ID of the created maintenance window.
     */
    public val windowId: kotlin.String? = builder.windowId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMaintenanceWindowResponse(")
        append("allowUnassociatedTargets=$allowUnassociatedTargets,")
        append("createdDate=$createdDate,")
        append("cutoff=$cutoff,")
        append("description=*** Sensitive Data Redacted ***,")
        append("duration=$duration,")
        append("enabled=$enabled,")
        append("endDate=$endDate,")
        append("modifiedDate=$modifiedDate,")
        append("name=$name,")
        append("nextExecutionTime=$nextExecutionTime,")
        append("schedule=$schedule,")
        append("scheduleOffset=$scheduleOffset,")
        append("scheduleTimezone=$scheduleTimezone,")
        append("startDate=$startDate,")
        append("windowId=$windowId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowUnassociatedTargets.hashCode()
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (cutoff)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (modifiedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextExecutionTime?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (scheduleOffset ?: 0)
        result = 31 * result + (scheduleTimezone?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (windowId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMaintenanceWindowResponse

        if (allowUnassociatedTargets != other.allowUnassociatedTargets) return false
        if (createdDate != other.createdDate) return false
        if (cutoff != other.cutoff) return false
        if (description != other.description) return false
        if (duration != other.duration) return false
        if (enabled != other.enabled) return false
        if (endDate != other.endDate) return false
        if (modifiedDate != other.modifiedDate) return false
        if (name != other.name) return false
        if (nextExecutionTime != other.nextExecutionTime) return false
        if (schedule != other.schedule) return false
        if (scheduleOffset != other.scheduleOffset) return false
        if (scheduleTimezone != other.scheduleTimezone) return false
        if (startDate != other.startDate) return false
        if (windowId != other.windowId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether targets must be registered with the maintenance window before tasks can be defined for those targets.
         */
        public var allowUnassociatedTargets: kotlin.Boolean = false
        /**
         * The date the maintenance window was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.
         */
        public var cutoff: kotlin.Int = 0
        /**
         * The description of the maintenance window.
         */
        public var description: kotlin.String? = null
        /**
         * The duration of the maintenance window in hours.
         */
        public var duration: kotlin.Int? = null
        /**
         * Indicates whether the maintenance window is enabled.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.
         */
        public var endDate: kotlin.String? = null
        /**
         * The date the maintenance window was last modified.
         */
        public var modifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the maintenance window.
         */
        public var name: kotlin.String? = null
        /**
         * The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.
         */
        public var nextExecutionTime: kotlin.String? = null
        /**
         * The schedule of the maintenance window in the form of a cron or rate expression.
         */
        public var schedule: kotlin.String? = null
        /**
         * The number of days to wait to run a maintenance window after the scheduled cron expression date and time.
         */
        public var scheduleOffset: kotlin.Int? = null
        /**
         * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the [Time Zone Database](https://www.iana.org/time-zones) on the IANA website.
         */
        public var scheduleTimezone: kotlin.String? = null
        /**
         * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.
         */
        public var startDate: kotlin.String? = null
        /**
         * The ID of the created maintenance window.
         */
        public var windowId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowResponse) : this() {
            this.allowUnassociatedTargets = x.allowUnassociatedTargets
            this.createdDate = x.createdDate
            this.cutoff = x.cutoff
            this.description = x.description
            this.duration = x.duration
            this.enabled = x.enabled
            this.endDate = x.endDate
            this.modifiedDate = x.modifiedDate
            this.name = x.name
            this.nextExecutionTime = x.nextExecutionTime
            this.schedule = x.schedule
            this.scheduleOffset = x.scheduleOffset
            this.scheduleTimezone = x.scheduleTimezone
            this.startDate = x.startDate
            this.windowId = x.windowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowResponse = GetMaintenanceWindowResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
