// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.DocumentDescription
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.sdk.kotlin.services.ssm.model.UpdateDocumentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDocumentOperationDeserializer: HttpDeserializer.NonStreaming<UpdateDocumentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateDocumentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateDocumentError(context, call, payload)
        }
        val builder = UpdateDocumentResponse.Builder()

        if (payload != null) {
            deserializeUpdateDocumentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateDocumentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DocumentVersionLimitExceeded" -> DocumentVersionLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "DuplicateDocumentContent" -> DuplicateDocumentContentDeserializer().deserialize(context, wrappedCall, payload)
        "DuplicateDocumentVersionName" -> DuplicateDocumentVersionNameDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocument" -> InvalidDocumentDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocumentContent" -> InvalidDocumentContentDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocumentOperation" -> InvalidDocumentOperationDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocumentSchemaVersion" -> InvalidDocumentSchemaVersionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocumentVersion" -> InvalidDocumentVersionDeserializer().deserialize(context, wrappedCall, payload)
        "MaxDocumentSizeExceeded" -> MaxDocumentSizeExceededDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDocumentOperationBody(builder: UpdateDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOCUMENTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DocumentDescription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOCUMENTDESCRIPTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOCUMENTDESCRIPTION_DESCRIPTOR.index -> builder.documentDescription = deserializeDocumentDescriptionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
