// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The request or operation couldn't be performed because the service is throttling requests.
 */
public class ThrottlingException private constructor(builder: Builder) : SsmException(builder.message) {

    /**
     * The quota code recognized by the Amazon Web Services Service Quotas service.
     */
    public val quotaCode: kotlin.String? = builder.quotaCode
    /**
     * The code for the Amazon Web Services service that owns the quota.
     */
    public val serviceCode: kotlin.String? = builder.serviceCode

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ThrottlingException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThrottlingException(")
        append("message=$message,")
        append("quotaCode=$quotaCode,")
        append("serviceCode=$serviceCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message.hashCode()
        result = 31 * result + (quotaCode?.hashCode() ?: 0)
        result = 31 * result + (serviceCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThrottlingException

        if (message != other.message) return false
        if (quotaCode != other.quotaCode) return false
        if (serviceCode != other.serviceCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ThrottlingException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        public var message: kotlin.String? = null
        /**
         * The quota code recognized by the Amazon Web Services Service Quotas service.
         */
        public var quotaCode: kotlin.String? = null
        /**
         * The code for the Amazon Web Services service that owns the quota.
         */
        public var serviceCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ThrottlingException) : this() {
            this.message = x.message
            this.quotaCode = x.quotaCode
            this.serviceCode = x.serviceCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ThrottlingException = ThrottlingException(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            return this
        }
    }
}
