// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * One or more aggregators for viewing counts of OpsData using different dimensions such as `Source`, `CreatedTime`, or `Source and CreatedTime`, to name a few.
 */
public class OpsAggregator private constructor(builder: Builder) {
    /**
     * Either a `Range` or `Count` aggregator for limiting an OpsData summary.
     */
    public val aggregatorType: kotlin.String? = builder.aggregatorType
    /**
     * A nested aggregator for viewing counts of OpsData.
     */
    public val aggregators: List<OpsAggregator>? = builder.aggregators
    /**
     * The name of an OpsData attribute on which to limit the count of OpsData.
     */
    public val attributeName: kotlin.String? = builder.attributeName
    /**
     * The aggregator filters.
     */
    public val filters: List<OpsFilter>? = builder.filters
    /**
     * The data type name to use for viewing counts of OpsData.
     */
    public val typeName: kotlin.String? = builder.typeName
    /**
     * The aggregator value.
     */
    public val values: Map<String, String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.OpsAggregator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpsAggregator(")
        append("aggregatorType=$aggregatorType,")
        append("aggregators=$aggregators,")
        append("attributeName=$attributeName,")
        append("filters=$filters,")
        append("typeName=$typeName,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregatorType?.hashCode() ?: 0
        result = 31 * result + (aggregators?.hashCode() ?: 0)
        result = 31 * result + (attributeName?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpsAggregator

        if (aggregatorType != other.aggregatorType) return false
        if (aggregators != other.aggregators) return false
        if (attributeName != other.attributeName) return false
        if (filters != other.filters) return false
        if (typeName != other.typeName) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.OpsAggregator = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Either a `Range` or `Count` aggregator for limiting an OpsData summary.
         */
        public var aggregatorType: kotlin.String? = null
        /**
         * A nested aggregator for viewing counts of OpsData.
         */
        public var aggregators: List<OpsAggregator>? = null
        /**
         * The name of an OpsData attribute on which to limit the count of OpsData.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The aggregator filters.
         */
        public var filters: List<OpsFilter>? = null
        /**
         * The data type name to use for viewing counts of OpsData.
         */
        public var typeName: kotlin.String? = null
        /**
         * The aggregator value.
         */
        public var values: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.OpsAggregator) : this() {
            this.aggregatorType = x.aggregatorType
            this.aggregators = x.aggregators
            this.attributeName = x.attributeName
            this.filters = x.filters
            this.typeName = x.typeName
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.OpsAggregator = OpsAggregator(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
