// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the optional inputs that can be specified for an automation execution preview.
 */
public class AutomationExecutionInputs private constructor(builder: Builder) {
    /**
     * Information about parameters that can be specified for the preview operation.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the Automation execution preview operation.
     */
    public val targetLocations: List<TargetLocation>? = builder.targetLocations
    /**
     * A publicly accessible URL for a file that contains the `TargetLocations` body. Currently, only files in presigned Amazon S3 buckets are supported.
     */
    public val targetLocationsUrl: kotlin.String? = builder.targetLocationsUrl
    /**
     * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified together.
     */
    public val targetMaps: List<Map<String, List<String>>>? = builder.targetMaps
    /**
     * The name of the parameter used as the target resource for the rate-controlled execution. Required if you specify targets.
     */
    public val targetParameterName: kotlin.String? = builder.targetParameterName
    /**
     * Information about the resources that would be included in the actual runbook execution, if it were to be run. Both Targets and TargetMaps can't be specified together.
     */
    public val targets: List<Target>? = builder.targets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.AutomationExecutionInputs = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomationExecutionInputs(")
        append("parameters=$parameters,")
        append("targetLocations=$targetLocations,")
        append("targetLocationsUrl=$targetLocationsUrl,")
        append("targetMaps=$targetMaps,")
        append("targetParameterName=$targetParameterName,")
        append("targets=$targets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = parameters?.hashCode() ?: 0
        result = 31 * result + (targetLocations?.hashCode() ?: 0)
        result = 31 * result + (targetLocationsUrl?.hashCode() ?: 0)
        result = 31 * result + (targetMaps?.hashCode() ?: 0)
        result = 31 * result + (targetParameterName?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomationExecutionInputs

        if (parameters != other.parameters) return false
        if (targetLocations != other.targetLocations) return false
        if (targetLocationsUrl != other.targetLocationsUrl) return false
        if (targetMaps != other.targetMaps) return false
        if (targetParameterName != other.targetParameterName) return false
        if (targets != other.targets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.AutomationExecutionInputs = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about parameters that can be specified for the preview operation.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the Automation execution preview operation.
         */
        public var targetLocations: List<TargetLocation>? = null
        /**
         * A publicly accessible URL for a file that contains the `TargetLocations` body. Currently, only files in presigned Amazon S3 buckets are supported.
         */
        public var targetLocationsUrl: kotlin.String? = null
        /**
         * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified together.
         */
        public var targetMaps: List<Map<String, List<String>>>? = null
        /**
         * The name of the parameter used as the target resource for the rate-controlled execution. Required if you specify targets.
         */
        public var targetParameterName: kotlin.String? = null
        /**
         * Information about the resources that would be included in the actual runbook execution, if it were to be run. Both Targets and TargetMaps can't be specified together.
         */
        public var targets: List<Target>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.AutomationExecutionInputs) : this() {
            this.parameters = x.parameters
            this.targetLocations = x.targetLocations
            this.targetLocationsUrl = x.targetLocationsUrl
            this.targetMaps = x.targetMaps
            this.targetParameterName = x.targetParameterName
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.AutomationExecutionInputs = AutomationExecutionInputs(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
