// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.Command
import aws.sdk.kotlin.services.ssm.model.SendCommandResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendCommandOperationDeserializer: HttpDeserializer.NonStreaming<SendCommandResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SendCommandResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSendCommandError(context, call, payload)
        }
        val builder = SendCommandResponse.Builder()

        if (payload != null) {
            deserializeSendCommandOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSendCommandError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateInstanceId" -> DuplicateInstanceIdDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocument" -> InvalidDocumentDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocumentVersion" -> InvalidDocumentVersionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidNotificationConfig" -> InvalidNotificationConfigDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOutputFolder" -> InvalidOutputFolderDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameters" -> InvalidParametersDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRole" -> InvalidRoleDeserializer().deserialize(context, wrappedCall, payload)
        "MaxDocumentSizeExceeded" -> MaxDocumentSizeExceededDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedPlatformType" -> UnsupportedPlatformTypeDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSendCommandOperationBody(builder: SendCommandResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMAND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Command"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMAND_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMAND_DESCRIPTOR.index -> builder.command = deserializeCommandDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
