// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.DisassociateOpsItemRelatedItemResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DisassociateOpsItemRelatedItemOperationDeserializer: HttpDeserializer.NonStreaming<DisassociateOpsItemRelatedItemResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DisassociateOpsItemRelatedItemResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDisassociateOpsItemRelatedItemError(context, call, payload)
        }
        val builder = DisassociateOpsItemRelatedItemResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDisassociateOpsItemRelatedItemError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "OpsItemConflictException" -> OpsItemConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OpsItemInvalidParameterException" -> OpsItemInvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OpsItemNotFoundException" -> OpsItemNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OpsItemRelatedItemAssociationNotFoundException" -> OpsItemRelatedItemAssociationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
