// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a Session Manager connection to a managed node.
 */
public class Session private constructor(builder: Builder) {
    /**
     * `Standard` access type is the default for Session Manager sessions. `JustInTime` is the access type for [Just-in-time node access](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-just-in-time-node-access.html).
     */
    public val accessType: aws.sdk.kotlin.services.ssm.model.AccessType? = builder.accessType
    /**
     * Reserved for future use.
     */
    public val details: kotlin.String? = builder.details
    /**
     * The name of the Session Manager SSM document used to define the parameters and plugin settings for the session. For example, `SSM-SessionManagerRunShell`.
     */
    public val documentName: kotlin.String? = builder.documentName
    /**
     * The date and time, in ISO-8601 Extended format, when the session was terminated.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endDate
    /**
     * The maximum duration of a session before it terminates.
     */
    public val maxSessionDuration: kotlin.String? = builder.maxSessionDuration
    /**
     * Reserved for future use.
     */
    public val outputUrl: aws.sdk.kotlin.services.ssm.model.SessionManagerOutputUrl? = builder.outputUrl
    /**
     * The ID of the Amazon Web Services user that started the session.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The reason for connecting to the instance.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The ID of the session.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * The date and time, in ISO-8601 Extended format, when the session began.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * The status of the session. For example, "Connected" or "Terminated".
     */
    public val status: aws.sdk.kotlin.services.ssm.model.SessionStatus? = builder.status
    /**
     * The managed node that the Session Manager session connected to.
     */
    public val target: kotlin.String? = builder.target

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Session = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Session(")
        append("accessType=$accessType,")
        append("details=$details,")
        append("documentName=$documentName,")
        append("endDate=$endDate,")
        append("maxSessionDuration=$maxSessionDuration,")
        append("outputUrl=$outputUrl,")
        append("owner=$owner,")
        append("reason=$reason,")
        append("sessionId=$sessionId,")
        append("startDate=$startDate,")
        append("status=$status,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessType?.hashCode() ?: 0
        result = 31 * result + (details?.hashCode() ?: 0)
        result = 31 * result + (documentName?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (maxSessionDuration?.hashCode() ?: 0)
        result = 31 * result + (outputUrl?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Session

        if (accessType != other.accessType) return false
        if (details != other.details) return false
        if (documentName != other.documentName) return false
        if (endDate != other.endDate) return false
        if (maxSessionDuration != other.maxSessionDuration) return false
        if (outputUrl != other.outputUrl) return false
        if (owner != other.owner) return false
        if (reason != other.reason) return false
        if (sessionId != other.sessionId) return false
        if (startDate != other.startDate) return false
        if (status != other.status) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Session = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * `Standard` access type is the default for Session Manager sessions. `JustInTime` is the access type for [Just-in-time node access](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-just-in-time-node-access.html).
         */
        public var accessType: aws.sdk.kotlin.services.ssm.model.AccessType? = null
        /**
         * Reserved for future use.
         */
        public var details: kotlin.String? = null
        /**
         * The name of the Session Manager SSM document used to define the parameters and plugin settings for the session. For example, `SSM-SessionManagerRunShell`.
         */
        public var documentName: kotlin.String? = null
        /**
         * The date and time, in ISO-8601 Extended format, when the session was terminated.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum duration of a session before it terminates.
         */
        public var maxSessionDuration: kotlin.String? = null
        /**
         * Reserved for future use.
         */
        public var outputUrl: aws.sdk.kotlin.services.ssm.model.SessionManagerOutputUrl? = null
        /**
         * The ID of the Amazon Web Services user that started the session.
         */
        public var owner: kotlin.String? = null
        /**
         * The reason for connecting to the instance.
         */
        public var reason: kotlin.String? = null
        /**
         * The ID of the session.
         */
        public var sessionId: kotlin.String? = null
        /**
         * The date and time, in ISO-8601 Extended format, when the session began.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the session. For example, "Connected" or "Terminated".
         */
        public var status: aws.sdk.kotlin.services.ssm.model.SessionStatus? = null
        /**
         * The managed node that the Session Manager session connected to.
         */
        public var target: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Session) : this() {
            this.accessType = x.accessType
            this.details = x.details
            this.documentName = x.documentName
            this.endDate = x.endDate
            this.maxSessionDuration = x.maxSessionDuration
            this.outputUrl = x.outputUrl
            this.owner = x.owner
            this.reason = x.reason
            this.sessionId = x.sessionId
            this.startDate = x.startDate
            this.status = x.status
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Session = Session(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.SessionManagerOutputUrl] inside the given [block]
         */
        public fun outputUrl(block: aws.sdk.kotlin.services.ssm.model.SessionManagerOutputUrl.Builder.() -> kotlin.Unit) {
            this.outputUrl = aws.sdk.kotlin.services.ssm.model.SessionManagerOutputUrl.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
