// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a filter for a specific list of OpsItem events. You can filter event information by using tags. You specify tags by using a key-value pair mapping.
 */
public class OpsItemEventFilter private constructor(builder: Builder) {
    /**
     * The name of the filter key. Currently, the only supported value is `OpsItemId`.
     */
    public val key: aws.sdk.kotlin.services.ssm.model.OpsItemEventFilterKey = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The operator used by the filter call. Currently, the only supported value is `Equal`.
     */
    public val operator: aws.sdk.kotlin.services.ssm.model.OpsItemEventFilterOperator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * The values for the filter, consisting of one or more OpsItem IDs.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.OpsItemEventFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpsItemEventFilter(")
        append("key=$key,")
        append("operator=$operator,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (operator.hashCode())
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpsItemEventFilter

        if (key != other.key) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.OpsItemEventFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the filter key. Currently, the only supported value is `OpsItemId`.
         */
        public var key: aws.sdk.kotlin.services.ssm.model.OpsItemEventFilterKey? = null
        /**
         * The operator used by the filter call. Currently, the only supported value is `Equal`.
         */
        public var operator: aws.sdk.kotlin.services.ssm.model.OpsItemEventFilterOperator? = null
        /**
         * The values for the filter, consisting of one or more OpsItem IDs.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.OpsItemEventFilter) : this() {
            this.key = x.key
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.OpsItemEventFilter = OpsItemEventFilter(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = OpsItemEventFilterKey.SdkUnknown("no value provided")
            if (operator == null) operator = OpsItemEventFilterOperator.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
