// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The parameters for a `LAMBDA` task type.
 *
 * For information about specifying and updating task parameters, see RegisterTaskWithMaintenanceWindow and UpdateMaintenanceWindowTask.
 *
 * `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix` options in the `TaskInvocationParameters` structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
 *
 * `TaskParameters` has been deprecated. To specify parameters to pass to a task when it runs, instead use the `Parameters` option in the `TaskInvocationParameters` structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
 *
 * For Lambda tasks, Systems Manager ignores any values specified for TaskParameters and LoggingInfo.
 */
public class MaintenanceWindowLambdaParameters private constructor(builder: Builder) {
    /**
     * Pass client-specific information to the Lambda function that you are invoking. You can then process the client information in your Lambda function as you choose through the context variable.
     */
    public val clientContext: kotlin.String? = builder.clientContext
    /**
     * JSON to provide to your Lambda function as input.
     */
    public val payload: kotlin.ByteArray? = builder.payload
    /**
     * (Optional) Specify an Lambda function version or alias name. If you specify a function version, the operation uses the qualified function Amazon Resource Name (ARN) to invoke a specific Lambda function. If you specify an alias name, the operation uses the alias ARN to invoke the Lambda function version to which the alias points.
     */
    public val qualifier: kotlin.String? = builder.qualifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowLambdaParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MaintenanceWindowLambdaParameters(")
        append("clientContext=$clientContext,")
        append("payload=*** Sensitive Data Redacted ***,")
        append("qualifier=$qualifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientContext?.hashCode() ?: 0
        result = 31 * result + (payload?.contentHashCode() ?: 0)
        result = 31 * result + (qualifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MaintenanceWindowLambdaParameters

        if (clientContext != other.clientContext) return false
        if (payload != null) {
            if (other.payload == null) return false
            if (!payload.contentEquals(other.payload)) return false
        } else if (other.payload != null) return false
        if (qualifier != other.qualifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowLambdaParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Pass client-specific information to the Lambda function that you are invoking. You can then process the client information in your Lambda function as you choose through the context variable.
         */
        public var clientContext: kotlin.String? = null
        /**
         * JSON to provide to your Lambda function as input.
         */
        public var payload: kotlin.ByteArray? = null
        /**
         * (Optional) Specify an Lambda function version or alias name. If you specify a function version, the operation uses the qualified function Amazon Resource Name (ARN) to invoke a specific Lambda function. If you specify an alias name, the operation uses the alias ARN to invoke the Lambda function version to which the alias points.
         */
        public var qualifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowLambdaParameters) : this() {
            this.clientContext = x.clientContext
            this.payload = x.payload
            this.qualifier = x.qualifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowLambdaParameters = MaintenanceWindowLambdaParameters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
