// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Web Services Systems Manager document (SSM document).
 */
public class DocumentDescription private constructor(builder: Builder) {
    /**
     * The version of the document currently approved for use in the organization.
     */
    public val approvedVersion: kotlin.String? = builder.approvedVersion
    /**
     * Details about the document attachments, including names, locations, sizes, and so on.
     */
    public val attachmentsInformation: List<AttachmentInformation>? = builder.attachmentsInformation
    /**
     * The user in your organization who created the document.
     */
    public val author: kotlin.String? = builder.author
    /**
     * The classification of a document to help you identify and categorize its use.
     */
    public val category: List<String>? = builder.category
    /**
     * The value that identifies a document's category.
     */
    public val categoryEnum: List<String>? = builder.categoryEnum
    /**
     * The date when the document was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The default version.
     */
    public val defaultVersion: kotlin.String? = builder.defaultVersion
    /**
     * A description of the document.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The friendly name of the SSM document. This value can differ for each version of the document. If you want to update this value, see UpdateDocument.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The document format, either JSON or YAML.
     */
    public val documentFormat: aws.sdk.kotlin.services.ssm.model.DocumentFormat? = builder.documentFormat
    /**
     * The type of document.
     */
    public val documentType: aws.sdk.kotlin.services.ssm.model.DocumentType? = builder.documentType
    /**
     * The document version.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The Sha256 or Sha1 hash created by the system when the document was created.
     *
     * Sha1 hashes have been deprecated.
     */
    public val hash: kotlin.String? = builder.hash
    /**
     * The hash type of the document. Valid values include `Sha256` or `Sha1`.
     *
     * Sha1 hashes have been deprecated.
     */
    public val hashType: aws.sdk.kotlin.services.ssm.model.DocumentHashType? = builder.hashType
    /**
     * The latest version of the document.
     */
    public val latestVersion: kotlin.String? = builder.latestVersion
    /**
     * The name of the SSM document.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services user that created the document.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * A description of the parameters for a document.
     */
    public val parameters: List<DocumentParameter>? = builder.parameters
    /**
     * The version of the document that is currently under review.
     */
    public val pendingReviewVersion: kotlin.String? = builder.pendingReviewVersion
    /**
     * The list of operating system (OS) platforms compatible with this SSM document.
     */
    public val platformTypes: List<PlatformType>? = builder.platformTypes
    /**
     * A list of SSM documents required by a document. For example, an `ApplicationConfiguration` document requires an `ApplicationConfigurationSchema` document.
     */
    public val requires: List<DocumentRequires>? = builder.requires
    /**
     * Details about the review of a document.
     */
    public val reviewInformation: List<ReviewInformation>? = builder.reviewInformation
    /**
     * The current status of the review.
     */
    public val reviewStatus: aws.sdk.kotlin.services.ssm.model.ReviewStatus? = builder.reviewStatus
    /**
     * The schema version.
     */
    public val schemaVersion: kotlin.String? = builder.schemaVersion
    /**
     * The SHA1 hash of the document, which you can use for verification.
     */
    public val sha1: kotlin.String? = builder.sha1
    /**
     * The status of the SSM document.
     */
    public val status: aws.sdk.kotlin.services.ssm.model.DocumentStatus? = builder.status
    /**
     * A message returned by Amazon Web Services Systems Manager that explains the `Status` value. For example, a `Failed` status might be explained by the `StatusInformation` message, "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."
     */
    public val statusInformation: kotlin.String? = builder.statusInformation
    /**
     * The tags, or metadata, that have been applied to the document.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [Amazon Web Services resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation User Guide*.
     */
    public val targetType: kotlin.String? = builder.targetType
    /**
     * The version of the artifact associated with the document.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.DocumentDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentDescription(")
        append("approvedVersion=$approvedVersion,")
        append("attachmentsInformation=$attachmentsInformation,")
        append("author=$author,")
        append("category=$category,")
        append("categoryEnum=$categoryEnum,")
        append("createdDate=$createdDate,")
        append("defaultVersion=$defaultVersion,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("documentFormat=$documentFormat,")
        append("documentType=$documentType,")
        append("documentVersion=$documentVersion,")
        append("hash=$hash,")
        append("hashType=$hashType,")
        append("latestVersion=$latestVersion,")
        append("name=$name,")
        append("owner=$owner,")
        append("parameters=$parameters,")
        append("pendingReviewVersion=$pendingReviewVersion,")
        append("platformTypes=$platformTypes,")
        append("requires=$requires,")
        append("reviewInformation=$reviewInformation,")
        append("reviewStatus=$reviewStatus,")
        append("schemaVersion=$schemaVersion,")
        append("sha1=$sha1,")
        append("status=$status,")
        append("statusInformation=$statusInformation,")
        append("tags=$tags,")
        append("targetType=$targetType,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = approvedVersion?.hashCode() ?: 0
        result = 31 * result + (attachmentsInformation?.hashCode() ?: 0)
        result = 31 * result + (author?.hashCode() ?: 0)
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (categoryEnum?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (defaultVersion?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (documentFormat?.hashCode() ?: 0)
        result = 31 * result + (documentType?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (hash?.hashCode() ?: 0)
        result = 31 * result + (hashType?.hashCode() ?: 0)
        result = 31 * result + (latestVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (pendingReviewVersion?.hashCode() ?: 0)
        result = 31 * result + (platformTypes?.hashCode() ?: 0)
        result = 31 * result + (requires?.hashCode() ?: 0)
        result = 31 * result + (reviewInformation?.hashCode() ?: 0)
        result = 31 * result + (reviewStatus?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (sha1?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusInformation?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentDescription

        if (approvedVersion != other.approvedVersion) return false
        if (attachmentsInformation != other.attachmentsInformation) return false
        if (author != other.author) return false
        if (category != other.category) return false
        if (categoryEnum != other.categoryEnum) return false
        if (createdDate != other.createdDate) return false
        if (defaultVersion != other.defaultVersion) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (documentFormat != other.documentFormat) return false
        if (documentType != other.documentType) return false
        if (documentVersion != other.documentVersion) return false
        if (hash != other.hash) return false
        if (hashType != other.hashType) return false
        if (latestVersion != other.latestVersion) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (parameters != other.parameters) return false
        if (pendingReviewVersion != other.pendingReviewVersion) return false
        if (platformTypes != other.platformTypes) return false
        if (requires != other.requires) return false
        if (reviewInformation != other.reviewInformation) return false
        if (reviewStatus != other.reviewStatus) return false
        if (schemaVersion != other.schemaVersion) return false
        if (sha1 != other.sha1) return false
        if (status != other.status) return false
        if (statusInformation != other.statusInformation) return false
        if (tags != other.tags) return false
        if (targetType != other.targetType) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.DocumentDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The version of the document currently approved for use in the organization.
         */
        public var approvedVersion: kotlin.String? = null
        /**
         * Details about the document attachments, including names, locations, sizes, and so on.
         */
        public var attachmentsInformation: List<AttachmentInformation>? = null
        /**
         * The user in your organization who created the document.
         */
        public var author: kotlin.String? = null
        /**
         * The classification of a document to help you identify and categorize its use.
         */
        public var category: List<String>? = null
        /**
         * The value that identifies a document's category.
         */
        public var categoryEnum: List<String>? = null
        /**
         * The date when the document was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The default version.
         */
        public var defaultVersion: kotlin.String? = null
        /**
         * A description of the document.
         */
        public var description: kotlin.String? = null
        /**
         * The friendly name of the SSM document. This value can differ for each version of the document. If you want to update this value, see UpdateDocument.
         */
        public var displayName: kotlin.String? = null
        /**
         * The document format, either JSON or YAML.
         */
        public var documentFormat: aws.sdk.kotlin.services.ssm.model.DocumentFormat? = null
        /**
         * The type of document.
         */
        public var documentType: aws.sdk.kotlin.services.ssm.model.DocumentType? = null
        /**
         * The document version.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * The Sha256 or Sha1 hash created by the system when the document was created.
         *
         * Sha1 hashes have been deprecated.
         */
        public var hash: kotlin.String? = null
        /**
         * The hash type of the document. Valid values include `Sha256` or `Sha1`.
         *
         * Sha1 hashes have been deprecated.
         */
        public var hashType: aws.sdk.kotlin.services.ssm.model.DocumentHashType? = null
        /**
         * The latest version of the document.
         */
        public var latestVersion: kotlin.String? = null
        /**
         * The name of the SSM document.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services user that created the document.
         */
        public var owner: kotlin.String? = null
        /**
         * A description of the parameters for a document.
         */
        public var parameters: List<DocumentParameter>? = null
        /**
         * The version of the document that is currently under review.
         */
        public var pendingReviewVersion: kotlin.String? = null
        /**
         * The list of operating system (OS) platforms compatible with this SSM document.
         */
        public var platformTypes: List<PlatformType>? = null
        /**
         * A list of SSM documents required by a document. For example, an `ApplicationConfiguration` document requires an `ApplicationConfigurationSchema` document.
         */
        public var requires: List<DocumentRequires>? = null
        /**
         * Details about the review of a document.
         */
        public var reviewInformation: List<ReviewInformation>? = null
        /**
         * The current status of the review.
         */
        public var reviewStatus: aws.sdk.kotlin.services.ssm.model.ReviewStatus? = null
        /**
         * The schema version.
         */
        public var schemaVersion: kotlin.String? = null
        /**
         * The SHA1 hash of the document, which you can use for verification.
         */
        public var sha1: kotlin.String? = null
        /**
         * The status of the SSM document.
         */
        public var status: aws.sdk.kotlin.services.ssm.model.DocumentStatus? = null
        /**
         * A message returned by Amazon Web Services Systems Manager that explains the `Status` value. For example, a `Failed` status might be explained by the `StatusInformation` message, "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."
         */
        public var statusInformation: kotlin.String? = null
        /**
         * The tags, or metadata, that have been applied to the document.
         */
        public var tags: List<Tag>? = null
        /**
         * The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [Amazon Web Services resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation User Guide*.
         */
        public var targetType: kotlin.String? = null
        /**
         * The version of the artifact associated with the document.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.DocumentDescription) : this() {
            this.approvedVersion = x.approvedVersion
            this.attachmentsInformation = x.attachmentsInformation
            this.author = x.author
            this.category = x.category
            this.categoryEnum = x.categoryEnum
            this.createdDate = x.createdDate
            this.defaultVersion = x.defaultVersion
            this.description = x.description
            this.displayName = x.displayName
            this.documentFormat = x.documentFormat
            this.documentType = x.documentType
            this.documentVersion = x.documentVersion
            this.hash = x.hash
            this.hashType = x.hashType
            this.latestVersion = x.latestVersion
            this.name = x.name
            this.owner = x.owner
            this.parameters = x.parameters
            this.pendingReviewVersion = x.pendingReviewVersion
            this.platformTypes = x.platformTypes
            this.requires = x.requires
            this.reviewInformation = x.reviewInformation
            this.reviewStatus = x.reviewStatus
            this.schemaVersion = x.schemaVersion
            this.sha1 = x.sha1
            this.status = x.status
            this.statusInformation = x.statusInformation
            this.tags = x.tags
            this.targetType = x.targetType
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.DocumentDescription = DocumentDescription(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
