// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the results of the execution preview.
 */
public class AutomationExecutionPreview private constructor(builder: Builder) {
    /**
     * Information about the Amazon Web Services Regions targeted by the execution preview.
     */
    public val regions: List<String>? = builder.regions
    /**
     * Information about the type of impact a runbook step would have on a resource.
     * + `Mutating`: The runbook step would make changes to the targets through actions that create, modify, or delete resources.
     * + `Non_Mutating`: The runbook step would retrieve data about resources but not make changes to them. This category generally includes `Describe*`, `List*`, `Get*`, and similar read-only API actions.
     * + `Undetermined`: An undetermined step invokes executions performed by another orchestration service like Lambda, Step Functions, or Amazon Web Services Systems Manager Run Command. An undetermined step might also call a third-party API. Systems Manager Automation doesn't know the outcome of the orchestration processes or third-party API executions, so the results of the steps are undetermined.
     */
    public val stepPreviews: Map<ImpactType, Int>? = builder.stepPreviews
    /**
     * Information that provides a preview of what the impact of running the specified Automation runbook would be.
     */
    public val targetPreviews: List<TargetPreview>? = builder.targetPreviews
    /**
     * Information about the Amazon Web Services accounts that were included in the execution preview.
     */
    public val totalAccounts: kotlin.Int = builder.totalAccounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.AutomationExecutionPreview = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomationExecutionPreview(")
        append("regions=$regions,")
        append("stepPreviews=$stepPreviews,")
        append("targetPreviews=$targetPreviews,")
        append("totalAccounts=$totalAccounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = regions?.hashCode() ?: 0
        result = 31 * result + (stepPreviews?.hashCode() ?: 0)
        result = 31 * result + (targetPreviews?.hashCode() ?: 0)
        result = 31 * result + (totalAccounts)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomationExecutionPreview

        if (regions != other.regions) return false
        if (stepPreviews != other.stepPreviews) return false
        if (targetPreviews != other.targetPreviews) return false
        if (totalAccounts != other.totalAccounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.AutomationExecutionPreview = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the Amazon Web Services Regions targeted by the execution preview.
         */
        public var regions: List<String>? = null
        /**
         * Information about the type of impact a runbook step would have on a resource.
         * + `Mutating`: The runbook step would make changes to the targets through actions that create, modify, or delete resources.
         * + `Non_Mutating`: The runbook step would retrieve data about resources but not make changes to them. This category generally includes `Describe*`, `List*`, `Get*`, and similar read-only API actions.
         * + `Undetermined`: An undetermined step invokes executions performed by another orchestration service like Lambda, Step Functions, or Amazon Web Services Systems Manager Run Command. An undetermined step might also call a third-party API. Systems Manager Automation doesn't know the outcome of the orchestration processes or third-party API executions, so the results of the steps are undetermined.
         */
        public var stepPreviews: Map<ImpactType, Int>? = null
        /**
         * Information that provides a preview of what the impact of running the specified Automation runbook would be.
         */
        public var targetPreviews: List<TargetPreview>? = null
        /**
         * Information about the Amazon Web Services accounts that were included in the execution preview.
         */
        public var totalAccounts: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.AutomationExecutionPreview) : this() {
            this.regions = x.regions
            this.stepPreviews = x.stepPreviews
            this.targetPreviews = x.targetPreviews
            this.totalAccounts = x.totalAccounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.AutomationExecutionPreview = AutomationExecutionPreview(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
