// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.waiters

import aws.sdk.kotlin.services.ssm.SsmClient
import aws.sdk.kotlin.services.ssm.model.GetCommandInvocationRequest
import aws.sdk.kotlin.services.ssm.model.GetCommandInvocationResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


public suspend fun SsmClient.waitUntilCommandExecuted(request: GetCommandInvocationRequest): Outcome<GetCommandInvocationResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetCommandInvocationRequest, GetCommandInvocationResponse>>(
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val status = it.status?.value
            status == "Pending"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val status = it.status?.value
            status == "InProgress"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val status = it.status?.value
            status == "Delayed"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "Success"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "Cancelled"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "TimedOut"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "Failed"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "Cancelling"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvocationDoesNotExist"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getCommandInvocation(request) }
}

public suspend fun SsmClient.waitUntilCommandExecuted(block: GetCommandInvocationRequest.Builder.() -> Unit): Outcome<GetCommandInvocationResponse> =
    waitUntilCommandExecuted(GetCommandInvocationRequest.Builder().apply(block).build())
