// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.OpsItemDataValue
import aws.sdk.kotlin.services.ssm.model.OpsItemNotification
import aws.sdk.kotlin.services.ssm.model.OpsItemStatus
import aws.sdk.kotlin.services.ssm.model.RelatedOpsItem
import aws.sdk.kotlin.services.ssm.model.UpdateOpsItemRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class UpdateOpsItemOperationSerializer: HttpSerialize<UpdateOpsItemRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateOpsItemRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateOpsItemOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateOpsItemOperationBody(context: ExecutionContext, input: UpdateOpsItemRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTUALENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ActualEndTime"))
    val ACTUALSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ActualStartTime"))
    val CATEGORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Category"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val NOTIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Notifications"))
    val OPERATIONALDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("OperationalData"))
    val OPERATIONALDATATODELETE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OperationalDataToDelete"))
    val OPSITEMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OpsItemArn"))
    val OPSITEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OpsItemId"))
    val PLANNEDENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("PlannedEndTime"))
    val PLANNEDSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("PlannedStartTime"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Priority"))
    val RELATEDOPSITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RelatedOpsItems"))
    val SEVERITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Severity"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Title"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTUALENDTIME_DESCRIPTOR)
        field(ACTUALSTARTTIME_DESCRIPTOR)
        field(CATEGORY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NOTIFICATIONS_DESCRIPTOR)
        field(OPERATIONALDATA_DESCRIPTOR)
        field(OPERATIONALDATATODELETE_DESCRIPTOR)
        field(OPSITEMARN_DESCRIPTOR)
        field(OPSITEMID_DESCRIPTOR)
        field(PLANNEDENDTIME_DESCRIPTOR)
        field(PLANNEDSTARTTIME_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
        field(RELATEDOPSITEMS_DESCRIPTOR)
        field(SEVERITY_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TITLE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.actualEndTime?.let { field(ACTUALENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.actualStartTime?.let { field(ACTUALSTARTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.category?.let { field(CATEGORY_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.notifications != null) {
            listField(NOTIFICATIONS_DESCRIPTOR) {
                for (el0 in input.notifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeOpsItemNotificationDocument))
                }
            }
        }
        if (input.operationalData != null) {
            mapField(OPERATIONALDATA_DESCRIPTOR) {
                input.operationalData.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeOpsItemDataValueDocument)) }
            }
        }
        if (input.operationalDataToDelete != null) {
            listField(OPERATIONALDATATODELETE_DESCRIPTOR) {
                for (el0 in input.operationalDataToDelete) {
                    serializeString(el0)
                }
            }
        }
        input.opsItemArn?.let { field(OPSITEMARN_DESCRIPTOR, it) }
        input.opsItemId?.let { field(OPSITEMID_DESCRIPTOR, it) }
        input.plannedEndTime?.let { field(PLANNEDENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.plannedStartTime?.let { field(PLANNEDSTARTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.priority?.let { field(PRIORITY_DESCRIPTOR, it) }
        if (input.relatedOpsItems != null) {
            listField(RELATEDOPSITEMS_DESCRIPTOR) {
                for (el0 in input.relatedOpsItems) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeRelatedOpsItemDocument))
                }
            }
        }
        input.severity?.let { field(SEVERITY_DESCRIPTOR, it) }
        input.status?.let { field(STATUS_DESCRIPTOR, it.value) }
        input.title?.let { field(TITLE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
