// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.sdk.kotlin.services.ssm.model.Target
import aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTargetResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateMaintenanceWindowTargetOperationDeserializer: HttpDeserialize<UpdateMaintenanceWindowTargetResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateMaintenanceWindowTargetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateMaintenanceWindowTargetError(context, call)
        }
        val builder = UpdateMaintenanceWindowTargetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateMaintenanceWindowTargetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateMaintenanceWindowTargetError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DoesNotExistException" -> DoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateMaintenanceWindowTargetOperationBody(builder: UpdateMaintenanceWindowTargetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OWNERINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OwnerInformation"))
    val TARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Targets"))
    val WINDOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WindowId"))
    val WINDOWTARGETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WindowTargetId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OWNERINFORMATION_DESCRIPTOR)
        field(TARGETS_DESCRIPTOR)
        field(WINDOWID_DESCRIPTOR)
        field(WINDOWTARGETID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OWNERINFORMATION_DESCRIPTOR.index -> builder.ownerInformation = deserializeString()
                TARGETS_DESCRIPTOR.index -> builder.targets =
                    deserializer.deserializeList(TARGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<Target>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTargetDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WINDOWID_DESCRIPTOR.index -> builder.windowId = deserializeString()
                WINDOWTARGETID_DESCRIPTOR.index -> builder.windowTargetId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
