// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateMaintenanceWindowOperationDeserializer: HttpDeserialize<UpdateMaintenanceWindowResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateMaintenanceWindowResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateMaintenanceWindowError(context, call)
        }
        val builder = UpdateMaintenanceWindowResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateMaintenanceWindowOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateMaintenanceWindowError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DoesNotExistException" -> DoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateMaintenanceWindowOperationBody(builder: UpdateMaintenanceWindowResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALLOWUNASSOCIATEDTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AllowUnassociatedTargets"))
    val CUTOFF_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Cutoff"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Duration"))
    val ENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Enabled"))
    val ENDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Schedule"))
    val SCHEDULEOFFSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ScheduleOffset"))
    val SCHEDULETIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ScheduleTimezone"))
    val STARTDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StartDate"))
    val WINDOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WindowId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWUNASSOCIATEDTARGETS_DESCRIPTOR)
        field(CUTOFF_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DURATION_DESCRIPTOR)
        field(ENABLED_DESCRIPTOR)
        field(ENDDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
        field(SCHEDULEOFFSET_DESCRIPTOR)
        field(SCHEDULETIMEZONE_DESCRIPTOR)
        field(STARTDATE_DESCRIPTOR)
        field(WINDOWID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWUNASSOCIATEDTARGETS_DESCRIPTOR.index -> builder.allowUnassociatedTargets = deserializeBoolean()
                CUTOFF_DESCRIPTOR.index -> builder.cutoff = deserializeInt()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DURATION_DESCRIPTOR.index -> builder.duration = deserializeInt()
                ENABLED_DESCRIPTOR.index -> builder.enabled = deserializeBoolean()
                ENDDATE_DESCRIPTOR.index -> builder.endDate = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SCHEDULE_DESCRIPTOR.index -> builder.schedule = deserializeString()
                SCHEDULEOFFSET_DESCRIPTOR.index -> builder.scheduleOffset = deserializeInt()
                SCHEDULETIMEZONE_DESCRIPTOR.index -> builder.scheduleTimezone = deserializeString()
                STARTDATE_DESCRIPTOR.index -> builder.startDate = deserializeString()
                WINDOWID_DESCRIPTOR.index -> builder.windowId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
